/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;

public final class LifecycleSupport {
    private Lifecycle lifecycle = null;
    private LifecycleListener[] listeners = new LifecycleListener[0];

    public LifecycleSupport(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        LifecycleListener[] lifecycleListenerArray = this.listeners;
        synchronized (lifecycleListenerArray) {
            LifecycleListener[] results = new LifecycleListener[this.listeners.length + 1];
            int i2 = 0;
            while (i2 < this.listeners.length) {
                results[i2] = this.listeners[i2];
                ++i2;
            }
            results[this.listeners.length] = listener;
            this.listeners = results;
        }
    }

    public void fireLifecycleEvent(String type, Object data) {
        LifecycleEvent event = new LifecycleEvent(this.lifecycle, type, data);
        LifecycleListener[] interested = null;
        LifecycleListener[] lifecycleListenerArray = this.listeners;
        synchronized (lifecycleListenerArray) {
            interested = (LifecycleListener[])this.listeners.clone();
        }
        int i2 = 0;
        while (i2 < interested.length) {
            interested[i2].lifecycleEvent(event);
            ++i2;
        }
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        LifecycleListener[] lifecycleListenerArray = this.listeners;
        synchronized (lifecycleListenerArray) {
            int n2 = -1;
            int i2 = 0;
            while (i2 < this.listeners.length) {
                if (this.listeners[i2] == listener) {
                    n2 = i2;
                    break;
                }
                ++i2;
            }
            if (n2 < 0) {
                Object var3_5 = null;
                return;
            }
            LifecycleListener[] results = new LifecycleListener[this.listeners.length - 1];
            int j2 = 0;
            int i3 = 0;
            while (i3 < this.listeners.length) {
                if (i3 != n2) {
                    results[j2++] = this.listeners[i3];
                }
                ++i3;
            }
            this.listeners = results;
        }
    }
}

