/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.CustomObjectInputStream;

public class JDBCStore
extends StoreBase
implements Store {
    protected static String info = "JDBCStore/1.0";
    protected static String storeName = "JDBCStore";
    protected String threadName = "JDBCStore";
    protected String connString = null;
    private Connection conn = null;
    protected String driverName = null;
    protected String sessionTable = "tomcat$sessions";
    protected String sessionIdCol = "id";
    protected String sessionDataCol = "data";
    protected String sessionValidCol = "valid";
    protected String sessionMaxInactiveCol = "maxinactive";
    protected String sessionLastAccessedCol = "lastaccess";
    protected PreparedStatement preparedSizeSql = null;
    protected PreparedStatement preparedKeysSql = null;
    protected PreparedStatement preparedSaveSql = null;
    protected PreparedStatement preparedClearSql = null;
    protected PreparedStatement preparedRemoveSql = null;
    protected PreparedStatement preparedLoadSql = null;

    public void clear() throws IOException {
        Connection _conn = this.getConnection();
        String clearSql = "DELETE FROM ".concat(this.sessionTable);
        if (_conn == null) {
            return;
        }
        try {
            try {
                if (this.preparedClearSql == null) {
                    this.preparedClearSql = _conn.prepareStatement(clearSql);
                }
                this.preparedClearSql.execute();
            }
            catch (SQLException e10) {
                this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".SQLException", e10));
            }
            Object var4_4 = null;
            this.release(_conn);
            _conn = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.release(_conn);
            _conn = null;
            throw throwable;
        }
    }

    protected Connection getConnection() {
        try {
            if (this.conn == null || this.conn.isClosed()) {
                Class.forName(this.driverName);
                this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".checkConnectionDBClosed"));
                this.conn = DriverManager.getConnection(this.connString);
                this.conn.setAutoCommit(true);
                if (this.conn == null || this.conn.isClosed()) {
                    this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".checkConnectionDBReOpenFail"));
                }
            }
        }
        catch (SQLException ex2) {
            this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".checkConnectionSQLException", ex2.toString()));
        }
        catch (ClassNotFoundException ex3) {
            this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".checkConnectionClassNotFoundException", ex3.toString()));
        }
        return this.conn;
    }

    public String getConnectionURL() {
        return this.connString;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getInfo() {
        return info;
    }

    public String getSessionDataCol() {
        return this.sessionDataCol;
    }

    public String getSessionIdCol() {
        return this.sessionIdCol;
    }

    public String getSessionLastAccessedCol() {
        return this.sessionLastAccessedCol;
    }

    public String getSessionMaxInactiveCol() {
        return this.sessionMaxInactiveCol;
    }

    public String getSessionTable() {
        return this.sessionTable;
    }

    public String getSessionValidCol() {
        return this.sessionValidCol;
    }

    public int getSize() throws IOException {
        int size = 0;
        String sizeSql = "SELECT COUNT(" + this.sessionIdCol + ") FROM ".concat(this.sessionTable);
        Connection _conn = this.getConnection();
        ResultSet rst = null;
        if (_conn == null) {
            return size;
        }
        try {
            try {
                if (this.preparedSizeSql == null) {
                    this.preparedSizeSql = _conn.prepareStatement(sizeSql);
                }
                if ((rst = this.preparedSizeSql.executeQuery()).next()) {
                    size = rst.getInt(1);
                }
            }
            catch (SQLException e10) {
                this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".SQLException", e10));
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (rst != null) {
                    rst.close();
                }
            }
            catch (SQLException sQLException) {}
            this.release(_conn);
            _conn = null;
            throw throwable;
        }
        try {
            if (rst != null) {
                rst.close();
            }
        }
        catch (SQLException sQLException) {}
        this.release(_conn);
        _conn = null;
        return size;
    }

    public String getStoreName() {
        return storeName;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String[] keys() throws IOException {
        String keysSql = "SELECT COUNT(s." + this.sessionIdCol + "), s." + this.sessionIdCol + " FROM " + this.sessionTable + " s, " + this.sessionTable + " c" + " GROUP BY c." + this.sessionIdCol;
        Connection _conn = this.getConnection();
        ResultSet rst = null;
        String[] keys = null;
        if (_conn == null) {
            return new String[0];
        }
        try {
            try {
                if (this.preparedKeysSql == null) {
                    this.preparedKeysSql = _conn.prepareStatement(keysSql);
                }
                if ((rst = this.preparedKeysSql.executeQuery()) != null && rst.next()) {
                    keys = new String[rst.getInt(1)];
                    keys[0] = rst.getString(2);
                    int i2 = 1;
                    while (rst.next()) {
                        keys[i2++] = rst.getString(2);
                    }
                } else {
                    keys = new String[]{};
                }
            }
            catch (SQLException e10) {
                this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".SQLException", e10));
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (rst != null) {
                    rst.close();
                }
            }
            catch (SQLException sQLException) {}
            this.release(_conn);
            _conn = null;
            throw throwable;
        }
        try {
            if (rst != null) {
                rst.close();
            }
        }
        catch (SQLException sQLException) {}
        this.release(_conn);
        _conn = null;
        return keys;
    }

    public Session load(String id) throws ClassNotFoundException, IOException {
        StandardSession _session;
        block25: {
            Object var12_12;
            ResultSet rst = null;
            Connection _conn = this.getConnection();
            _session = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            ObjectInputStream ois = null;
            BufferedInputStream bis = null;
            Container container = this.manager.getContainer();
            String loadSql = "SELECT " + this.sessionIdCol + ", " + this.sessionDataCol + " FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ?";
            if (_conn == null) {
                return null;
            }
            try {
                try {
                    if (this.preparedLoadSql == null) {
                        this.preparedLoadSql = _conn.prepareStatement(loadSql);
                    }
                    this.preparedLoadSql.setString(1, id);
                    rst = this.preparedLoadSql.executeQuery();
                    if (rst.next()) {
                        bis = new BufferedInputStream(rst.getBinaryStream(2));
                        if (container != null) {
                            loader = container.getLoader();
                        }
                        if (loader != null) {
                            classLoader = loader.getClassLoader();
                        }
                        ois = classLoader != null ? new CustomObjectInputStream(bis, classLoader) : new ObjectInputStream(bis);
                    } else if (this.debug > 0) {
                        this.log(String.valueOf(this.getStoreName()) + ": No persisted data object found");
                    }
                }
                catch (SQLException e10) {
                    this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".SQLException", e10));
                }
                var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (rst != null) {
                        rst.close();
                    }
                }
                catch (SQLException sQLException) {}
                this.release(_conn);
                _conn = null;
                throw throwable;
            }
            try {
                if (rst != null) {
                    rst.close();
                }
            }
            catch (SQLException sQLException) {}
            this.release(_conn);
            _conn = null;
            if (ois == null) break block25;
            try {
                _session = (StandardSession)this.manager.createSession();
                _session.readObjectData(ois);
                _session.setManager(this.manager);
            }
            catch (Throwable throwable) {
                var12_12 = null;
                if (ois != null) {
                    try {
                        ois.close();
                        bis = null;
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            var12_12 = null;
            if (ois != null) {
                try {
                    ois.close();
                    bis = null;
                }
                catch (IOException iOException) {}
            }
            if (this.debug > 0) {
                this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".loading", id, this.sessionTable));
            }
        }
        return _session;
    }

    protected void release(Connection conn) {
    }

    public void remove(String id) throws IOException {
        Connection _conn = this.getConnection();
        String removeSql = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ?";
        if (_conn == null) {
            return;
        }
        try {
            try {
                if (this.preparedRemoveSql == null) {
                    this.preparedRemoveSql = _conn.prepareStatement(removeSql);
                }
                this.preparedRemoveSql.setString(1, id);
                this.preparedRemoveSql.execute();
            }
            catch (SQLException e10) {
                this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".SQLException", e10));
            }
            Object var5_5 = null;
            this.release(_conn);
            _conn = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.release(_conn);
            _conn = null;
            throw throwable;
        }
        if (this.debug > 0) {
            this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".removing", id, this.sessionTable));
        }
    }

    public void save(Session session) throws IOException {
        InputStream in;
        ByteArrayInputStream bis;
        ByteArrayOutputStream bos;
        ObjectOutputStream oos;
        Connection _conn;
        block11: {
            String saveSql = "INSERT INTO " + this.sessionTable + " (" + this.sessionIdCol + ", " + this.sessionDataCol + ", " + this.sessionValidCol + ", " + this.sessionMaxInactiveCol + ", " + this.sessionLastAccessedCol + ") VALUES (?, ?, ?, ?, ?)";
            _conn = this.getConnection();
            oos = null;
            bos = null;
            bis = null;
            in = null;
            if (_conn == null) {
                return;
            }
            this.remove(session.getId());
            try {
                try {
                    bos = new ByteArrayOutputStream();
                    oos = new ObjectOutputStream(new BufferedOutputStream(bos));
                    ((StandardSession)session).writeObjectData(oos);
                    oos.close();
                    byte[] obs = bos.toByteArray();
                    int size = obs.length;
                    bis = new ByteArrayInputStream(obs, 0, size);
                    in = new BufferedInputStream(bis, size);
                    if (this.preparedSaveSql == null) {
                        this.preparedSaveSql = _conn.prepareStatement(saveSql);
                    }
                    this.preparedSaveSql.setString(1, session.getId());
                    this.preparedSaveSql.setBinaryStream(2, in, size);
                    this.preparedSaveSql.setString(3, session.isValid() ? "1" : "0");
                    this.preparedSaveSql.setInt(4, session.getMaxInactiveInterval());
                    this.preparedSaveSql.setLong(5, session.getLastAccessedTime());
                    this.preparedSaveSql.execute();
                }
                catch (SQLException e10) {
                    this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".SQLException", e10));
                }
                catch (IOException iOException) {
                }
                Object var9_11 = null;
                if (bis == null) break block11;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (bis != null) {
                    bis.close();
                }
                if (in != null) {
                    in.close();
                }
                bis = null;
                bos = null;
                oos = null;
                in = null;
                this.release(_conn);
                _conn = null;
                throw throwable;
            }
            bis.close();
        }
        if (in != null) {
            in.close();
        }
        bis = null;
        bos = null;
        oos = null;
        in = null;
        this.release(_conn);
        _conn = null;
        if (this.debug > 0) {
            this.log(this.sm.getString(String.valueOf(this.getStoreName()) + ".saving", session.getId(), this.sessionTable));
        }
    }

    public void setConnectionURL(String connectionURL) {
        String oldConnString = this.connString;
        this.connString = connectionURL;
        this.support.firePropertyChange("connString", oldConnString, this.connString);
    }

    public void setDriverName(String driverName) {
        String oldDriverName = this.driverName;
        this.driverName = driverName;
        this.support.firePropertyChange("driverName", oldDriverName, this.driverName);
        this.driverName = driverName;
    }

    public void setSessionDataCol(String sessionDataCol) {
        String oldSessionDataCol = this.sessionDataCol;
        this.sessionDataCol = sessionDataCol;
        this.support.firePropertyChange("sessionDataCol", oldSessionDataCol, this.sessionDataCol);
    }

    public void setSessionIdCol(String sessionIdCol) {
        String oldSessionIdCol = this.sessionIdCol;
        this.sessionIdCol = sessionIdCol;
        this.support.firePropertyChange("sessionIdCol", oldSessionIdCol, this.sessionIdCol);
    }

    public void setSessionLastAccessedCol(String sessionLastAccessedCol) {
        String oldSessionLastAccessedCol = this.sessionLastAccessedCol;
        this.sessionLastAccessedCol = sessionLastAccessedCol;
        this.support.firePropertyChange("sessionLastAccessedCol", oldSessionLastAccessedCol, this.sessionLastAccessedCol);
    }

    public void setSessionMaxInactiveCol(String sessionMaxInactiveCol) {
        String oldSessionMaxInactiveCol = this.sessionMaxInactiveCol;
        this.sessionMaxInactiveCol = sessionMaxInactiveCol;
        this.support.firePropertyChange("sessionMaxInactiveCol", oldSessionMaxInactiveCol, this.sessionMaxInactiveCol);
    }

    public void setSessionTable(String sessionTable) {
        String oldSessionTable = this.sessionTable;
        this.sessionTable = sessionTable;
        this.support.firePropertyChange("sessionTable", oldSessionTable, this.sessionTable);
    }

    public void setSessionValidCol(String sessionValidCol) {
        String oldSessionValidCol = this.sessionValidCol;
        this.sessionValidCol = sessionValidCol;
        this.support.firePropertyChange("sessionValidCol", oldSessionValidCol, this.sessionValidCol);
    }

    public void start() throws LifecycleException {
        super.start();
        this.conn = this.getConnection();
    }

    public void stop() throws LifecycleException {
        super.stop();
        if (this.conn != null) {
            try {
                this.conn.commit();
            }
            catch (SQLException sQLException) {}
            try {
                this.preparedSizeSql.close();
            }
            catch (SQLException sQLException) {}
            try {
                this.preparedKeysSql.close();
            }
            catch (SQLException sQLException) {}
            try {
                this.preparedSaveSql.close();
            }
            catch (SQLException sQLException) {}
            try {
                this.preparedClearSql.close();
            }
            catch (SQLException sQLException) {}
            try {
                this.preparedRemoveSql.close();
            }
            catch (SQLException sQLException) {}
            try {
                this.preparedLoadSql.close();
            }
            catch (SQLException sQLException) {}
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {}
            this.preparedSizeSql = null;
            this.preparedKeysSql = null;
            this.preparedSaveSql = null;
            this.preparedClearSql = null;
            this.preparedRemoveSql = null;
            this.preparedLoadSql = null;
            this.conn = null;
        }
    }
}

