/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.util.StringManager;

public final class ManagerServlet
extends HttpServlet {
    private Context context = null;
    private int debug = 1;
    private Deployer deployer = null;
    private static StringManager sm = StringManager.getManager("org.apache.catalina.servlets");

    public void destroy() {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String command = request.getPathInfo();
        if (command == null) {
            command = request.getServletPath();
        }
        String path = request.getParameter("path");
        String war = request.getParameter("war");
        response.setContentType("text/plain");
        PrintWriter writer = response.getWriter();
        if (command == null) {
            writer.println(sm.getString("managerServlet.noCommand"));
        } else if (command.equals("/install")) {
            this.install(writer, path, war);
        } else if (command.equals("/list")) {
            this.list(writer);
        } else if (command.equals("/reload")) {
            this.reload(writer, path);
        } else if (command.equals("/remove")) {
            this.remove(writer, path);
        } else if (command.equals("/sessions")) {
            this.sessions(writer, path);
        } else if (command.equals("/start")) {
            this.start(writer, path);
        } else if (command.equals("/stop")) {
            this.stop(writer, path);
        } else {
            writer.println(sm.getString("managerServlet.unknownCommand", command));
        }
        writer.flush();
        writer.close();
    }

    public void init() throws ServletException {
        String servletName = this.getServletConfig().getServletName();
        if (servletName == null) {
            servletName = "";
        }
        if (servletName.startsWith("org.apache.catalina.INVOKER.")) {
            throw new UnavailableException(sm.getString("managerServlet.cannotInvoke"));
        }
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable throwable) {}
        Wrapper wrapper = (Wrapper)((Object)this.getServletConfig());
        this.context = (Context)wrapper.getParent();
        this.deployer = (Deployer)this.context.getParent();
        if (this.debug >= 1) {
            this.log("init: Associated with Deployer '" + this.deployer.getName() + "'");
        }
    }

    private void install(PrintWriter writer, String path, String war) {
        if (this.debug >= 1) {
            this.log("install: Installing web application at '" + path + "' from '" + war + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", path));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        if (war == null || !war.startsWith("file:") && !war.startsWith("jar:")) {
            writer.println(sm.getString("managerServlet.invalidWar", war));
            return;
        }
        try {
            Context context = this.deployer.findDeployedApp(path);
            if (context != null) {
                writer.println(sm.getString("managerServlet.alreadyContext", displayPath));
                return;
            }
            this.deployer.install(path, new URL(war));
            writer.println(sm.getString("managerServlet.installed", displayPath));
        }
        catch (Throwable t2) {
            this.getServletContext().log("ManagerServlet.install[" + displayPath + "]", t2);
            writer.println(sm.getString("managerServlet.exception", t2.toString()));
        }
    }

    private void list(PrintWriter writer) {
        if (this.debug >= 1) {
            this.log("list: Listing contexts for virtual host '" + this.deployer.getName() + "'");
        }
        writer.println(sm.getString("managerServlet.listed", this.deployer.getName()));
        String[] contextPaths = this.deployer.findDeployedApps();
        int i2 = 0;
        while (i2 < contextPaths.length) {
            Context context = this.deployer.findDeployedApp(contextPaths[i2]);
            String displayPath = contextPaths[i2];
            if (displayPath.equals("")) {
                displayPath = "/";
            }
            if (context != null) {
                if (context.getAvailable()) {
                    writer.println(sm.getString("managerServlet.listitem", displayPath, "running", String.valueOf(context.getManager().findSessions().length)));
                } else {
                    writer.println(sm.getString("managerServlet.listitem", displayPath, "stopped", "0"));
                }
            }
            ++i2;
        }
    }

    private void reload(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("restart: Reloading web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", path));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", displayPath));
                return;
            }
            context.reload();
            writer.println(sm.getString("managerServlet.reloaded", displayPath));
        }
        catch (Throwable t2) {
            this.getServletContext().log("ManagerServlet.reload[" + displayPath + "]", t2);
            writer.println(sm.getString("managerServlet.exception", t2.toString()));
        }
    }

    private void remove(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("remove: Removing web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", path));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", displayPath));
                return;
            }
            this.deployer.remove(path);
            writer.println(sm.getString("managerServlet.removed", displayPath));
        }
        catch (Throwable t2) {
            this.getServletContext().log("ManagerServlet.remove[" + displayPath + "]", t2);
            writer.println(sm.getString("managerServlet.exception", t2.toString()));
        }
    }

    private void sessions(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("sessions: Session information for web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", path));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", displayPath));
                return;
            }
            writer.println(sm.getString("managerServlet.sessions", displayPath));
            writer.println(sm.getString("managerServlet.sessiondefaultmax", String.valueOf(context.getManager().getMaxInactiveInterval() / 60)));
            Session[] sessions = context.getManager().findSessions();
            int[] timeout = new int[60];
            int notimeout = 0;
            int i2 = 0;
            while (i2 < sessions.length) {
                int time = sessions[i2].getMaxInactiveInterval() / 600;
                if (time < 0) {
                    ++notimeout;
                } else if (time >= timeout.length) {
                    int n2 = timeout.length - 1;
                    timeout[n2] = timeout[n2] + 1;
                } else {
                    int n3 = time;
                    timeout[n3] = timeout[n3] + 1;
                }
                ++i2;
            }
            if (timeout[0] > 0) {
                writer.println(sm.getString("managerServlet.sessiontimeout", "<10" + timeout[0]));
            }
            int i3 = 1;
            while (i3 < timeout.length - 1) {
                if (timeout[i3] > 0) {
                    writer.println(sm.getString("managerServlet.sessiontimeout", i3 * 10 + " - <" + (i3 + 1) * 10, String.valueOf(timeout[i3])));
                }
                ++i3;
            }
            if (timeout[timeout.length - 1] > 0) {
                writer.println(sm.getString("managerServlet.sessiontimeout", ">=" + timeout.length * 10, String.valueOf(timeout[timeout.length - 1])));
            }
            if (notimeout > 0) {
                writer.println(sm.getString("managerServlet.sessiontimeout", "unlimited", String.valueOf(notimeout)));
            }
        }
        catch (Throwable t2) {
            this.getServletContext().log("ManagerServlet.sessions[" + displayPath + "]", t2);
            writer.println(sm.getString("managerServlet.exception", t2.toString()));
        }
    }

    private void start(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("start: Starting web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", path));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", displayPath));
                return;
            }
            this.deployer.start(path);
            writer.println(sm.getString("managerServlet.started", displayPath));
        }
        catch (Throwable t2) {
            this.getServletContext().log("ManagerServlet.start[" + displayPath + "]", t2);
            writer.println(sm.getString("managerServlet.exception", t2.toString()));
        }
    }

    private void stop(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("stop: Stopping web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", path));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = this.deployer.findDeployedApp(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", displayPath));
                return;
            }
            this.deployer.stop(path);
            writer.println(sm.getString("managerServlet.stopped", displayPath));
        }
        catch (Throwable t2) {
            this.getServletContext().log("ManagerServlet.stop[" + displayPath + "]", t2);
            writer.println(sm.getString("managerServlet.exception", t2.toString()));
        }
    }
}

