/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Manager;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.ValveContext;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

final class StandardContextValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardContextValve/1.0";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    StandardContextValve() {
    }

    private void badRequest(String requestURI, HttpServletResponse response) {
        try {
            requestURI = RequestUtil.filter(requestURI);
            response.setStatus(400);
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            writer.println("<html>");
            writer.println("<head>");
            writer.println("<title>Tomcat Error Report</title>");
            writer.println("<body bgcolor=\"white\">");
            writer.println("<br><br>");
            writer.println("<h1>HTTP Status 400 - " + requestURI + "</h1>");
            writer.println(sm.getString("standardContext.badRequest", requestURI));
            writer.println("</body>");
            writer.println("</html>");
            writer.flush();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {}
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext valveContext) throws IOException, ServletException {
        Session session;
        Manager manager;
        if (!(request.getRequest() instanceof HttpServletRequest) || !(response.getResponse() instanceof HttpServletResponse)) {
            return;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        String contextPath = hreq.getContextPath();
        String requestURI = hreq.getRequestURI();
        String relativeURI = requestURI.substring(contextPath.length()).toUpperCase();
        if (relativeURI.equals("/META-INF") || relativeURI.equals("/WEB-INF") || relativeURI.startsWith("/META-INF/") || relativeURI.startsWith("/WEB-INF/")) {
            this.notFound(requestURI, (HttpServletResponse)response.getResponse());
            try {
                response.finishResponse();
            }
            catch (IOException iOException) {}
            return;
        }
        StandardContext context = (StandardContext)this.getContainer();
        String sessionId = hreq.getRequestedSessionId();
        if (sessionId != null && (manager = context.getManager()) != null && (session = manager.findSession(sessionId)) != null && session.isValid()) {
            session.access();
        }
        Wrapper wrapper = null;
        try {
            wrapper = (Wrapper)context.map(request, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.badRequest(requestURI, (HttpServletResponse)response.getResponse());
            try {
                response.finishResponse();
            }
            catch (IOException iOException) {}
            return;
        }
        if (wrapper == null) {
            this.notFound(requestURI, (HttpServletResponse)response.getResponse());
            try {
                response.finishResponse();
            }
            catch (IOException iOException) {}
            return;
        }
        response.setContext(context);
        wrapper.invoke(request, response);
    }

    private void notFound(String requestURI, HttpServletResponse response) {
        try {
            requestURI = RequestUtil.filter(requestURI);
            response.setStatus(404);
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            writer.println("<html>");
            writer.println("<head>");
            writer.println("<title>Tomcat Error Report</title>");
            writer.println("<body bgcolor=\"white\">");
            writer.println("<br><br>");
            writer.println("<h1>HTTP Status 404 - " + requestURI + "</h1>");
            writer.println(sm.getString("standardContext.notFound", requestURI));
            writer.println("</body>");
            writer.println("</html>");
            writer.flush();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {}
    }
}

