/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

import java.io.IOException;
import org.apache.catalina.connector.ResponseStream;
import org.apache.catalina.connector.http.HttpResponseImpl;

public final class HttpResponseStream
extends ResponseStream {
    private static final int MAX_CHUNK_SIZE = 4096;
    private static final String CRLF = "\r\n";
    private boolean useChunking;
    private boolean writingChunk;

    public HttpResponseStream(HttpResponseImpl response) {
        super(response);
        this.checkChunking(response);
    }

    void checkChunking(HttpResponseImpl response) {
        if (this.count != 0) {
            return;
        }
        boolean bl2 = this.useChunking = !response.isCommitted() && response.getContentLength() == -1 && response.getStatus() != 304;
        if (!response.isChunkingAllowed() && this.useChunking) {
            response.addHeader("Connection", "close");
        } else {
            response.removeHeader("Connection", "close");
        }
        boolean bl3 = this.useChunking = this.useChunking && !response.isCloseConnection();
        if (this.useChunking) {
            response.addHeader("Transfer-Encoding", "chunked");
        } else {
            response.removeHeader("Transfer-Encoding", "chunked");
        }
    }

    public void close() throws IOException {
        if (this.useChunking) {
            this.writingChunk = true;
            this.print("0\r\n\r\n");
            this.writingChunk = false;
        }
        super.close();
    }

    public void write(int b10) throws IOException {
        if (this.useChunking && !this.writingChunk) {
            this.writingChunk = true;
            this.print("1\r\n");
            super.write(b10);
            this.println();
            this.writingChunk = false;
        } else {
            super.write(b10);
        }
    }

    public void write(byte[] b10, int off, int len) throws IOException {
        if (this.useChunking && !this.writingChunk) {
            if (len > 0) {
                this.writingChunk = true;
                this.println(Integer.toHexString(len));
                super.write(b10, off, len);
                this.println();
                this.writingChunk = false;
            }
        } else {
            super.write(b10, off, len);
        }
    }
}

