/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

final class HttpHeader {
    public static final int INITIAL_NAME_SIZE = 32;
    public static final int INITIAL_VALUE_SIZE = 64;
    public static final int MAX_NAME_SIZE = 128;
    public static final int MAX_VALUE_SIZE = 4096;
    public char[] name;
    public int nameEnd;
    public char[] value;
    public int valueEnd;
    protected int hashCode = 0;

    public HttpHeader() {
        this(new char[32], 0, new char[64], 0);
    }

    public HttpHeader(String name, String value) {
        this.name = name.toLowerCase().toCharArray();
        this.nameEnd = name.length();
        this.value = value.toCharArray();
        this.valueEnd = value.length();
    }

    public HttpHeader(char[] name, int nameEnd, char[] value, int valueEnd) {
        this.name = name;
        this.nameEnd = nameEnd;
        this.value = value;
        this.valueEnd = valueEnd;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.equals(((String)obj).toLowerCase());
        }
        if (obj instanceof HttpHeader) {
            return this.equals((HttpHeader)obj);
        }
        return false;
    }

    public boolean equals(String str) {
        return this.equals(str.toCharArray(), str.length());
    }

    public boolean equals(HttpHeader header) {
        return this.equals(header.name, header.nameEnd);
    }

    public boolean equals(char[] buf) {
        return this.equals(buf, buf.length);
    }

    public boolean equals(char[] buf, int end) {
        if (end != this.nameEnd) {
            return false;
        }
        int i2 = 0;
        while (i2 < end) {
            if (buf[i2] != this.name[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public int hashCode() {
        int h2 = this.hashCode;
        if (h2 == 0) {
            int off = 0;
            char[] val = this.name;
            int len = this.nameEnd;
            int i2 = 0;
            while (i2 < len) {
                h2 = 31 * h2 + val[off++];
                ++i2;
            }
            this.hashCode = h2;
        }
        return h2;
    }

    public boolean headerEquals(HttpHeader header) {
        return this.equals(header.name, header.nameEnd) && this.valueEquals(header.value, header.valueEnd);
    }

    public void recycle() {
        this.nameEnd = 0;
        this.valueEnd = 0;
        this.hashCode = 0;
    }

    public boolean valueEquals(String str) {
        return this.valueEquals(str.toCharArray(), str.length());
    }

    public boolean valueEquals(char[] buf) {
        return this.valueEquals(buf, buf.length);
    }

    public boolean valueEquals(char[] buf, int end) {
        if (end != this.valueEnd) {
            return false;
        }
        int i2 = 0;
        while (i2 < end) {
            if (buf[i2] != this.value[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public boolean valueIncludes(String str) {
        return this.valueIncludes(str.toCharArray(), str.length());
    }

    public boolean valueIncludes(char[] buf) {
        return this.valueIncludes(buf, buf.length);
    }

    public boolean valueIncludes(char[] buf, int end) {
        char firstChar = buf[0];
        int pos = 0;
        while (pos < this.valueEnd) {
            if ((pos = this.valueIndexOf(firstChar, pos)) == -1) {
                return false;
            }
            if (this.valueEnd - pos < end) {
                return false;
            }
            int i2 = 0;
            while (i2 < end) {
                if (this.value[i2 + pos] != buf[i2]) break;
                if (i2 == end - 1) {
                    return true;
                }
                ++i2;
            }
            ++pos;
        }
        return false;
    }

    public int valueIndexOf(char c10, int start) {
        int i2 = start;
        while (i2 < this.valueEnd) {
            if (this.value[i2] == c10) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }
}

