/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public class Cookie
implements Cloneable {
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");
    private String name;
    private String value;
    private String comment;
    private String domain;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private int version = 0;
    private static final String tspecials = ",;";

    public Cookie(String name, String value) {
        if (!this.isToken(name) || name.equalsIgnoreCase("Comment") || name.equalsIgnoreCase("Discard") || name.equalsIgnoreCase("Domain") || name.equalsIgnoreCase("Expires") || name.equalsIgnoreCase("Max-Age") || name.equalsIgnoreCase("Path") || name.equalsIgnoreCase("Secure") || name.equalsIgnoreCase("Version")) {
            String errMsg = lStrings.getString("err.cookie_name_is_token");
            Object[] errArgs = new Object[]{name};
            errMsg = MessageFormat.format(errMsg, errArgs);
            throw new IllegalArgumentException(errMsg);
        }
        this.name = name;
        this.value = value;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e10) {
            throw new RuntimeException(e10.getMessage());
        }
    }

    public String getComment() {
        return this.comment;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    private boolean isToken(String value) {
        int len = value.length();
        int i2 = 0;
        while (i2 < len) {
            char c10 = value.charAt(i2);
            if (c10 < ' ' || c10 >= '\u007f' || tspecials.indexOf(c10) != -1) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public void setComment(String purpose) {
        this.comment = purpose;
    }

    public void setDomain(String pattern) {
        this.domain = pattern.toLowerCase();
    }

    public void setMaxAge(int expiry) {
        this.maxAge = expiry;
    }

    public void setPath(String uri) {
        this.path = uri;
    }

    public void setSecure(boolean flag) {
        this.secure = flag;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public void setVersion(int v2) {
        this.version = v2;
    }
}

