/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.SubjectDomainCombiner;

public final class Subject
implements Serializable {
    private static final ResourceBundle rb = ResourceBundle.getBundle("com.sun.security.auth.Resources");
    Set principals;
    transient Set pubCredentials;
    transient Set privCredentials;
    private boolean readOnly = false;
    private static Constructor combiner_constructor;
    private static ClassLoader sysClassLoader;
    private static final int PRINCIPAL_SET = 1;
    private static final int PUB_CREDENTIAL_SET = 2;
    private static final int PRIV_CREDENTIAL_SET = 3;
    static /* synthetic */ Class class$javax$security$auth$Subject;

    public Subject() {
        this.principals = new SecureSet(1);
        this.pubCredentials = new SecureSet(2);
        this.privCredentials = new SecureSet(3);
    }

    public Subject(boolean bl2, Set set, Set set2, Set set3) {
        if (set == null || set2 == null || set3 == null) {
            throw new NullPointerException(rb.getString("invalid null input(s)"));
        }
        this.principals = new SecureSet(1, set);
        this.pubCredentials = new SecureSet(2, set2);
        this.privCredentials = new SecureSet(3, set3);
        this.readOnly = bl2;
    }

    public void setReadOnly() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("setReadOnly"));
        }
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public static Subject getSubject(final AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getSubject"));
        }
        if (accessControlContext == null) {
            throw new NullPointerException(rb.getString("invalid null AccessControlContext provided"));
        }
        return (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DomainCombiner domainCombiner = accessControlContext.getDomainCombiner();
                if (!(domainCombiner instanceof SubjectDomainCombiner)) {
                    return null;
                }
                SubjectDomainCombiner subjectDomainCombiner = (SubjectDomainCombiner)domainCombiner;
                return subjectDomainCombiner.getSubject();
            }
        });
    }

    public static Object doAs(Subject subject, PrivilegedAction privilegedAction) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAs"));
        }
        if (privilegedAction == null) {
            throw new NullPointerException(rb.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(privilegedAction, Subject.createContext(subject, accessControlContext));
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAs"));
        }
        if (privilegedExceptionAction == null) {
            throw new NullPointerException(rb.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(privilegedExceptionAction, Subject.createContext(subject, accessControlContext));
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAsPrivileged"));
        }
        if (privilegedAction == null) {
            throw new NullPointerException(rb.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext2 = accessControlContext == null ? new AccessControlContext(new ProtectionDomain[0]) : accessControlContext;
        return AccessController.doPrivileged(privilegedAction, Subject.createContext(subject, accessControlContext2));
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("doAsPrivileged"));
        }
        if (privilegedExceptionAction == null) {
            throw new NullPointerException(rb.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext2 = accessControlContext == null ? new AccessControlContext(new ProtectionDomain[0]) : accessControlContext;
        return AccessController.doPrivileged(privilegedExceptionAction, Subject.createContext(subject, accessControlContext2));
    }

    private static AccessControlContext createContext(final Subject subject, final AccessControlContext accessControlContext) {
        return (AccessControlContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (combiner_constructor == null) {
                    return new AccessControlContext(accessControlContext, new SubjectDomainCombiner(subject));
                }
                try {
                    Object[] objectArray = new Object[]{subject};
                    DomainCombiner domainCombiner = (DomainCombiner)combiner_constructor.newInstance(objectArray);
                    return new AccessControlContext(accessControlContext, domainCombiner);
                }
                catch (Exception exception) {
                    throw new SecurityException(exception.toString());
                }
            }
        });
    }

    public Set getPrincipals() {
        return this.principals;
    }

    public Set getPrincipals(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException(rb.getString("invalid null Class provided"));
        }
        return new ClassSet(1, clazz);
    }

    public Set getPublicCredentials() {
        return this.pubCredentials;
    }

    public Set getPrivateCredentials() {
        return this.privCredentials;
    }

    public Set getPublicCredentials(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException(rb.getString("invalid null Class provided"));
        }
        return new ClassSet(2, clazz);
    }

    public Set getPrivateCredentials(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException(rb.getString("invalid null Class provided"));
        }
        return new ClassSet(3, clazz);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof Subject) {
            Subject subject = (Subject)object;
            return this.getPrincipals().equals(subject.getPrincipals()) && this.getPublicCredentials().equals(subject.getPublicCredentials()) && this.getPrivateCredentials().equals(subject.getPrivateCredentials());
        }
        return false;
    }

    public String toString() {
        return this.toString(true);
    }

    /*
     * Unable to fully structure code
     */
    String toString(boolean var1_1) {
        block8: {
            var2_2 = new String(Subject.rb.getString("Subject:\n"));
            var3_3 = new String();
            var4_4 = this.getPrincipals().iterator();
            var5_5 = this.getPublicCredentials().iterator();
            var6_6 = null;
            if (var1_1) {
                try {
                    var6_6 = this.getPrivateCredentials().iterator();
                }
                catch (SecurityException var7_7) {}
            }
            while (var4_4.hasNext()) {
                var7_8 = (Principal)var4_4.next();
                var3_3 = var3_3 + Subject.rb.getString("\tPrincipal: ") + var7_8.toString() + Subject.rb.getString("\n");
            }
            while (var5_5.hasNext()) {
                var7_8 = var5_5.next();
                var3_3 = var3_3 + Subject.rb.getString("\tPublic Credential: ") + var7_8.toString() + Subject.rb.getString("\n");
            }
            if (var6_6 != null) ** GOTO lbl29
            var3_3 = var3_3 + Subject.rb.getString("\tPrivate Credentials inaccessible\n");
            break block8;
lbl-1000:
            // 1 sources

            {
                try {
                    var7_8 = var6_6.next();
                    var3_3 = var3_3 + Subject.rb.getString("\tPrivate Credential: ") + var7_8.toString() + Subject.rb.getString("\n");
                    continue;
                }
                catch (SecurityException var7_9) {
                    var3_3 = var3_3 + Subject.rb.getString("\tPrivate Credential inaccessible\n");
                    break;
                }
lbl29:
                // 2 sources

                ** while (var6_6.hasNext())
            }
        }
        return var2_2 + var3_3;
    }

    public int hashCode() {
        int n2 = 0;
        Iterator iterator = this.getPrincipals().iterator();
        Iterator iterator2 = this.getPublicCredentials().iterator();
        Iterator iterator3 = this.getPrivateCredentials().iterator();
        while (iterator.hasNext()) {
            Principal principal = (Principal)iterator.next();
            n2 ^= principal.hashCode();
        }
        while (iterator2.hasNext()) {
            n2 ^= this.getCredHashCode(iterator2.next());
        }
        while (iterator3.hasNext()) {
            n2 ^= this.getCredHashCode(iterator3.next());
        }
        return n2;
    }

    private int getCredHashCode(Object object) {
        try {
            return object.hashCode();
        }
        catch (IllegalStateException illegalStateException) {
            return object.getClass().toString().hashCode();
        }
    }

    private void sort(int[] nArray) {
        int n2 = 0;
        boolean bl2 = true;
        int n3 = nArray.length - 1;
        while (bl2) {
            n2 = 0;
            bl2 = false;
            while (n2 < n3) {
                if (nArray[n2] < nArray[n2 + 1]) {
                    bl2 = true;
                    int n4 = nArray[n2];
                    nArray[n2] = nArray[n2 + 1];
                    nArray[n2 + 1] = n4;
                }
                ++n2;
            }
            --n3;
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, NotActiveException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pubCredentials = new SecureSet(2);
        this.privCredentials = new SecureSet(3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (sysClassLoader == null) {
            Class clazz = class$javax$security$auth$Subject == null ? (class$javax$security$auth$Subject = Subject.class$("javax.security.auth.Subject")) : class$javax$security$auth$Subject;
            synchronized (clazz) {
                if (sysClassLoader == null) {
                    Object object;
                    sysClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return ClassLoader.getSystemClassLoader();
                        }
                    });
                    Class[] classArray = new Class[]{class$javax$security$auth$Subject == null ? (class$javax$security$auth$Subject = Subject.class$("javax.security.auth.Subject")) : class$javax$security$auth$Subject};
                    String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return Security.getProperty("combiner.provider");
                        }
                    });
                    if (string == null) {
                        string = "javax.security.auth.SubjectDomainCombiner";
                    } else {
                        object = System.getSecurityManager();
                        if (object != null) {
                            ((SecurityManager)object).checkPermission(new AuthPermission("specifyDomainCombiner"));
                        }
                    }
                    try {
                        object = Class.forName(string, true, sysClassLoader);
                        combiner_constructor = ((Class)object).getConstructor(classArray);
                    }
                    catch (Exception exception) {
                        throw new SecurityException(exception.toString());
                    }
                }
            }
        }
    }

    private class ClassSet
    extends AbstractSet {
        private int which;
        private Set set;
        private Class c;

        ClassSet(int n2, Class clazz) {
            ClassSet classSet = this;
            synchronized (classSet) {
                this.which = n2;
                this.c = clazz;
                Iterator iterator = null;
                switch (n2) {
                    case 1: {
                        iterator = Subject.this.principals.iterator();
                        break;
                    }
                    case 2: {
                        iterator = Subject.this.pubCredentials.iterator();
                        break;
                    }
                    default: {
                        iterator = Subject.this.privCredentials.iterator();
                    }
                }
                HashSet hashSet = new HashSet();
                while (iterator.hasNext()) {
                    Object e10 = iterator.next();
                    if (!clazz.isAssignableFrom(e10.getClass())) continue;
                    hashSet.add(e10);
                }
                this.set = new SecureSet(n2, hashSet);
            }
        }

        public synchronized int size() {
            return this.set.size();
        }

        public Iterator iterator() {
            return this.set.iterator();
        }

        public synchronized boolean add(Object object) {
            if (!object.getClass().isAssignableFrom(this.c)) {
                throw new SecurityException(rb.getString("attempting to add an object ") + rb.getString("which is not an instance of ") + this.c.toString());
            }
            return this.set.add(object);
        }
    }

    private class SecureSet
    extends AbstractSet
    implements Serializable {
        LinkedList elements;
        private int which;

        SecureSet(int n2) {
            this.which = n2;
            this.elements = new LinkedList();
        }

        SecureSet(int n2, Set set) {
            this.which = n2;
            this.elements = new LinkedList(set);
        }

        public synchronized int size() {
            return this.elements.size();
        }

        public Iterator iterator() {
            LinkedList linkedList = this.elements;
            return new Iterator(this, linkedList){
                ListIterator i;
                private final /* synthetic */ LinkedList val$list;
                private final /* synthetic */ SecureSet this$1;
                {
                    this.this$1 = secureSet;
                    this.val$list = linkedList;
                    this.i = this.val$list.listIterator(0);
                }

                public synchronized boolean hasNext() {
                    return this.i.hasNext();
                }

                public synchronized Object next() {
                    if (SecureSet.access$100(this.this$1) != 3) {
                        return this.i.next();
                    }
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        if (SecureSet.access$200(this.this$1).getPrincipals() == null || SecureSet.access$200(this.this$1).getPrincipals().size() == 0) {
                            securityManager.checkPermission(new PrivateCredentialPermission(this.val$list.get(this.i.nextIndex()).getClass().getName(), new HashSet<E>()));
                        } else {
                            securityManager.checkPermission(new PrivateCredentialPermission(PrivateCredentialPermission.buildTarget(this.val$list.get(this.i.nextIndex()).getClass().getName(), SecureSet.access$200(this.this$1).getPrincipals()), "read"));
                        }
                    }
                    return this.i.next();
                }

                public synchronized void remove() {
                    if (SecureSet.access$200(this.this$1).isReadOnly()) {
                        throw new IllegalStateException(Subject.access$300().getString("Subject is read-only"));
                    }
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        switch (SecureSet.access$100(this.this$1)) {
                            case 1: {
                                securityManager.checkPermission(new AuthPermission("modifyPrincipals"));
                                break;
                            }
                            case 2: {
                                securityManager.checkPermission(new AuthPermission("modifyPublicCredentials"));
                                break;
                            }
                            default: {
                                securityManager.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                            }
                        }
                    }
                    this.i.remove();
                }
            };
        }

        public synchronized boolean add(Object object) {
            if (Subject.this.isReadOnly()) {
                throw new IllegalStateException(rb.getString("Subject is read-only"));
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                switch (this.which) {
                    case 1: {
                        securityManager.checkPermission(new AuthPermission("modifyPrincipals"));
                        break;
                    }
                    case 2: {
                        securityManager.checkPermission(new AuthPermission("modifyPublicCredentials"));
                        break;
                    }
                    default: {
                        securityManager.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                    }
                }
            }
            switch (this.which) {
                case 1: {
                    if (object instanceof Principal) break;
                    throw new SecurityException(rb.getString("attempting to add an object ") + rb.getString("which is not an instance of ") + rb.getString("java.security.Principal ") + rb.getString("to a Subject's Principal Set"));
                }
            }
            if (!this.elements.contains(object)) {
                return this.elements.add(object);
            }
            return false;
        }

        static /* synthetic */ int access$100(SecureSet secureSet) {
            return secureSet.which;
        }

        static /* synthetic */ Subject access$200(SecureSet secureSet) {
            return secureSet.Subject.this;
        }
    }
}

