/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.search.SearchTerm;

public abstract class StringTerm
extends SearchTerm {
    protected String pattern;
    protected boolean ignoreCase;

    protected StringTerm(String string) {
        this.pattern = string;
        this.ignoreCase = true;
    }

    protected StringTerm(String string, boolean bl2) {
        this.pattern = string;
        this.ignoreCase = bl2;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    protected boolean match(String string) {
        int n2 = string.length() - this.pattern.length();
        int n3 = 0;
        while (n3 <= n2) {
            if (string.regionMatches(this.ignoreCase, n3, this.pattern, 0, this.pattern.length())) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StringTerm)) {
            return false;
        }
        StringTerm stringTerm = (StringTerm)object;
        if (this.ignoreCase) {
            return stringTerm.pattern.equalsIgnoreCase(this.pattern) && stringTerm.ignoreCase == this.ignoreCase;
        }
        return stringTerm.pattern.equals(this.pattern) && stringTerm.ignoreCase == this.ignoreCase;
    }

    public int hashCode() {
        return this.ignoreCase ? this.pattern.hashCode() : ~this.pattern.hashCode();
    }
}

