/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.Utility;
import com.sun.web.security.RealmAdapter;
import com.sun.web.security.SSLSocketFactory;
import com.sun.web.server.EmbeddedWebService;
import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import javax.naming.NamingException;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.logger.FileLogger;
import org.apache.catalina.startup.Embedded;

public class WebService {
    private static final String SSL_SOCKET_FACTORY = "com.sun.web.security.SSLSocketFactory";
    private static final boolean debug = false;
    private String docRoot = null;
    private File wDir = null;
    private Embedded embed = null;
    private Host host = null;

    public WebService(String hostname, String docRoot) {
        this.docRoot = docRoot;
        this.wDir = new File(FileUtil.getAbsolutePath("repository/" + hostname + "/web"));
        this.wDir.mkdirs();
        this.embed = new EmbeddedWebService();
        this.embed.setUseNaming(false);
        FileLogger logger = new FileLogger();
        String dir = System.getProperty("com.sun.enterprise.home") + File.separator + "logs" + File.separator + Utility.getLocalHost() + File.separator + "web";
        logger.setDirectory(dir);
        this.embed.setLogger(logger);
        Engine engine = this.embed.createEngine();
        if (engine instanceof StandardEngine) {
            ((StandardEngine)engine).setDefaultHost(hostname);
        }
        this.host = this.embed.createHost(hostname, docRoot);
        SingleSignOn sso = new SingleSignOn();
        ((StandardHost)this.host).addValve(sso);
        engine.addChild(this.host);
        Context root = this.embed.createContext("", docRoot);
        ((StandardContext)root).setWorkDir(this.wDir.toString());
        this.host.addChild(root);
        this.embed.addEngine(engine);
    }

    public Host getHost() {
        return this.host;
    }

    public Embedded getServer() {
        return this.embed;
    }

    public String getDocumentRoot() {
        return this.docRoot;
    }

    public Context addContext(String contextName, String docBase, WebBundleDescriptor wbd, ClassLoader cloader, File appFile) throws NamingException, MalformedURLException {
        Context ctx = this.getServer().createContext(contextName, docBase);
        if (cloader != null) {
            ctx.setParentClassLoader(cloader);
        }
        Loader loader = this.getServer().createLoader(ctx.getParentClassLoader());
        loader.setDelegate(true);
        loader.addRepository(appFile.toURL().toString());
        ctx.setLoader(loader);
        String scratchDir = this.wDir.toString() + contextName;
        ((StandardContext)ctx).setWorkDir(scratchDir);
        ctx.setRealm(new RealmAdapter(wbd));
        Switch.getSwitch().setDescriptorFor(ctx, wbd);
        Switch.getSwitch().getNamingManager().bindObjects(wbd);
        this.host.addChild(ctx);
        return ctx;
    }

    public Context getContext(String contextName) {
        Context ctx = (Context)this.host.findChild(contextName);
        return ctx;
    }

    public void removeContext(String contextName) {
        Context ctx = this.getContext(contextName);
        if (ctx != null) {
            this.getServer().removeContext(ctx);
        }
    }

    public void addConnector(int port, InetAddress addr, boolean secure) throws Exception {
        Connector connector = this.getServer().createConnector(addr, port, secure);
        if (secure) {
            SSLSocketFactory factory = new SSLSocketFactory();
            connector.setFactory(factory);
            System.out.println("Starting secure web service at port:" + port);
        } else {
            System.out.println("Starting web service at port:" + port);
        }
        this.getServer().addConnector(connector);
    }

    public void start() throws LifecycleException {
        this.getServer().start();
    }

    public static void main(String[] args) {
        try {
            String dir = System.getProperty("com.sun.enterprise.home") + File.separator + "public_html";
            String contextDir = dir + File.separator + "ServletToEjbContextRoot";
            WebService ws = new WebService("localhost", dir);
            ws.addConnector(8000, null, false);
            ws.start();
            ws.addContext("/ServletToEjbContextRoot", contextDir, null, null, new File("xxx"));
            try {
                Thread.sleep(120000L);
            }
            catch (InterruptedException e10) {}
        }
        catch (Exception e11) {
            e11.printStackTrace();
        }
    }
}

