/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.iiop.POAEJBORB;
import com.sun.enterprise.log.LogUtil;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.security.KeyTool;
import com.sun.enterprise.server.EJBServer;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.InvocationManagerImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import com.sun.web.server.HttpsURLStreamHandlerFactory;
import com.sun.web.server.ServletDeployer;
import com.sun.web.server.ServletDeployerImpl;
import com.sun.web.server.WebService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.util.Properties;

public final class WebServer {
    private static final String CATALINA_HOME = "catalina.home";
    private static final String CATALINA_NAMING = "catalina.useNaming";
    private static final String J2EE_HOME = "com.sun.enterprise.home";
    private static final String HTTP_PORT = "web.http.port";
    private static final String WEB_DOCUMENT_ROOT = "web.documentroot";
    private static final String HTTPS_PORT = "web.https.port";
    private static final String ENABLE_INVOKER = "web.enable.invoker";
    private static ServerConfiguration config;
    private static WebServer server;
    private static final LocalStringManagerImpl localStrings;
    private WebService webService;
    private ServletDeployer servletDeployer;
    static /* synthetic */ Class class$com$sun$web$server$WebServer;

    public static int getWebPort() {
        WebServer.initConfig();
        return Integer.parseInt(config.getProperty(HTTP_PORT));
    }

    public static int getSecurePort() {
        WebServer.initConfig();
        return Integer.parseInt(config.getProperty(HTTPS_PORT));
    }

    public static boolean isInvokerEnabled() {
        WebServer.initConfig();
        return Boolean.valueOf(config.getProperty(ENABLE_INVOKER, "false"));
    }

    public static String getDocumentRoot() {
        WebServer.initConfig();
        if (System.getProperty(WEB_DOCUMENT_ROOT) == null) {
            return config.getProperty(WEB_DOCUMENT_ROOT);
        }
        return System.getProperty(WEB_DOCUMENT_ROOT);
    }

    private static void initConfig() {
        config = ServerConfiguration.getConfiguration();
    }

    private WebServer() throws Exception {
        System.setProperty(CATALINA_HOME, System.getProperty(J2EE_HOME));
        System.setProperty(CATALINA_NAMING, "false");
        KeyTool.initProvider();
        URL.setURLStreamHandlerFactory(new HttpsURLStreamHandlerFactory());
        this.webService = new WebService(Utility.getLocalHost(), new File(FileUtil.getAbsolutePath(WebServer.getDocumentRoot())).toString());
        new Thread(new Runnable(){

            public void run() {
                new SecureRandom().nextBytes(new byte[1]);
            }
        }).start();
        this.initDeployer();
    }

    public static WebServer getInstance() {
        if (server == null) {
            Class clazz = class$com$sun$web$server$WebServer == null ? (class$com$sun$web$server$WebServer = WebServer.class$("com.sun.web.server.WebServer")) : class$com$sun$web$server$WebServer;
            synchronized (clazz) {
                try {
                    server = new WebServer();
                }
                catch (Exception e10) {
                    e10.printStackTrace();
                }
            }
        }
        return server;
    }

    public WebService getWebService() {
        return this.webService;
    }

    private void initDeployer() {
        try {
            this.servletDeployer = new ServletDeployerImpl(this);
        }
        catch (RemoteException re) {
            re.printStackTrace();
            throw new RuntimeException("Cannot start web server.");
        }
    }

    public ServletDeployer getDeployer() {
        return this.servletDeployer;
    }

    public void start() throws Exception {
        server.getWebService().addConnector(WebServer.getWebPort(), null, false);
        server.getWebService().addConnector(WebServer.getSecurePort(), null, true);
        this.webService.start();
        ((ServletDeployerImpl)this.servletDeployer).doActivate();
    }

    private static void initializeLogs() throws IOException {
        File dir = LogUtil.getLogDirectory("httpd", "web");
        LogUtil.initDefaultLogFiles(dir);
    }

    public static void main(String[] args) {
        Utility.checkJVMVersion();
        System.out.println(localStrings.getLocalString("web.server.started", "Starting the Web Server ..."));
        System.setSecurityManager(new J2EESecurityManager());
        try {
            Properties defaultProperties = new Properties();
            String propsFile = FileUtil.getAbsolutePath("config" + File.separator + "default.properties");
            FileInputStream fis = new FileInputStream(propsFile);
            defaultProperties.load(fis);
            fis.close();
            Properties props = new Properties();
            String recoverableStr = defaultProperties.getProperty("distributed.transaction.recovery");
            boolean recoverable = "true".equals(recoverableStr);
            EJBServer.initJTSProperties(recoverable, true, props);
            ORBManager.init(null, props);
            POAEJBORB orb = (POAEJBORB)ORBManager.getORB();
            String persServerIdStr = System.getProperty("com.sun.enterprise.activation.EJBServerId");
            orb.setPersistentServerId(Integer.parseInt(persServerIdStr));
            orb.setDaemonPort(ORBManager.getORBInitialPort());
            orb.initTransactionService("com.sun.jts.CosTransactions.DefaultTransactionService");
            WebServer.initializeLogs();
            Switch sw = Switch.getSwitch();
            InvocationManagerImpl im = new InvocationManagerImpl();
            sw.setInvocationManager(im);
            J2EETransactionManagerImpl tm = new J2EETransactionManagerImpl();
            sw.setTransactionManager(tm);
            NamingManagerImpl nm = new NamingManagerImpl();
            sw.setNamingManager(nm);
            if (recoverable) {
                System.err.println(localStrings.getLocalString("web.server.recovery", "Perform recovery of XAResources..."));
                ResourceInstaller installer = sw.getResourceInstaller();
                installer.recoverXAResources();
            }
            WebServer server = WebServer.getInstance();
            server.start();
        }
        catch (Exception e10) {
            e10.printStackTrace(System.err);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        server = null;
        localStrings = new LocalStringManagerImpl(class$com$sun$web$server$WebServer == null ? (class$com$sun$web$server$WebServer = WebServer.class$("com.sun.web.server.WebServer")) : class$com$sun$web$server$WebServer);
    }
}

