/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.util.ASCIIUtility;
import java.io.IOException;
import java.util.Vector;

public class IMAPResponse
extends Response {
    private String key;
    private int number;

    public IMAPResponse(Protocol protocol) throws IOException, ProtocolException {
        super(protocol);
        if (!(!this.isUnTagged() || this.isOK() || this.isNO() || this.isBAD() || this.isBYE())) {
            this.key = this.readAtom();
            try {
                this.number = Integer.parseInt(this.key);
                this.key = this.readAtom();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public IMAPResponse(IMAPResponse iMAPResponse) {
        super(iMAPResponse);
        this.key = iMAPResponse.key;
        this.number = iMAPResponse.number;
    }

    public String[] readSimpleList() {
        this.skipSpaces();
        if (this.buffer[this.index] != 40) {
            return null;
        }
        ++this.index;
        Vector<String> vector = new Vector<String>();
        int n2 = this.index;
        while (this.buffer[this.index] != 41) {
            if (this.buffer[this.index] == 32) {
                vector.addElement(ASCIIUtility.toString(this.buffer, n2, this.index));
                n2 = this.index + 1;
            }
            ++this.index;
        }
        if (this.index > n2) {
            vector.addElement(ASCIIUtility.toString(this.buffer, n2, this.index));
        }
        ++this.index;
        int n3 = vector.size();
        if (n3 > 0) {
            Object[] objectArray = new String[n3];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public boolean keyEquals(String string) {
        return this.key != null && this.key.equalsIgnoreCase(string);
    }

    public int getNumber() {
        return this.number;
    }

    public static IMAPResponse readResponse(Protocol protocol) throws IOException, ProtocolException {
        IMAPResponse iMAPResponse = new IMAPResponse(protocol);
        if (iMAPResponse.keyEquals("FETCH")) {
            iMAPResponse = new FetchResponse(iMAPResponse);
        }
        return iMAPResponse;
    }
}

