/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.ErrorLog;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.OrphanRollbackThread;
import com.sun.jts.CosTransactions.RecoveryManager;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;
import org.omg.CosTransactions.RecoveryCoordinatorPOA;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.PortableServer.POA;

class RecoveryCoordinatorImpl
extends RecoveryCoordinatorPOA {
    private static boolean recoverable = false;
    private static POA poa = null;
    private RecoveryCoordinator thisRef = null;
    private int internalSeq = 0;
    GlobalTID globalTID = null;

    RecoveryCoordinatorImpl(GlobalTID globalTID, int sequence) {
        this.globalTID = globalTID;
        this.internalSeq = sequence;
    }

    public void finalize() {
        this.globalTID = null;
        this.internalSeq = 0;
    }

    public Status replay_completion(Resource res) throws NotPrepared {
        Status result = Status.StatusRolledBack;
        CoordinatorImpl coord = RecoveryManager.getCoordinator(this.globalTID);
        if (coord != null) {
            try {
                result = coord.get_status();
            }
            catch (SystemException exc) {
                // empty catch block
            }
        }
        switch (result.value()) {
            case 0: 
            case 1: {
                try {
                    coord.rollback_only();
                }
                catch (Throwable exc) {
                    // empty catch block
                }
                throw new NotPrepared();
            }
            case 2: {
                result = Status.StatusUnknown;
                break;
            }
            case 8: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (coord != null) break;
                if (!Configuration.getProxyChecker().isProxy(res)) {
                    this.rollbackOrphan(res);
                    break;
                }
                try {
                    OrphanRollbackThread rollbackThread = new OrphanRollbackThread(this, (Resource)res._duplicate());
                    rollbackThread.start();
                }
                catch (SystemException exc) {}
                break;
            }
            default: {
                result = Status.StatusRolledBack;
            }
        }
        return result;
    }

    void rollbackOrphan(Resource res) {
        block2: {
            try {
                res.rollback();
            }
            catch (Throwable exc) {
                if (!(exc instanceof HeuristicCommit) && !(exc instanceof HeuristicMixed) && !(exc instanceof HeuristicHazard)) break block2;
                ErrorLog.warning(29, new java.lang.Object[]{exc.toString()});
            }
        }
        res._release();
    }

    RecoveryCoordinatorImpl(byte[] key) {
        byte[] tidBytes = new byte[key.length - 4];
        System.arraycopy(key, 4, tidBytes, 0, tidBytes.length);
        this.globalTID = new GlobalTID(tidBytes);
        RecoveryManager.waitForRecovery();
    }

    final synchronized RecoveryCoordinator object() {
        if (this.thisRef == null) {
            if (poa == null) {
                poa = Configuration.getPOA("RecoveryCoordinator");
                recoverable = Configuration.isRecoverable();
            }
            try {
                if (recoverable && this.globalTID != null) {
                    byte[] tidBytes = this.globalTID.toBytes();
                    byte[] id = new byte[tidBytes.length + 4];
                    System.arraycopy(tidBytes, 0, id, 4, tidBytes.length);
                    id[0] = (byte)this.internalSeq;
                    id[1] = (byte)(this.internalSeq >> 8);
                    id[2] = (byte)(this.internalSeq >> 16);
                    id[3] = (byte)(this.internalSeq >> 24);
                    poa.activate_object_with_id(id, this);
                    Object obj = poa.create_reference_with_id(id, RecoveryCoordinatorHelper.id());
                    this.thisRef = RecoveryCoordinatorHelper.narrow(obj);
                } else {
                    poa.activate_object(this);
                    Object obj = poa.servant_to_reference(this);
                    this.thisRef = RecoveryCoordinatorHelper.narrow(obj);
                }
            }
            catch (Exception exc) {
                ErrorLog.error(7, new java.lang.Object[]{"RecoveryCoordinator"}, true);
            }
        }
        return this.thisRef;
    }

    final synchronized void destroy() {
        try {
            if (poa != null && this.thisRef != null) {
                poa.deactivate_object(poa.reference_to_id(this.thisRef));
                this.thisRef = null;
            } else {
                POA rcPoa = null;
                rcPoa = poa == null ? Configuration.getPOA("RecoveryCoordinator") : poa;
                if (this.thisRef == null) {
                    rcPoa.deactivate_object(rcPoa.servant_to_id(this));
                } else {
                    rcPoa.deactivate_object(rcPoa.reference_to_id(this.thisRef));
                    this.thisRef = null;
                }
            }
        }
        catch (Exception exc) {
            ErrorLog.error(8, new java.lang.Object[]{"RecoveryCoordinator"}, false);
        }
        this.finalize();
    }
}

