/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.util;

import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import com.sun.jms.util.Waiter;
import com.sun.jms.util.WaiterManager;

public class WorkerThread
extends Thread {
    static Logger logger = Log.getLogger(3);
    private Waiter waiter = null;
    private WaiterManager manager = null;
    private int waitTimeout = 0;
    private volatile int state;
    private volatile boolean wakeupCalled = false;
    public static final int WORKING = 1;
    public static final int WAITING = 2;
    public static final int STOPPING = 3;
    private static int activeWorkers = 0;

    public WorkerThread(ThreadGroup threadGroup, String threadName, Waiter waiter, WaiterManager manager, int waitTimeout) {
        super(threadGroup, threadName);
        this.waiter = waiter;
        this.manager = manager;
        this.waitTimeout = waitTimeout;
        this.state = 1;
        ++activeWorkers;
    }

    public boolean isStopping() {
        return this.state == 3;
    }

    public void run() {
        Waiter waiter = this.waiter;
        synchronized (waiter) {
            boolean timedOut = false;
            try {
                while (!this.isStopping() && !timedOut) {
                    if (logger.isLogging(7)) {
                        logger.finest("Worker " + this.waiter.getName() + " calling manager.activityDetected()");
                    }
                    this.state = 1;
                    this.manager.activityDetected();
                    if (logger.isLogging(7)) {
                        logger.finest("Worker " + this.waiter.getName() + " calling wait()");
                    }
                    this.state = 2;
                    this.wakeupCalled = false;
                    this.waiter.wait(this.waitTimeout);
                    if (this.waitTimeout == 0 || this.wakeupCalled) continue;
                    timedOut = true;
                    if (!logger.isLogging(7)) continue;
                    logger.finest("Worker " + this.waiter.getName() + " timed out");
                }
            }
            catch (InterruptedException e10) {
                this.manager.activityDetected();
            }
            if (logger.isLogging(7)) {
                logger.finest("Worker " + this.waiter.getName() + " returning from run()");
            }
            --activeWorkers;
            this.waiter.worker = null;
        }
    }

    public void wakeup() {
        Waiter waiter = this.waiter;
        synchronized (waiter) {
            if (logger.isLogging(7)) {
                logger.finest("Worker " + this.waiter.getName() + " in wakeup()");
            }
            this.wakeupCalled = true;
            this.waiter.notifyAll();
        }
    }

    public void stopWorking() {
        if (logger.isLogging(7)) {
            logger.finest("Worker " + this.waiter.getName() + " in stopRunning()");
        }
        this.state = 3;
        this.wakeup();
    }

    public static int getActiveWorkers() {
        return activeWorkers;
    }
}

