/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.Acknowledgement;
import com.sun.jms.MessageImpl;
import com.sun.jms.XidImpl;
import com.sun.jms.service.ConnectionImpl;
import com.sun.jms.service.Consumer;
import com.sun.jms.service.ConsumerImpl;
import com.sun.jms.service.DBManager;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.JMSServiceImpl;
import com.sun.jms.service.SessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TxnContext {
    public static final Logger logger = Log.getLogger(1);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");
    XidImpl xid;
    String xidKey;
    int txnId;
    int lastFlag;
    int jdbcPrepareResult;
    int state;
    boolean firstEnd;
    private XAResource jdbcXAResource = null;
    private XAConnection jdbcXAConnection = null;
    private Connection jdbcConnection = null;
    private ArrayList txnAcknowledgements = new ArrayList();
    private ArrayList txnMessages = new ArrayList();
    private HashMap sessionList = new HashMap();
    static final int TXN_NULL = 0;
    static final int TXN_INIT = 1;
    static final int TXN_STARTED = 2;
    static final int TXN_ENDED = 3;
    static final int TXN_COMMITTED = 4;
    static final int TXN_PREPARED = 5;
    static final int TXN_ROLLEDBACK = 6;
    static final int TXN_RECOVERED = 7;
    static final int TXN_CLOSED = 8;
    private static JMSServiceImpl service = null;

    public static String flagToString(int flag) {
        switch (flag) {
            case 0: {
                return "TMNOFLAGS";
            }
            case 0x20000000: {
                return "TMFAIL";
            }
            case 0x8000000: {
                return "TMRESUME";
            }
            case 0x4000000: {
                return "TMSUCCESS";
            }
            case 0x2000000: {
                return "TMSUSPEND";
            }
            case 0x200000: {
                return "TMJOIN";
            }
            case 0x1000000: {
                return "TMSTARTRSCAN";
            }
            case 0x800000: {
                return "TMENDRSCAN";
            }
        }
        return "UNKNOWN FLAG: " + flag;
    }

    public static String stateToString(int txnState) {
        switch (txnState) {
            case 0: {
                return "TXN_NULL";
            }
            case 1: {
                return "TXN_INIT";
            }
            case 2: {
                return "TXN_STARTED";
            }
            case 3: {
                return "TXN_ENDED";
            }
            case 4: {
                return "TXN_COMMITTED";
            }
            case 5: {
                return "TXN_PREPARED";
            }
            case 6: {
                return "TXN_ROLLEDBACK";
            }
            case 7: {
                return "TXN_RECOVERED";
            }
        }
        return "UNKNOWN STATE: " + txnState;
    }

    public TxnContext(Xid xid, int id) throws XAException {
        this.xid = new XidImpl(xid);
        this.xidKey = this.xid.toString();
        this.lastFlag = 0;
        this.firstEnd = true;
        this.txnId = id;
        try {
            this.jdbcXAConnection = DBManager.getInstance().getXADBConnection();
            this.jdbcXAResource = this.jdbcXAConnection.getXAResource();
            this.jdbcConnection = this.jdbcXAConnection.getConnection();
            this.state = 1;
        }
        catch (SQLException es2) {
            this.state = 0;
            throw new XAException(MessageFormat.format(resource.getString("txncontext.get_connection_failure"), es2.getMessage()));
        }
    }

    public void start(int flag, SessionImpl session) throws JMSException, XAException {
        String sessionId = session.getGlobalyUniqueId();
        if (logger.isLogging(7)) {
            logger.finest("txnId=" + this.txnId + ", state=" + TxnContext.stateToString(this.state) + ", flag=" + TxnContext.flagToString(flag) + ", session=" + sessionId);
        }
        if (this.sessionList.containsKey(sessionId)) {
            logger.info("Session " + sessionId + " already started on xid: " + this.xidKey);
            throw new XAException(-5);
        }
        block0 : switch (this.state) {
            case 1: {
                switch (flag) {
                    case 0: {
                        break block0;
                    }
                    case 0x200000: {
                        logger.info("New branch can't be joined.");
                        throw new XAException(-5);
                    }
                    case 0x8000000: {
                        logger.info("New branch can't be resumed.");
                        throw new XAException(-5);
                    }
                }
                logger.info("Unknown flag while in INIT state:" + TxnContext.flagToString(flag));
                throw new XAException(-5);
            }
            case 2: {
                switch (flag) {
                    case 0: {
                        logger.info("TMNOFLAGS must be in first start for this transaction");
                        throw new XAException(-5);
                    }
                    case 0x200000: {
                        break block0;
                    }
                    case 0x8000000: {
                        break block0;
                    }
                }
                logger.info("Unknown flag while in STARTED state:" + TxnContext.flagToString(flag));
                throw new XAException(-5);
            }
            case 3: {
                switch (flag) {
                    case 0: {
                        logger.info("TMNOFLAGS can't follow an end.");
                        throw new XAException(-5);
                    }
                    case 0x200000: {
                        break block0;
                    }
                    case 0x8000000: {
                        break block0;
                    }
                }
                logger.info("Unknown flag:" + TxnContext.flagToString(flag));
                throw new XAException(-5);
            }
            default: {
                logger.info("Illegal state for a START:" + TxnContext.stateToString(this.state));
                throw new XAException(-6);
            }
        }
        this.sessionList.put(sessionId, new Integer(flag));
        session.xaStart(this.xid);
        this.lastFlag = flag;
        this.state = 2;
    }

    /*
     * Loose catch block
     */
    public void end(int flag, SessionImpl session, Collection acknowledgements) throws JMSException, XAException {
        Object v0;
        ArrayList msgList;
        block25: {
            int startFlag;
            Integer lastSessionFlag;
            msgList = new ArrayList(10);
            String sessionId = session.getGlobalyUniqueId();
            if (logger.isLogging(7)) {
                logger.finest("txnId=" + this.txnId + ", state=" + TxnContext.stateToString(this.state) + ", flag=" + TxnContext.flagToString(flag) + ", session=" + sessionId);
                logger.finest(acknowledgements, "acknowledgements");
            }
            if ((lastSessionFlag = (Integer)this.sessionList.remove(sessionId)) == null) {
                logger.info("Session " + sessionId + " not started on txnId: " + this.txnId);
                throw new XAException(-5);
            }
            block5 : switch (this.state) {
                case 2: {
                    switch (flag) {
                        case 0x4000000: {
                            break block5;
                        }
                        case 0x20000000: {
                            break block5;
                        }
                        case 0x2000000: {
                            break block5;
                        }
                    }
                    throw new XAException(-5);
                }
                default: {
                    logger.info("Illegal state for an END:" + TxnContext.stateToString(this.state));
                    throw new XAException(-6);
                }
            }
            if (this.firstEnd) {
                startFlag = 0;
                this.firstEnd = false;
            } else {
                startFlag = 0x200000;
            }
            int endFlag = 0x4000000;
            try {
                this.jdbcXAResource.start(this.xid, startFlag);
            }
            catch (XAException exa) {
                logger.info("Could not start DB transaction.");
                logger.info(exa);
                throw new XAException(-3);
            }
            session.xaEndSetup(this.jdbcConnection, msgList);
            this.storeSentMessages(session, msgList);
            this.storeAcks(session, acknowledgements);
            Object var12_11 = null;
            session.xaRestoreConnection();
            try {
                try {
                    this.jdbcXAResource.end(this.xid, endFlag);
                    v0 = null;
                    break block25;
                }
                catch (Throwable t2) {
                    logger.info("Could not end DB transaction.");
                    logger.info(t2);
                    throw new XAException(-3);
                }
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            {
                break block25;
                catch (JMSException je) {
                    logger.info("Could not commit msg and/or acks to db.");
                    logger.info(je);
                    endFlag = 0x20000000;
                    throw new XAException(-3);
                }
                catch (SQLException se) {
                    logger.info("Could not commit msg and/or acks to db.");
                    logger.info(se);
                    endFlag = 0x20000000;
                    throw new XAException(-3);
                }
            }
            catch (Throwable throwable) {
                Object v1;
                Object var12_12 = null;
                session.xaRestoreConnection();
                try {
                    try {
                        this.jdbcXAResource.end(this.xid, endFlag);
                        v1 = null;
                    }
                    catch (Throwable t2) {
                        logger.info("Could not end DB transaction.");
                        logger.info(t2);
                        throw new XAException(-3);
                    }
                }
                catch (Throwable throwable2) {
                    v1 = null;
                }
                Object var15_18 = v1;
                session.xaEndCleanup();
                this.txnAcknowledgements.addAll(acknowledgements);
                this.txnMessages.addAll(msgList);
                throw throwable;
            }
        }
        Object var15_17 = v0;
        session.xaEndCleanup();
        this.txnAcknowledgements.addAll(acknowledgements);
        this.txnMessages.addAll(msgList);
        this.lastFlag = flag;
        this.state = this.sessionList.size() == 0 && flag == 0x4000000 ? 3 : 2;
    }

    public void commit(boolean onePhase) throws XAException {
        if (logger.isLogging(7)) {
            logger.finest("txnId=" + this.txnId + ", state=" + TxnContext.stateToString(this.state) + ", onePhase=" + onePhase + "\n\tTransaction contains " + this.txnMessages.size() + " messages and " + this.txnAcknowledgements.size() + " acknowledgements.");
        }
        switch (this.state) {
            case 3: {
                if (!onePhase) {
                    logger.info("Attempt two phase commit without a prepare for txnId: " + this.txnId);
                    throw new XAException(-6);
                }
                if (this.lastFlag != 0x2000000) break;
                logger.info("Attempt to commit a suspended transaction for txnId: " + this.txnId);
                throw new XAException(-6);
            }
            case 5: {
                if (!onePhase) break;
                logger.info("Attempt one phase commit after a prepare for txnId: " + this.txnId);
                throw new XAException(-6);
            }
            case 7: {
                break;
            }
            case 2: {
                logger.info("Start without matching end for txnId: " + this.txnId);
                throw new XAException(-6);
            }
            default: {
                logger.info("Illegal state on txnId " + this.txnId + " for a commit. State: " + this.state);
                throw new XAException(-6);
            }
        }
        try {
            if (onePhase || this.jdbcPrepareResult == 0) {
                this.jdbcXAResource.commit(this.xid, onePhase);
            }
            if (this.state != 7) {
                this.restoreMessages(this.txnMessages);
            }
        }
        catch (Throwable t2) {
            logger.info("Commit fail.");
            logger.info(t2);
            throw new XAException(MessageFormat.format(resource.getString("txncontext.commit_fail"), t2.getMessage()));
        }
        this.state = 4;
    }

    public void rollback() throws XAException {
        if (logger.isLogging(7)) {
            logger.finest("txnId=" + this.txnId + ", state=" + TxnContext.stateToString(this.state));
        }
        switch (this.state) {
            case 1: {
                logger.info("Illegal state for a ROLLBACK:" + TxnContext.stateToString(this.state) + ", proceed anyway.");
                this.state = 6;
                return;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            case 7: {
                break;
            }
            default: {
                logger.info("Illegal state for a ROLLBACK:" + TxnContext.stateToString(this.state));
                throw new XAException(-6);
            }
        }
        try {
            this.jdbcXAResource.rollback(this.xid);
        }
        catch (Throwable t2) {
            logger.info("Database rollback failed.");
            logger.info(t2);
        }
        if (this.state != 7) {
            try {
                this.forgetSentMessages();
                this.redeliverAcknowledgedMessages();
            }
            catch (Throwable t3) {
                logger.info("Database rollback failed");
                logger.info(t3);
            }
        }
        this.state = 6;
    }

    public int prepare() throws XAException {
        int result;
        if (logger.isLogging(7)) {
            logger.finest("txnId=" + this.txnId + ", state=" + TxnContext.stateToString(this.state));
        }
        switch (this.state) {
            case 3: {
                if (this.lastFlag != 0x2000000) break;
                logger.info("Attempt to PREPARE a SUSPENDED txn for txnId: " + this.txnId);
                throw new XAException(-6);
            }
            case 2: {
                logger.info("Start without matching end for txnId: " + this.txnId);
                throw new XAException(-6);
            }
            default: {
                logger.info("Illegal state for a PREPARE:" + TxnContext.stateToString(this.state));
                throw new XAException(-6);
            }
        }
        try {
            this.jdbcPrepareResult = this.jdbcXAResource.prepare(this.xid);
            result = this.jdbcPrepareResult == 0 || this.txnMessages.size() > 0 || this.txnAcknowledgements.size() > 0 ? 0 : 3;
        }
        catch (Throwable t2) {
            logger.info("Failure preparing to db.");
            logger.info(t2);
            throw new XAException(-6);
        }
        this.lastFlag = result;
        this.state = 5;
        return result;
    }

    public void close() {
        if (logger.isLogging(7)) {
            logger.finest("txnId=" + this.txnId + ", state=" + TxnContext.stateToString(this.state));
        }
        switch (this.state) {
            case 1: {
                logger.info("No previous work for txnId= " + this.txnId + ", state= " + TxnContext.stateToString(this.state));
                break;
            }
            case 2: {
                logger.info("Incomplete work for txnId= " + this.txnId + ", state= " + TxnContext.stateToString(this.state));
                break;
            }
            case 6: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                logger.info("Illegal state for txnId= " + this.txnId + ", state= " + TxnContext.stateToString(this.state));
            }
        }
        this.xid = null;
        this.txnMessages.clear();
        this.txnAcknowledgements.clear();
        try {
            this.jdbcXAConnection.close();
        }
        catch (SQLException esql) {
            logger.info("Close failure.");
            logger.info(esql);
        }
        this.jdbcXAResource = null;
        this.state = 8;
    }

    public void printDebugInfo() {
        StringBuffer text = new StringBuffer(300);
        text.append("\n\tTxnId: " + this.txnId);
        text.append(", State: " + TxnContext.stateToString(this.state));
        text.append(", LastFlag: " + TxnContext.flagToString(this.lastFlag));
        text.append("\n\tTransaction contents:  Msgs: " + this.txnMessages.size());
        text.append(", Acks: " + this.txnAcknowledgements.size());
        text.append(", Sessions: " + this.sessionList.size());
        if (this.sessionList.size() > 0) {
            text.append("\n\tSession List");
            Iterator iter = this.sessionList.keySet().iterator();
            while (iter.hasNext()) {
                text.append("\n\t\t" + (String)iter.next());
            }
        }
        logger.debugInfo(text.toString());
    }

    public XidImpl getXid() {
        return this.xid;
    }

    public boolean recover() {
        if (this.state != 1) {
            logger.info("Attempt to recover a transaction that is not in the proper state: " + TxnContext.stateToString(this.state));
            return false;
        }
        this.jdbcPrepareResult = 0;
        this.state = 7;
        return true;
    }

    private void restoreMessages(ArrayList msgList) throws JMSException {
        JMSServiceImpl service = JMSServiceImpl.getInstance();
        Iterator iter = ((AbstractList)msgList).iterator();
        while (iter.hasNext()) {
            MessageImpl msg = (MessageImpl)iter.next();
            DestinationImpl localDest = service.getDestination(msg);
            localDest.addMessage(msg);
            service.addMessage(msg);
        }
    }

    private void storeSentMessages(SessionImpl session, Collection incomingMessages) throws JMSException {
        JMSServiceImpl service = JMSServiceImpl.getInstance();
        Iterator iter = incomingMessages.iterator();
        MessageImpl msg = null;
        while (iter.hasNext()) {
            msg = (MessageImpl)iter.next();
            if (!service.isPersistentMessage(msg)) continue;
            session.persistMessage(msg);
        }
    }

    private void storeAcks(SessionImpl session, Collection acknowledgements) throws JMSException, SQLException {
        Iterator iter = acknowledgements.iterator();
        while (iter.hasNext()) {
            Acknowledgement ack = (Acknowledgement)iter.next();
            session.acknowledgeMessage(ack);
        }
    }

    private void forgetSentMessages() {
        SessionImpl.clearMessages(this.txnMessages, true);
    }

    private void redeliverAcknowledgedMessages() {
        Acknowledgement ackMsg = null;
        MessageImpl msg = null;
        int count = this.txnAcknowledgements.size();
        int i2 = 0;
        while (i2 < count) {
            ackMsg = (Acknowledgement)this.txnAcknowledgements.get(i2);
            msg = ackMsg.getMessage();
            try {
                msg.setJMSRedelivered(true);
            }
            catch (JMSException ex2) {
                logger.info("Can't change delivery count.");
                logger.info(ex2);
            }
            if (msg.hasQueueDestination()) {
                DestinationImpl localDest = null;
                try {
                    localDest = this.getService().getDestination(msg);
                    localDest.addMessage(msg);
                    this.getService().addMessage(msg);
                }
                catch (Throwable t2) {
                    logger.info("Can't redeliver msg " + msg + "to destination " + localDest + " within rollback");
                    logger.info(t2);
                }
            } else {
                Consumer cons = this.getConsumer(msg);
                if (cons != null && cons.isActive()) {
                    try {
                        cons.sendLoggedMessage(msg);
                    }
                    catch (JMSException je) {
                        logger.info("Could not redeliver msg " + msg);
                        logger.info(je);
                    }
                }
            }
            ++i2;
        }
        this.txnAcknowledgements.clear();
    }

    JMSServiceImpl getService() {
        if (service == null) {
            service = JMSServiceImpl.getInstance();
        }
        return service;
    }

    Consumer getConsumer(MessageImpl msg) {
        ConsumerImpl cons = null;
        SessionImpl session = null;
        ConnectionImpl con = null;
        try {
            int consumerID;
            con = this.getService().getConnection(msg.getFactoryID(), msg.getConnectionID());
            if (con != null && (cons = con.getConnectionConsumer(consumerID = msg.getConsumerID())) == null) {
                session = con.getSession(msg.getSessionID());
                cons = session.getConsumer(consumerID);
            }
        }
        catch (JMSException je) {
            logger.info("Could not find consumer for msg " + msg);
        }
        return cons;
    }
}

