/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.MessageImpl;
import com.sun.jms.service.Consumer;
import com.sun.jms.service.DBManager;
import com.sun.jms.service.DurableSubscription;
import com.sun.jms.service.Subscription;
import com.sun.jms.util.JmsResourceBundle;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;

public class TopicSubscription
extends Subscription {
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");

    public TopicSubscription(Consumer c10) {
        super(c10);
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    protected Collection loadUnackedMessages() throws IllegalStateException {
        Connection con = null;
        Collection c10 = null;
        try {
            try {
                con = DBManager.getInstance().getDBConnection();
                c10 = this.loadUnackedMessages(con, this.parentConsumer.getClientID(), this.getSubscriptionName());
            }
            catch (SQLException sqle) {
                Subscription.logger.warning(sqle);
                Object var5_4 = null;
                DBManager.getInstance().closeDBConnection(con);
            }
            Object var5_3 = null;
            DBManager.getInstance().closeDBConnection(con);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DBManager.getInstance().closeDBConnection(con);
            throw throwable;
        }
        return c10;
    }

    protected String getStatementToDeleteUnackedMessage(String msgId) {
        String clientID = this.parentConsumer.getClientID();
        String subscriptionName = this.getSubscriptionName();
        String stmtStr = "DELETE FROM unacked_message WHERE msg_id = '" + msgId + "' AND " + "client_id" + " = '" + clientID + "' AND " + "subscription_name" + " = '" + subscriptionName + "'  ";
        return stmtStr;
    }

    public String getStatementToStoreUnackedMessage(MessageImpl msg) throws JMSException {
        String stmtStr = "INSERT INTO unacked_message VALUES ( '" + msg.getJMSMessageID() + "', '" + this.parentConsumer.getClientID() + "', '" + this.getSubscriptionName() + "', " + msg.getDeliveryCount() + ", " + "'pending'" + " ) ";
        return stmtStr;
    }

    protected void updateUnackedMessageDeliveryCount(MessageImpl msg) {
        block7: {
            Connection connection = null;
            try {
                try {
                    String msgId = msg.getJMSMessageID();
                    String clientID = this.parentConsumer.getClientID();
                    String subscriptionName = this.getSubscriptionName();
                    if (Subscription.logger.isLogging(6)) {
                        Subscription.logger.finer("\tDATABASE EVENT: attempting delete of subscription messages for consumer " + msgId + "." + DurableSubscription.getGlobalSubscriptionName(clientID, subscriptionName) + " from the db");
                    }
                    connection = DBManager.getInstance().getDBConnection();
                    int deliveryCount = msg.getDeliveryCount() + 1;
                    String stmtStr = "UPDATE unacked_message SET delivery_count = " + deliveryCount + " WHERE " + "msg_id" + " = '" + msgId + "' AND " + "client_id" + " = '" + clientID + "' AND " + "subscription_name" + " = '" + subscriptionName + "'  ";
                    Subscription.logger.finer(stmtStr);
                    DBManager.executeUpdate(connection, stmtStr);
                }
                catch (SQLException e10) {
                    if (Subscription.logger.isLogging(6)) {
                        Subscription.logger.finer("Error updating unacked_message in database because: " + e10);
                    }
                    Object var9_11 = null;
                    DBManager.getInstance().closeDBConnection(connection);
                    break block7;
                }
                catch (JMSException e11) {
                    Subscription.logger.warning(e11);
                    Object var9_12 = null;
                    DBManager.getInstance().closeDBConnection(connection);
                }
                Object var9_10 = null;
                DBManager.getInstance().closeDBConnection(connection);
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                DBManager.getInstance().closeDBConnection(connection);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private Collection loadUnackedMessages(Connection connection, String clientID, String subscriptionName) {
        ArrayList<MessageImpl> unackedMessages;
        block33: {
            SQLException e10222222;
            Connection localDBConnection;
            ResultSet rs;
            Statement stmt;
            block29: {
                block28: {
                    unackedMessages = new ArrayList<MessageImpl>();
                    if (Subscription.logger.isLogging(6)) {
                        Subscription.logger.finer("\tDATABASE EVENT: attempting load of unacked messages for consumer " + DurableSubscription.getGlobalSubscriptionName(clientID, subscriptionName) + " from the db");
                    }
                    stmt = null;
                    rs = null;
                    localDBConnection = null;
                    stmt = connection.createStatement();
                    String stmtStr = "SELECT * FROM message WHERE msg_id IN ( SELECT msg_id FROM unacked_message WHERE client_id = '" + clientID + "' AND " + "subscription_name" + " = '" + subscriptionName + "' ) " + "ORDER BY " + "msg_id" + " ASC ";
                    Subscription.logger.finer(stmtStr);
                    rs = DBManager.executeQuery(stmt, stmtStr);
                    localDBConnection = DBManager.getInstance().getDBConnection();
                    while (rs != null && rs.next()) {
                        MessageImpl msg = (MessageImpl)rs.getObject("msg_object");
                        int deliveryCount = TopicSubscription.getMessageDeliveryCount(localDBConnection, msg, clientID, subscriptionName);
                        msg.setDeliveryCount(deliveryCount);
                        try {
                            msg.setJMSRedelivered(true);
                        }
                        catch (JMSException jmse) {
                            Subscription.logger.warning(jmse);
                        }
                        unackedMessages.add(msg);
                    }
                    if (!Subscription.logger.isLogging(6)) break block28;
                    Subscription.logger.finer("Recovered " + unackedMessages.size() + " messages for TopicSubscriber " + subscriptionName + " from the db ");
                }
                Object var13_13 = null;
                if (rs == null) break block29;
                try {
                    rs.close();
                }
                catch (SQLException e10222222) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e10222222) {
                    // empty catch block
                }
            }
            if (localDBConnection != null) {
                try {
                    localDBConnection.close();
                }
                catch (SQLException e10222222) {}
            }
            break block33;
            {
                catch (SQLException e11) {
                    SQLException e10222222;
                    Subscription.logger.warning(e11);
                    Object var13_14 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e10222222) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e10222222) {
                            // empty catch block
                        }
                    }
                    if (localDBConnection != null) {
                        try {
                            localDBConnection.close();
                        }
                        catch (SQLException e10222222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException e10222222;
                Object var13_15 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e10222222) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e10222222) {
                        // empty catch block
                    }
                }
                if (localDBConnection != null) {
                    try {
                        localDBConnection.close();
                    }
                    catch (SQLException e10222222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return unackedMessages;
    }

    /*
     * Loose catch block
     */
    static int getMessageDeliveryCount(Connection connection, MessageImpl msg, String clientID, String subscriptionName) {
        int deliveryCount;
        block28: {
            SQLException e102222;
            ResultSet rs;
            Statement stmt;
            String msgId;
            block26: {
                block25: {
                    deliveryCount = 0;
                    msgId = null;
                    String destName = null;
                    stmt = null;
                    rs = null;
                    stmt = connection.createStatement();
                    msgId = msg.getJMSMessageID();
                    destName = msg.getDestinationName();
                    String stmtStr = "SELECT delivery_count FROM unacked_message WHERE msg_id = '" + msgId + "'  AND " + "client_id" + " = '" + clientID + "'  AND " + "subscription_name" + " = '" + destName + "'";
                    rs = DBManager.executeQuery(stmt, stmtStr);
                    if (rs != null && rs.next()) {
                        deliveryCount = rs.getInt("delivery_count");
                    }
                    if (!Subscription.logger.isLogging(6)) break block25;
                    Subscription.logger.finer("Loaded delivery count " + deliveryCount + " for msg " + msgId + " for TopicSubscriber " + DurableSubscription.getGlobalSubscriptionName(clientID, subscriptionName));
                }
                Object var12_11 = null;
                if (rs == null) break block26;
                try {
                    rs.close();
                }
                catch (SQLException e102222) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e102222) {}
            }
            break block28;
            {
                catch (SQLException e11) {
                    SQLException e102222;
                    if (Subscription.logger.isLogging(2)) {
                        Subscription.logger.warning(MessageFormat.format(resource.getString("topicsubscription.error_loading_deliverycount_for_msg"), msgId, DurableSubscription.getGlobalSubscriptionName(clientID, subscriptionName), e11.getMessage()));
                    }
                    Object var12_12 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e102222) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e102222) {}
                    }
                    break block28;
                }
                catch (JMSException e12) {
                    SQLException e102222;
                    if (Subscription.logger.isLogging(2)) {
                        Subscription.logger.warning(MessageFormat.format(resource.getString("topicsubscription.error_loading_deliverycount_for_msg"), msgId, DurableSubscription.getGlobalSubscriptionName(clientID, subscriptionName), e12.getMessage()));
                        Subscription.logger.warning(e12);
                    }
                    Object var12_13 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e102222) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e102222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException e102222;
                Object var12_14 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e102222) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e102222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return deliveryCount;
    }

    static void deleteUnackedMessagesForDurableSubscriber(Connection connection, String clientID, String subscriptionName) throws SQLException {
        Subscription.logger.finer("\tDATABASE EVENT: deleting ALL unacked_messages for durable consumer ");
        DBManager.executeUpdate(connection, "DELETE FROM unacked_message WHERE client_id = '" + clientID + "' AND " + "subscription_name" + " = '" + subscriptionName + "'  ");
    }

    /*
     * Loose catch block
     */
    public static boolean messageHasBeenAckedByAllSubscribers(Connection conn, MessageImpl msg) {
        boolean ackedByAll;
        String msgId;
        block24: {
            SQLException e10222;
            String stmtStr;
            ResultSet rs;
            Statement stmt;
            block22: {
                block21: {
                    msgId = null;
                    ackedByAll = true;
                    stmt = null;
                    rs = null;
                    stmtStr = null;
                    try {
                        msgId = msg.getJMSMessageID();
                    }
                    catch (JMSException je) {
                        // empty catch block
                    }
                    stmt = conn.createStatement(1003, 1007);
                    stmtStr = "SELECT COUNT(*) FROM unacked_message WHERE msg_id = '" + msgId + "' ";
                    Subscription.logger.finer(stmtStr);
                    rs = DBManager.executeQuery(stmt, stmtStr);
                    rs.next();
                    int count = rs.getInt(1);
                    if (count <= 0) break block21;
                    ackedByAll = false;
                }
                Object var9_10 = null;
                if (rs == null) break block22;
                try {
                    rs.close();
                }
                catch (SQLException e10222) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e10222) {}
            }
            break block24;
            {
                catch (SQLException e11) {
                    SQLException e10222;
                    if (Subscription.logger.isLogging(2)) {
                        Subscription.logger.warning(MessageFormat.format(resource.getString("topicsubscription.error_executing_statement"), stmtStr, msg.toString(), e11.getMessage()));
                        Subscription.logger.warning(e11);
                    }
                    ackedByAll = false;
                    Object var9_11 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e10222) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e10222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException e10222;
                Object var9_12 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e10222) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e10222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (Subscription.logger.isLogging(6)) {
            Subscription.logger.finer("messageHasBeenAckedByAllSubscribers(" + msgId + ") = " + ackedByAll);
        }
        return ackedByAll;
    }
}

