/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.MessageImpl;
import com.sun.jms.service.ConnectionImpl;
import com.sun.jms.service.ConsumerImpl;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.DurableSubscription;
import com.sun.jms.service.MessageConsumerImpl;
import com.sun.jms.service.SessionImpl;
import com.sun.jms.service.TopicSubscriberDurableSubscription;
import com.sun.jms.service.TopicSubscription;
import com.sun.jms.util.JmsResourceBundle;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.jms.IllegalStateException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class TopicSubscriberImpl
extends MessageConsumerImpl {
    TopicSubscription tSubscription = new TopicSubscription(this);
    TopicSubscriberDurableSubscription tsDurableSubscription = null;
    boolean noLocal = false;
    String clientID = null;
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");

    TopicSubscriberImpl(DestinationImpl dest, String clientID, String selectPattern, String subscriptionName, boolean noLocal) throws InvalidSelectorException, JMSException {
        super(dest, null, -1, selectPattern);
        this.clientID = clientID;
        this.tSubscription.setSubscriptionName(subscriptionName);
        this.noLocal = noLocal;
        this.tsDurableSubscription = new TopicSubscriberDurableSubscription(this, this.tSubscription, null);
    }

    TopicSubscriberImpl(DestinationImpl dest, SessionImpl parent, int id, String selectPattern, String subscriptionName, boolean noLocal) throws InvalidSelectorException, JMSException {
        super(dest, parent, id, selectPattern);
        this.tSubscription.setSubscriptionName(subscriptionName);
        this.noLocal = noLocal;
        this.tsDurableSubscription = new TopicSubscriberDurableSubscription(this, this.tSubscription, parent);
    }

    public synchronized void sendLoggedMessages() {
        block2: {
            try {
                this.tsDurableSubscription.sendLoggedMessages();
            }
            catch (JMSException e10) {
                if (!ConsumerImpl.logger.isLogging(2)) break block2;
                ConsumerImpl.logger.warning(MessageFormat.format(resource.getString("topicsubscriberimpl.could_not_recover_unacked_messages"), e10.getMessage()));
                ConsumerImpl.logger.warning(e10);
            }
        }
    }

    public void sendLoggedMessage(MessageImpl msg) throws JMSException, IllegalStateException {
        super.sendMessageInternal(msg);
    }

    public boolean isActive() {
        boolean active = true;
        if (this.isDurableSubscriber()) {
            active = this.tsDurableSubscription.isActive();
        }
        return active;
    }

    public boolean getNoLocal() throws IllegalStateException {
        return this.noLocal;
    }

    public void initializeDurableSubscription() throws JMSException {
        this.tsDurableSubscription.initialize();
    }

    public boolean isDurableSubscriber() {
        boolean isDurable = false;
        if (this.tSubscription.getSubscriptionName() != null) {
            isDurable = true;
        }
        return isDurable;
    }

    public void deleteDurableSubscription() throws JMSException {
        this.tsDurableSubscription.deleteDurableSubscription(this.getClientID(), this.getDestination());
    }

    public String getClientID() {
        String clientID = this.clientID;
        if (clientID == null) {
            clientID = super.getClientID();
        }
        return clientID;
    }

    private void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public boolean matches(String clientID, String subscriptionName) {
        boolean match = false;
        if (subscriptionName.equals(this.tSubscription.getSubscriptionName()) && clientID.equals(this.getClientID())) {
            match = true;
        }
        return match;
    }

    boolean isLocalMessage(MessageImpl msg) {
        boolean localMsg = false;
        if (this.parent != null) {
            ConnectionImpl connection = this.parent.getConnection();
            String myPclientId = connection.getPClientId();
            int connectionId = connection.getId();
            if (myPclientId.equals(msg.getFactoryID()) && connectionId == msg.getConnectionID()) {
                localMsg = true;
            }
        }
        return localMsg;
    }

    public void preSendProcessing(MessageImpl msg, Connection con) throws JMSException {
        if (!(this.noLocal && this.isLocalMessage(msg) || !SessionImpl.service.isPersistentMessage(msg) || !this.isDurableSubscriber() || msg.getJMSRedelivered())) {
            boolean storeSucceeded = false;
            try {
                int i2 = 1;
                while (!storeSucceeded && i2 < 11) {
                    block11: {
                        try {
                            this.tSubscription.storeUnackedMessage(con, msg);
                            storeSucceeded = true;
                        }
                        catch (SQLException se) {
                            if (ConsumerImpl.logger.isLogging(6)) {
                                ConsumerImpl.logger.finer(se);
                            }
                            if (i2 == 10) {
                                throw se;
                            }
                            try {
                                Thread.sleep(1000 * i2);
                            }
                            catch (Throwable t2) {
                                // empty catch block
                            }
                            if (!ConsumerImpl.logger.isLogging(5)) break block11;
                            ConsumerImpl.logger.fine("retry storing unacked entry for msg " + msg);
                        }
                    }
                    ++i2;
                }
            }
            catch (SQLException e10) {
                JMSException jmse = new JMSException(e10.getMessage());
                jmse.setLinkedException(e10);
                if (ConsumerImpl.logger.isLogging(2)) {
                    ConsumerImpl.logger.warning(MessageFormat.format(resource.getString("topicsubscriberimpl.dropped_delivery"), msg.toString(), DurableSubscription.getGlobalSubscriptionName(this.getClientID(), this.tSubscription.getSubscriptionName())));
                }
                throw jmse;
            }
        }
    }

    protected void sendMessageInternal(MessageImpl msg) throws JMSException {
        if (!(this.noLocal && this.isLocalMessage(msg) || !this.isActive())) {
            super.sendMessageInternal(msg);
        }
    }

    protected void performCloseActions() throws JMSException {
        super.performCloseActions();
        this.setClientID(this.getClientID());
        this.tsDurableSubscription.deactivate();
    }

    public void deliveredMessage(MessageImpl msg) {
        super.deliveredMessage(msg);
        boolean durable = this.isDurableSubscriber();
        if (durable) {
            try {
                if (SessionImpl.service.isPersistentMessage(msg)) {
                    this.tSubscription.updateUnackedMessageDeliveryCount(msg);
                }
            }
            catch (JMSException je) {
                ConsumerImpl.logger.warning(je);
            }
        }
    }

    public void acknowledgeMessage(MessageImpl msg) throws SQLException, JMSException {
        boolean durable = this.isDurableSubscriber();
        if (ConsumerImpl.logger.isLogging(7)) {
            ConsumerImpl.logger.finest(msg.toString() + "   durable = " + durable);
        }
        if (durable && SessionImpl.service.isPersistentMessage(msg)) {
            this.tSubscription.deleteUnackedMessage(this.parent.getDBConnection(), msg.getJMSMessageID());
        }
    }

    public static boolean messageHasBeenAckedByAllSubscribers(Connection con, MessageImpl msg) {
        return TopicSubscription.messageHasBeenAckedByAllSubscribers(con, msg);
    }

    boolean isRegisteredWithDestination() {
        return true;
    }

    public boolean awaitingSynchronousReceive() {
        return false;
    }

    public void deliverSynchronousMessage(MessageImpl msg) {
        ConsumerImpl.logger.warning(resource.getString("topicsubscriberimpl.not_implemented"));
    }

    public boolean presendToClient() {
        return true;
    }

    MessageImpl receive(long timeout) throws JMSException {
        throw new IllegalStateException(resource.getString("topicsubscriberimpl.receive_not_implemented"));
    }
}

