/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.JMSConstants;
import com.sun.jms.MessageImpl;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import javax.jms.JMSException;

public class SystemMessage
implements JMSConstants {
    public static final String CONTROL_EVENT_PROP = "SUN_ControlEvent";
    public static final String WAIT_FOR_WAKEUP_PROP = "SUN_WaitForWakeup";
    public static final int STOP_REQUEST_EVENT = 0;
    static Logger logger = Log.getLogger(1);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");

    public static MessageImpl createStopRequestMessage() throws JMSException {
        MessageImpl stopMessage = new MessageImpl();
        stopMessage.setIntProperty(CONTROL_EVENT_PROP, 0);
        stopMessage.setBooleanProperty(WAIT_FOR_WAKEUP_PROP, true);
        return stopMessage;
    }

    public static boolean isStopMessage(MessageImpl msg) {
        try {
            if (msg.propertyExists(CONTROL_EVENT_PROP) && msg.getIntProperty(CONTROL_EVENT_PROP) == 0) {
                return true;
            }
        }
        catch (JMSException e10) {
            logger.warning(e10);
        }
        return false;
    }

    public static void wakeup(MessageImpl stopMsg) {
        try {
            stopMsg.setBooleanProperty(WAIT_FOR_WAKEUP_PROP, false);
            stopMsg.notify();
            logger.finest("SystemMessage.wakeup() notify complete on message:");
        }
        catch (JMSException e10) {
            logger.warning(resource.getString("systemmessage.cant_wakeup_from_stop_message"));
            logger.warning(e10);
        }
    }

    public static void waitForWakeup(MessageImpl stopMsg) {
        try {
            logger.finest("SystemMessage.waitForWakeup() on message:");
            if (stopMsg.getBooleanProperty(WAIT_FOR_WAKEUP_PROP)) {
                logger.finest("SystemMessage.waitForWakeup(): about to wait");
                stopMsg.wait();
            }
            logger.finest("SystemMessage.waitForWakeup() return from wait");
        }
        catch (JMSException e10) {
            logger.warning(resource.getString("systemmessage.cant_wait_on_stop_message"));
            logger.warning(e10);
        }
        catch (InterruptedException ie) {
            logger.warning(resource.getString("systemmessage.cant_wait_on_stop_message"));
            logger.warning(ie);
        }
    }
}

