/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.JMSClient;
import com.sun.jms.service.JMSServiceImpl;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;

class ReaperThread
extends Thread {
    private HashMap clientMap = null;
    private JMSServiceImpl service = null;
    private int interval = 0;
    private static int MINUTE = 60000;

    public ReaperThread(ThreadGroup threadGroup, String threadName, HashMap clientMap, int interval, JMSServiceImpl service) {
        super(threadGroup, threadName);
        this.setPriority(1);
        this.clientMap = clientMap;
        this.service = service;
        this.interval = interval;
    }

    private void reap() {
        ArrayList clientMapKeySetClone = null;
        Iterator IDIter = null;
        String clientID = null;
        HashMap hashMap = this.clientMap;
        synchronized (hashMap) {
            clientMapKeySetClone = new ArrayList(this.clientMap.keySet());
        }
        IDIter = clientMapKeySetClone.iterator();
        JMSServiceImpl.logger.finest("looking for clients to reap...");
        while (IDIter.hasNext()) {
            clientID = (String)IDIter.next();
            HashMap hashMap2 = this.clientMap;
            synchronized (hashMap2) {
                JMSClient client = (JMSClient)this.clientMap.get(clientID);
                try {
                    if (client != null) {
                        try {
                            client.ping();
                        }
                        catch (NullPointerException npe) {
                            this.clientMap.remove(clientID);
                        }
                    }
                }
                catch (RemoteException re) {
                    try {
                        JMSServiceImpl.logger.warning(MessageFormat.format(JMSServiceImpl.resource.getString("jmsserviceimpl.reaping_client"), clientID));
                        this.service.deregisterClient(clientID);
                    }
                    catch (JMSException jmse) {
                        JMSServiceImpl.logger.warning(jmse);
                    }
                }
            }
            Thread.yield();
        }
    }

    public void run() {
        JMSServiceImpl.logger.finest("starting client reaper thread");
        while (true) {
            try {
                Thread.sleep(this.interval * MINUTE);
                HashMap hashMap = this.clientMap;
                synchronized (hashMap) {
                    if (this.clientMap.size() != 0) {
                        this.reap();
                    }
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

