/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.MessageImpl;
import com.sun.jms.service.Consumer;
import com.sun.jms.service.DBManager;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.Subscription;
import com.sun.jms.util.JmsResourceBundle;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;

public class QueueSubscription
extends Subscription {
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");

    public QueueSubscription(Consumer c10) {
        super(c10);
    }

    public String getSubscriptionName() {
        String name = "";
        DestinationImpl dest = this.parentConsumer.getDestination();
        name = dest.getName();
        return name;
    }

    protected Collection loadUnackedMessages() throws IllegalStateException {
        throw new IllegalStateException(resource.getString("queuesubscription.not_implemented_for_qs"));
    }

    protected String getStatementToDeleteUnackedMessage(String msgId) {
        String stmtStr = "DELETE FROM unacked_message WHERE msg_id = '" + msgId + "' ";
        return stmtStr;
    }

    public String getStatementToStoreUnackedMessage(MessageImpl msg) throws JMSException {
        String stmtStr = "INSERT INTO unacked_message VALUES ( '" + msg.getJMSMessageID() + "', '', '" + this.getSubscriptionName() + "', " + msg.getDeliveryCount() + ",  " + "'pending'" + " ) ";
        return stmtStr;
    }

    protected void updateUnackedMessageDeliveryCount(MessageImpl msg) {
        block11: {
            Connection conn = null;
            try {
                block10: {
                    try {
                        String msgId = msg.getJMSMessageID();
                        String subscriptionName = this.getSubscriptionName();
                        if (Subscription.logger.isLogging(6)) {
                            Subscription.logger.finer("DATABASE EVENT: attempting update unacked messages for consumer " + msgId + "." + subscriptionName + " in the db");
                        }
                        conn = DBManager.getInstance().getDBConnection();
                        int deliveryCount = msg.getDeliveryCount() + 1;
                        if (deliveryCount <= 1) {
                            this.storeUnackedMessage(conn, msg);
                            break block10;
                        }
                        String stmtStr = "UPDATE unacked_message SET delivery_count = " + deliveryCount + " WHERE " + "msg_id" + " = '" + msgId + "' AND " + "subscription_name" + " = '" + subscriptionName + "'  ";
                        Subscription.logger.finer(stmtStr);
                        int rowCount = DBManager.executeUpdate(conn, stmtStr);
                        if (rowCount == 0) {
                            // empty if block
                        }
                    }
                    catch (SQLException e10) {
                        if (Subscription.logger.isLogging(6)) {
                            Subscription.logger.finer("Can't update unacked_message in database beacuse: " + e10);
                        }
                        Object var9_11 = null;
                        DBManager.getInstance().closeDBConnection(conn);
                        break block11;
                    }
                    catch (JMSException e11) {
                        if (Subscription.logger.isLogging(2)) {
                            Subscription.logger.warning(MessageFormat.format(resource.getString("queuesubscription.cant_update_unacked_message_in_database"), e11.getMessage()));
                        }
                        Object var9_12 = null;
                        DBManager.getInstance().closeDBConnection(conn);
                    }
                }
                Object var9_10 = null;
                DBManager.getInstance().closeDBConnection(conn);
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                DBManager.getInstance().closeDBConnection(conn);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    static Collection loadUnackedMessages(Connection conn, String queueName) {
        ArrayList<MessageImpl> unackedMessages;
        block34: {
            SQLException e10222222;
            Connection localDBConnection;
            ResultSet rs;
            Statement stmt;
            block30: {
                block29: {
                    unackedMessages = new ArrayList<MessageImpl>();
                    if (Subscription.logger.isLogging(6)) {
                        Subscription.logger.finer("DATABASE EVENT: attempting load of unacked messages for Queue " + queueName + " from the db");
                    }
                    stmt = null;
                    rs = null;
                    localDBConnection = null;
                    stmt = conn.createStatement();
                    String stmtStr = "SELECT * FROM message WHERE dest_name = '" + queueName + "'  " + "ORDER BY " + "msg_id" + " ASC ";
                    Subscription.logger.finer(stmtStr);
                    rs = DBManager.executeQuery(stmt, stmtStr);
                    localDBConnection = DBManager.getInstance().getDBConnection();
                    while (rs != null && rs.next()) {
                        MessageImpl msg = (MessageImpl)rs.getObject("msg_object");
                        int deliveryCount = QueueSubscription.getMessageDeliveryCount(localDBConnection, msg);
                        msg.setDeliveryCount(deliveryCount);
                        try {
                            msg.setJMSRedelivered(true);
                        }
                        catch (JMSException jmse) {
                            Subscription.logger.warning(jmse);
                        }
                        unackedMessages.add(msg);
                    }
                    if (!Subscription.logger.isLogging(6)) break block29;
                    Subscription.logger.finer("Recovered " + unackedMessages.size() + " messages for Queue " + queueName + " from the db ");
                }
                Object var11_11 = null;
                if (rs == null) break block30;
                try {
                    rs.close();
                }
                catch (SQLException e10222222) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e10222222) {
                    // empty catch block
                }
            }
            if (localDBConnection != null) {
                try {
                    localDBConnection.close();
                }
                catch (SQLException e10222222) {}
            }
            break block34;
            {
                catch (SQLException e11) {
                    SQLException e10222222;
                    if (Subscription.logger.isLogging(2)) {
                        Subscription.logger.warning(MessageFormat.format(resource.getString("queuesubscription.cant_load_unacked_messages_for_queue"), queueName, e11.getMessage()));
                        Subscription.logger.warning(e11);
                    }
                    DBManager.printLocksDebugInfo(localDBConnection);
                    Object var11_12 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e10222222) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e10222222) {
                            // empty catch block
                        }
                    }
                    if (localDBConnection != null) {
                        try {
                            localDBConnection.close();
                        }
                        catch (SQLException e10222222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException e10222222;
                Object var11_13 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e10222222) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e10222222) {
                        // empty catch block
                    }
                }
                if (localDBConnection != null) {
                    try {
                        localDBConnection.close();
                    }
                    catch (SQLException e10222222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return unackedMessages;
    }

    static void deleteUnackedMessagesForQueue(Connection conn, String queueName) throws SQLException {
        if (Subscription.logger.isLogging(6)) {
            Subscription.logger.finer("DATABASE EVENT: deleting ALL unacked_messages for queue " + queueName);
        }
        DBManager.executeUpdate(conn, "DELETE FROM unacked_message WHERE subscription_name = '" + queueName + "'  ");
    }

    /*
     * Loose catch block
     */
    static int getMessageDeliveryCount(Connection conn, MessageImpl msg) {
        int deliveryCount;
        block28: {
            SQLException e102222;
            Statement stmt;
            ResultSet rs;
            String destName;
            String msgId;
            block26: {
                block25: {
                    deliveryCount = 0;
                    msgId = null;
                    destName = null;
                    rs = null;
                    stmt = null;
                    msgId = msg.getJMSMessageID();
                    destName = msg.getDestinationName();
                    String stmtStr = "SELECT delivery_count FROM unacked_message WHERE msg_id = '" + msgId + "'  AND " + "subscription_name" + " = '" + destName + "'";
                    Subscription.logger.finer(stmtStr);
                    stmt = conn.createStatement();
                    rs = DBManager.executeQuery(stmt, stmtStr);
                    if (rs != null && rs.next()) {
                        deliveryCount = rs.getInt("delivery_count");
                    }
                    if (!Subscription.logger.isLogging(6)) break block25;
                    Subscription.logger.finer("Loaded delivery count " + deliveryCount + " for msg " + msgId + " for Queue " + destName);
                }
                Object var10_9 = null;
                if (stmt == null) break block26;
                try {
                    stmt.close();
                }
                catch (SQLException e102222) {
                    // empty catch block
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e102222) {}
            }
            break block28;
            {
                catch (SQLException e11) {
                    SQLException e102222;
                    if (Subscription.logger.isLogging(2)) {
                        Subscription.logger.warning(MessageFormat.format(resource.getString("queuesubscription.cant_load_deliverycount_for_msg"), msgId, destName, e11.getMessage()));
                        Subscription.logger.warning(e11);
                    }
                    DBManager.printLocksDebugInfo(conn);
                    Object var10_10 = null;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e102222) {
                            // empty catch block
                        }
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e102222) {}
                    }
                    break block28;
                }
                catch (JMSException e12) {
                    SQLException e102222;
                    if (Subscription.logger.isLogging(2)) {
                        Subscription.logger.warning(MessageFormat.format(resource.getString("queuesubscription.cant_load_deliverycount_for_msg"), msgId, destName, e12.getMessage()));
                    }
                    Object var10_11 = null;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e102222) {
                            // empty catch block
                        }
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e102222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException e102222;
                Object var10_12 = null;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e102222) {
                        // empty catch block
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e102222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return deliveryCount;
    }
}

