/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.ConnectionFactoryImpl;
import com.sun.jms.client.ConnectionImpl;
import com.sun.jms.client.QueueSessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import javax.jms.ConnectionConsumer;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;

public class QueueConnectionImpl
extends ConnectionImpl
implements QueueConnection {
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    public QueueConnectionImpl(String user, String password, ConnectionFactoryImpl parent) throws JMSException {
        super(user, password, 0, parent);
    }

    public void sendMessage(int sessionID, int producerID, Message msg) throws JMSException {
        super.sendMessage(sessionID, producerID, msg);
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queueconnectionimpl.createqueuesession_on_closed_connection"));
        }
        QueueSessionImpl session = (QueueSessionImpl)this.createSession(0, transacted, acknowledgeMode, this);
        return session;
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("queueconnectionimpl.createconnectionconsumer_on_closed_connection"));
        }
        ConnectionConsumer consumer = this.createConnectionConsumer(queue, messageSelector, sessionPool, maxMessages, null);
        return consumer;
    }
}

