/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms;

import com.sun.jms.MessageImpl;
import com.sun.jms.util.JmsResourceBundle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;

public class ObjectMessageImpl
extends MessageImpl
implements ObjectMessage,
Serializable {
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.LocalStrings");
    byte[] body;
    transient byte[] deliveredBody;
    String className;
    transient String deliveredClassName;

    public ObjectMessageImpl() {
    }

    public ObjectMessageImpl(ObjectMessage msg) throws JMSException {
        super(msg);
        Serializable obj = null;
        try {
            obj = msg.getObject();
        }
        catch (JMSException e10) {
            MessageImpl.logger.warning(e10);
        }
        this.setObject(obj);
    }

    /*
     * WARNING - void declaration
     */
    public void setObject(Serializable object) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.close();
            this.body = baos.toByteArray();
            this.className = object != null ? object.getClass().getName() : "null";
        }
        catch (InvalidClassException e12) {
            void e22;
            MessageFormatException mfEx = new MessageFormatException(e12.getMessage());
            mfEx.setLinkedException(e12);
            throw e22;
        }
        catch (NotSerializableException e22) {
            MessageFormatException mfEx = new MessageFormatException(e22.getMessage());
            mfEx.setLinkedException(e22);
            throw mfEx;
        }
        catch (IOException e32) {
            MessageFormatException jmsEx = new MessageFormatException(e32.getMessage());
            jmsEx.setLinkedException(e32);
            throw jmsEx;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Serializable getObject() throws JMSException {
        Serializable o2 = null;
        if (this.body == null) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
            ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
            ObjectInputStreamLoader ois = new ObjectInputStreamLoader(bais, ctxClassLoader);
            o2 = (Serializable)ois.readObject();
            ois.close();
        }
        catch (ClassNotFoundException e12) {
            void e22;
            MessageFormatException mfEx = new MessageFormatException(e12.getMessage());
            mfEx.setLinkedException(e12);
            throw e22;
        }
        catch (InvalidClassException e22) {
            MessageFormatException mfEx = new MessageFormatException(e22.getMessage());
            mfEx.setLinkedException(e22);
            throw mfEx;
        }
        catch (StreamCorruptedException e32) {
            MessageFormatException mfEx = new MessageFormatException(e32.getMessage());
            mfEx.setLinkedException(e32);
            throw mfEx;
        }
        catch (OptionalDataException e42) {
            MessageFormatException mfEx = new MessageFormatException(e42.getMessage());
            mfEx.setLinkedException(e42);
            throw mfEx;
        }
        catch (IOException e52) {
            JMSException jmsEx = new JMSException(e52.getMessage());
            jmsEx.setLinkedException(e52);
            throw jmsEx;
        }
        return o2;
    }

    public MessageImpl getDeliveredMessage() {
        if (this.modifiedAfterDelivery()) {
            ObjectMessageImpl om = (ObjectMessageImpl)super.getDeliveredMessage();
            om.body = this.deliveredBody;
            om.className = this.deliveredClassName;
            return om;
        }
        return this;
    }

    public void clearBody() throws JMSException {
        if (this.hasBeenDelivered() && !this.isBodyModifiable()) {
            this.deliveredBody = this.body;
            this.deliveredClassName = this.className;
        }
        super.clearBody();
        this.body = null;
    }

    public String toString() {
        return super.toString() + ": contains a " + this.className;
    }

    static class ObjectInputStreamLoader
    extends ObjectInputStream {
        private ClassLoader loader;

        public ObjectInputStreamLoader(InputStream in, ClassLoader loader) throws IOException, StreamCorruptedException {
            super(in);
            this.loader = loader;
        }

        protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            try {
                return super.resolveClass(classDesc);
            }
            catch (ClassNotFoundException e10) {
                if (this.loader == null) {
                    throw e10;
                }
                return Class.forName(classDesc.getName(), true, this.loader);
            }
        }

        public ClassLoader getClassLoader() {
            return this.loader;
        }
    }
}

