/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms;

import com.sun.jms.MessageImpl;
import com.sun.jms.util.JmsResourceBundle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

public class MapMessageImpl
extends MessageImpl
implements MapMessage,
Serializable {
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.LocalStrings");
    private HashMap body;
    private transient HashMap deliveredBody;

    public MapMessageImpl() {
        this.init();
    }

    private void init() {
        this.body = new HashMap(11);
    }

    public MapMessageImpl(MapMessage msg) throws JMSException {
        super(msg);
        this.init();
        Enumeration e10 = msg.getMapNames();
        while (e10.hasMoreElements()) {
            String propName = (String)e10.nextElement();
            try {
                Object objProp = msg.getObject(propName);
                this.setObject(propName, objProp);
            }
            catch (JMSException ex2) {
                MessageImpl.logger.warning(ex2);
            }
        }
    }

    public Object clone() {
        MapMessageImpl msg = (MapMessageImpl)super.clone();
        if (this.isBodyModifiable() && this.body != null) {
            msg.body = (HashMap)this.body.clone();
        }
        return msg;
    }

    public void clearBody() throws JMSException {
        if (this.hasBeenDelivered() && !this.isBodyModifiable()) {
            this.deliveredBody = this.body;
        }
        super.clearBody();
        this.init();
    }

    public MessageImpl getDeliveredMessage() {
        if (this.modifiedAfterDelivery()) {
            MapMessageImpl mm = (MapMessageImpl)super.getDeliveredMessage();
            mm.body = this.deliveredBody;
            return mm;
        }
        return this;
    }

    public boolean getBoolean(String name) throws JMSException {
        boolean ret = false;
        Object value = this.body.get(name);
        if (value instanceof Boolean) {
            ret = (Boolean)value;
        } else if (value instanceof String || value == null) {
            ret = Boolean.valueOf((String)value);
        } else {
            throw new MessageFormatException(resource.getString("mapmessageimpl.invalid_type_conversion"));
        }
        return ret;
    }

    public byte getByte(String name) throws JMSException {
        byte ret = 0;
        Object value = this.body.get(name);
        if (value instanceof Byte) {
            ret = (Byte)value;
        } else if (value instanceof String || value == null) {
            ret = Byte.valueOf((String)value);
        } else {
            throw new MessageFormatException(resource.getString("mapmessageimpl.invalid_type_conversion"));
        }
        return ret;
    }

    public short getShort(String name) throws JMSException {
        short ret = 0;
        Object value = this.body.get(name);
        if (value instanceof Byte) {
            ret = ((Byte)value).byteValue();
        } else if (value instanceof Short) {
            ret = (Short)value;
        } else if (value instanceof String || value == null) {
            ret = Short.valueOf((String)value);
        } else {
            throw new MessageFormatException(resource.getString("mapmessageimpl.invalid_type_conversion"));
        }
        return ret;
    }

    public char getChar(String name) throws JMSException {
        char ret = '\u0000';
        Object value = this.body.get(name);
        if (value == null) {
            throw new NullPointerException(resource.getString("mapmessageimpl.attempted_to_read_null_value_as_char"));
        }
        if (!(value instanceof Character)) {
            throw new MessageFormatException(resource.getString("mapmessageimpl.invalid_type_conversion"));
        }
        ret = ((Character)value).charValue();
        return ret;
    }

    public int getInt(String name) throws JMSException {
        int ret = 0;
        Object value = this.body.get(name);
        if (value instanceof Byte) {
            ret = ((Byte)value).byteValue();
        } else if (value instanceof Short) {
            ret = ((Short)value).shortValue();
        } else if (value instanceof Integer) {
            ret = (Integer)value;
        } else if (value instanceof String || value == null) {
            ret = Integer.valueOf((String)value);
        } else {
            throw new MessageFormatException(resource.getString("mapmessageimpl.invalid_type_conversion"));
        }
        return ret;
    }

    public long getLong(String name) throws JMSException {
        long ret = 0L;
        Object value = this.body.get(name);
        if (value instanceof Byte) {
            ret = ((Byte)value).byteValue();
        } else if (value instanceof Short) {
            ret = ((Short)value).shortValue();
        } else if (value instanceof Integer) {
            ret = ((Integer)value).intValue();
        } else if (value instanceof Long) {
            ret = (Long)value;
        } else if (value instanceof String || value == null) {
            ret = Long.valueOf((String)value);
        } else {
            throw new MessageFormatException(resource.getString("mapmessageimpl.invalid_type_conversion"));
        }
        return ret;
    }

    public float getFloat(String name) throws JMSException {
        float ret = 0.0f;
        Object value = this.body.get(name);
        if (value instanceof Float) {
            ret = ((Float)value).floatValue();
        } else if (value instanceof String || value == null) {
            ret = Float.valueOf((String)value).floatValue();
        } else {
            throw new MessageFormatException(resource.getString("mapmessageimpl.invalid_type_conversion"));
        }
        return ret;
    }

    public double getDouble(String name) throws JMSException {
        double ret = 0.0;
        Object value = this.body.get(name);
        if (value instanceof Float) {
            ret = ((Float)value).floatValue();
        } else if (value instanceof Double) {
            ret = (Double)value;
        } else if (value instanceof String || value == null) {
            ret = Double.valueOf((String)value);
        } else {
            throw new MessageFormatException(resource.getString("mapmessageimpl.invalid_type_conversion"));
        }
        return ret;
    }

    public String getString(String name) throws JMSException {
        String ret = null;
        Object value = this.body.get(name);
        if (value == null) {
            return null;
        }
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String)) {
            throw new MessageFormatException(resource.getString("mapmessageimpl.invalid_type"));
        }
        ret = String.valueOf(value);
        return ret;
    }

    public byte[] getBytes(String name) throws JMSException {
        byte[] ret = null;
        Object value = this.body.get(name);
        if (value == null) {
            return null;
        }
        if (!(value instanceof byte[])) {
            throw new MessageFormatException(resource.getString("mapmessageimpl.invalid_type"));
        }
        ret = (byte[])value;
        return ret;
    }

    public Object getObject(String name) throws JMSException {
        return this.body.get(name);
    }

    public Enumeration getMapNames() throws JMSException {
        Vector v2 = new Vector(this.body.keySet());
        return v2.elements();
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        if (this.isBodyModifiable()) {
            try {
                this.body.put(name, new Boolean(value));
            }
            catch (NullPointerException e10) {
                JMSException jmsEx = new JMSException(((Throwable)e10).getMessage());
                jmsEx.setLinkedException(e10);
                throw jmsEx;
            }
        } else {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
    }

    public void setByte(String name, byte value) throws JMSException {
        if (this.isBodyModifiable()) {
            try {
                this.body.put(name, new Byte(value));
            }
            catch (NullPointerException e10) {
                JMSException jmsEx = new JMSException(((Throwable)e10).getMessage());
                jmsEx.setLinkedException(e10);
                throw jmsEx;
            }
        } else {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
    }

    public void setShort(String name, short value) throws JMSException {
        if (this.isBodyModifiable()) {
            try {
                this.body.put(name, new Short(value));
            }
            catch (NullPointerException e10) {
                JMSException jmsEx = new JMSException(((Throwable)e10).getMessage());
                jmsEx.setLinkedException(e10);
                throw jmsEx;
            }
        } else {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
    }

    public void setChar(String name, char value) throws JMSException {
        if (this.isBodyModifiable()) {
            try {
                this.body.put(name, new Character(value));
            }
            catch (NullPointerException e10) {
                JMSException jmsEx = new JMSException(((Throwable)e10).getMessage());
                jmsEx.setLinkedException(e10);
                throw jmsEx;
            }
        } else {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
    }

    public void setInt(String name, int value) throws JMSException {
        if (this.isBodyModifiable()) {
            try {
                this.body.put(name, new Integer(value));
            }
            catch (NullPointerException e10) {
                JMSException jmsEx = new JMSException(((Throwable)e10).getMessage());
                jmsEx.setLinkedException(e10);
                throw jmsEx;
            }
        } else {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
    }

    public void setLong(String name, long value) throws JMSException {
        if (this.isBodyModifiable()) {
            try {
                this.body.put(name, new Long(value));
            }
            catch (NullPointerException e10) {
                JMSException jmsEx = new JMSException(((Throwable)e10).getMessage());
                jmsEx.setLinkedException(e10);
                throw jmsEx;
            }
        } else {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
    }

    public void setFloat(String name, float value) throws JMSException {
        if (this.isBodyModifiable()) {
            try {
                this.body.put(name, new Float(value));
            }
            catch (NullPointerException e10) {
                JMSException jmsEx = new JMSException(((Throwable)e10).getMessage());
                jmsEx.setLinkedException(e10);
                throw jmsEx;
            }
        } else {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
    }

    public void setDouble(String name, double value) throws JMSException {
        if (this.isBodyModifiable()) {
            try {
                this.body.put(name, new Double(value));
            }
            catch (NullPointerException e10) {
                JMSException jmsEx = new JMSException(((Throwable)e10).getMessage());
                jmsEx.setLinkedException(e10);
                throw jmsEx;
            }
        } else {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
    }

    public void setString(String name, String value) throws JMSException {
        if (this.isBodyModifiable()) {
            try {
                this.body.put(name, value);
            }
            catch (NullPointerException e10) {
                JMSException jmsEx = new JMSException(((Throwable)e10).getMessage());
                jmsEx.setLinkedException(e10);
                throw jmsEx;
            }
        } else {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        if (this.isBodyModifiable()) {
            try {
                int len = value.length;
                byte[] valueCopy = new byte[len];
                System.arraycopy(value, 0, valueCopy, 0, len);
                this.body.put(name, valueCopy);
            }
            catch (NullPointerException e10) {
                JMSException jmsEx = new JMSException(((Throwable)e10).getMessage());
                jmsEx.setLinkedException(e10);
                throw jmsEx;
            }
        } else {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        if (this.isBodyModifiable()) {
            try {
                byte[] newValue = new byte[length];
                System.arraycopy(value, offset, newValue, 0, length);
                this.body.put(name, newValue);
            }
            catch (NullPointerException e10) {
                JMSException jmsEx = new JMSException(((Throwable)e10).getMessage());
                jmsEx.setLinkedException(e10);
                throw jmsEx;
            }
        } else {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
    }

    public void setObject(String name, Object value) throws JMSException {
        if (this.isBodyModifiable()) {
            try {
                if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[])) {
                    throw new MessageFormatException(resource.getString("mapmessageimpl.invalid_type"));
                }
                this.body.put(name, value);
            }
            catch (NullPointerException e10) {
                JMSException jmsEx = new JMSException(((Throwable)e10).getMessage());
                jmsEx.setLinkedException(e10);
                throw jmsEx;
            }
        } else {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
    }

    public boolean itemExists(String name) throws JMSException {
        return this.body.containsKey(name);
    }
}

