/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.createmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;

public class HomeInterfaceCreateMethodExceptionRemote
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor instanceof EjbSessionDescriptor) {
            boolean oneFailed = false;
            boolean foundAtLeastOneRemote = false;
            if (descriptor.getHomeClassName() == null || "".equals(descriptor.getHomeClassName())) {
                result.addNaDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "No Remote Home Interface for this ejb", new Object[0]));
                return result;
            }
            try {
                Context context = this.getVerifierContext();
                JarClassLoader jcl = context.getClassLoader();
                Class<?> c10 = jcl.loadClass(descriptor.getHomeClassName());
                Method[] methods = c10.getDeclaredMethods();
                boolean throwsRemoteException = false;
                int i2 = 0;
                while (i2 < methods.length) {
                    throwsRemoteException = false;
                    if (methods[i2].getName().equals("create")) {
                        Class[] methodExceptionTypes;
                        if (!foundAtLeastOneRemote) {
                            foundAtLeastOneRemote = true;
                        }
                        if (EjbUtils.isValidRemoteException(methodExceptionTypes = methods[i2].getExceptionTypes())) {
                            throwsRemoteException = true;
                        }
                        if (throwsRemoteException) {
                            result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                            result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The create method which must throw java.rmi.RemoteException was found."));
                            result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                        } else if (!throwsRemoteException) {
                            oneFailed = true;
                            result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                            result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: A create method was found, but did not throw java.rmi.RemoteException."));
                            result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                        }
                    }
                    ++i2;
                }
            }
            catch (ClassNotFoundException e10) {
                Verifier.debug(e10);
                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getHomeClassName(), descriptor.getName()}));
            }
            if (!foundAtLeastOneRemote) {
                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug3", "For Home Interface [ {0} ]", new Object[]{descriptor.getHomeClassName()}));
                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed1", "No create method was found in [ {0} ]", new Object[]{descriptor.getHomeClassName()}));
                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                result.setStatus(1);
            } else if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
            return result;
        }
        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return result;
    }
}

