/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.MethodUtils;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;

public class TransactionDemarcationComponentInterface
extends EjbTest
implements EjbCheck {
    Result result = null;
    static String[] EJBObjectMethods = new String[]{"getEJBHome", "getHandle", "getPrimaryKey", "isIdentical", "remove"};

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        try {
            if (descriptor instanceof EjbSessionDescriptor) {
                String transactionType = descriptor.getTransactionType();
                if (EjbDescriptor.CONTAINER_TRANSACTION_TYPE.equals(transactionType)) {
                    boolean oneFailed = false;
                    if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                        oneFailed = this.commonToBothInterfaces(descriptor.getRemoteClassName(), (EjbSessionDescriptor)descriptor);
                    }
                    if (!oneFailed && descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                        oneFailed = this.commonToBothInterfaces(descriptor.getLocalClassName(), (EjbSessionDescriptor)descriptor);
                    }
                    if (oneFailed) {
                        this.result.setStatus(1);
                    } else {
                        this.result.setStatus(0);
                    }
                    return this.result;
                }
                this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Bean [ {0} ] is not [ {1} ] managed, it is [ {2} ] managed.", new Object[]{descriptor.getName(), EjbDescriptor.CONTAINER_TRANSACTION_TYPE, transactionType}));
                return this.result;
            }
            this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
            return this.result;
        }
        catch (Throwable t2) {
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: Remote interface does not contain class [ {0} ] within bean [ {1} ]", new Object[]{t2.getMessage(), descriptor.getName()}));
            return this.result;
        }
    }

    private boolean commonToBothInterfaces(String component, EjbSessionDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            Arrays.sort(EJBObjectMethods);
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> remoteInterfaceClass = jcl.loadClass(component);
            Method[] remoteInterfaceMethods = remoteInterfaceClass.getDeclaredMethods();
            boolean lookForIt = false;
            int i2 = 0;
            while (i2 < remoteInterfaceMethods.length) {
                if (Arrays.binarySearch(EJBObjectMethods, remoteInterfaceMethods[i2].getName()) < 0) {
                    try {
                        ContainerTransaction containerTransaction = null;
                        boolean resolved = false;
                        if (!descriptor.getMethodContainerTransactions().isEmpty()) {
                            Enumeration ee2 = descriptor.getMethodContainerTransactions().keys();
                            while (ee2.hasMoreElements()) {
                                lookForIt = false;
                                MethodDescriptor methodDescriptor = (MethodDescriptor)ee2.nextElement();
                                lookForIt = methodDescriptor.getName().equals(MethodDescriptor.ALL_EJB_METHODS) ? (methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_REMOTE) || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCAL) ? true : (methodDescriptor.getEjbClassSymbol().equals("") ? true : (methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_HOME) || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCALHOME) ? false : false))) : (methodDescriptor.getParameterClassNames() == null ? (methodDescriptor.getEjbClassSymbol().equals("") || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_REMOTE) || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCAL)) && remoteInterfaceMethods[i2].getName().equals(methodDescriptor.getName()) : (methodDescriptor.getEjbClassSymbol().equals("") || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_REMOTE) || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCAL)) && remoteInterfaceMethods[i2].getName().equals(methodDescriptor.getName()) && MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), new MethodDescriptor(remoteInterfaceMethods[i2], descriptor, jcl).getParameterClassNames()));
                                if (!lookForIt) continue;
                                containerTransaction = (ContainerTransaction)descriptor.getMethodContainerTransactions().get(methodDescriptor);
                                if (containerTransaction != null) {
                                    String transactionAttribute = containerTransaction.getTransactionAttribute();
                                    if (ContainerTransaction.NOT_SUPPORTED.equals(transactionAttribute) || ContainerTransaction.SUPPORTS.equals(transactionAttribute) || ContainerTransaction.REQUIRED.equals(transactionAttribute) || ContainerTransaction.REQUIRES_NEW.equals(transactionAttribute) || ContainerTransaction.MANDATORY.equals(transactionAttribute) || ContainerTransaction.NEVER.equals(transactionAttribute) || !transactionAttribute.equals("")) {
                                        this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Valid: TransactionAttribute [ {0} ] for method [ {1} ] is defined for remote interface [ {2} ]", new Object[]{transactionAttribute, methodDescriptor.getName(), component}));
                                        resolved = true;
                                        break;
                                    }
                                    oneFailed = true;
                                    this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: TransactionAttribute [ {0} ] for method [ {1} ] is not valid.   Transaction attributes must be defined for all methods of remote interface [ {2} ].", new Object[]{transactionAttribute, methodDescriptor.getName(), component}));
                                    break;
                                }
                                oneFailed = true;
                                this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: TransactionAttribute is null for method [ {0} ]", new Object[]{methodDescriptor.getName()}));
                                break;
                            }
                            if (!resolved) {
                                oneFailed = true;
                                this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed1", "Error: Transaction attributes must be specified for the methods defined in the remote interface [ {0} ].  Method [ {1} ] has no transaction attribute defined within this bean [ {2} ].", new Object[]{component, remoteInterfaceMethods[i2].getName(), descriptor.getName()}));
                            }
                        } else {
                            oneFailed = true;
                            this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed2", "Error: There are no transaction attributes within this bean [ {0} ].  Transaction attributes must be specified for the methods defined in the remote interface [ {1} ].  Method [ {2} ] has no transaction attribute defined.", new Object[]{descriptor.getName(), component, remoteInterfaceMethods[i2].getName()}));
                        }
                        if (oneFailed) {
                            return oneFailed;
                        }
                    }
                    catch (Exception e10) {
                        this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: Remote interface [ {0} ] does not contain class [ {1} ] within bean [ {2} ]", new Object[]{component, e10.getMessage(), descriptor.getName()}));
                        return oneFailed;
                    }
                }
                ++i2;
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e11) {
            Verifier.debug(e11);
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException2", "Error: Remote interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{component, descriptor.getName()}));
            return oneFailed;
        }
    }
}

