/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.findbyprimarykey;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;

public class HomeInterfaceFindByPrimaryKeyName
extends EjbTest
implements EjbCheck {
    Result result = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        boolean oneFailed = false;
        if (descriptor instanceof EjbEntityDescriptor) {
            if (descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor);
            }
            if (!oneFailed && descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor);
            }
            if (oneFailed) {
                this.result.setStatus(1);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, EjbDescriptor descriptor) {
        boolean findByPrimaryKeyMethodFound = false;
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> homeInterfaceClass = jcl.loadClass(home);
            Method[] ejbFinderMethods = homeInterfaceClass.getDeclaredMethods();
            int j2 = 0;
            while (j2 < ejbFinderMethods.length) {
                if (ejbFinderMethods[j2].getName().equals("findByPrimaryKey")) {
                    findByPrimaryKeyMethodFound = true;
                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home interface [ {0} ] Finder Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), ejbFinderMethods[j2].getName()}));
                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "A findByPrimaryKey method was found."));
                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                    return oneFailed;
                }
                ++j2;
            }
            if (!findByPrimaryKeyMethodFound) {
                oneFailed = true;
                this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug3", "For Home interface [ {0} ] ", new Object[]{homeInterfaceClass.getName()}));
                this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: No findByPrimaryKey method was found in home interface class [ {0} ].", new Object[]{homeInterfaceClass.getName()}));
                this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable.", new Object[]{home}));
            oneFailed = true;
            return oneFailed;
        }
    }
}

