/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbfindermethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class EjbFinderMethodFinal
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistence)) {
                boolean ejbFindMethodFound = false;
                boolean isFinal = false;
                boolean oneFailed = false;
                int findMethodModifiers = 0;
                int foundAtLeastOne = 0;
                try {
                    Context context = this.getVerifierContext();
                    JarClassLoader jcl = context.getClassLoader();
                    Class<?> EJBClass = jcl.loadClass(descriptor.getEjbClassName());
                    do {
                        Method[] ejbFinderMethods = EJBClass.getDeclaredMethods();
                        int j2 = 0;
                        while (j2 < ejbFinderMethods.length) {
                            isFinal = false;
                            ejbFindMethodFound = false;
                            if (ejbFinderMethods[j2].getName().startsWith("ejbFind")) {
                                ++foundAtLeastOne;
                                ejbFindMethodFound = true;
                                findMethodModifiers = ejbFinderMethods[j2].getModifiers();
                                if (Modifier.isFinal(findMethodModifiers)) {
                                    isFinal = true;
                                }
                                if (ejbFindMethodFound && !isFinal) {
                                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder Method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j2].getName()}));
                                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "A non-final [ {0} ] method was found.", new Object[]{ejbFinderMethods[j2].getName()}));
                                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                                } else if (ejbFindMethodFound && isFinal) {
                                    oneFailed = true;
                                    result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder Method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j2].getName()}));
                                    result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: A final [ {0} ] method was found, but [ {1} ] cannot be declared as final.", new Object[]{ejbFinderMethods[j2].getName(), ejbFinderMethods[j2].getName()}));
                                    result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                                }
                            }
                            ++j2;
                        }
                    } while ((EJBClass = EJBClass.getSuperclass()) != null && foundAtLeastOne == 0);
                    if (foundAtLeastOne == 0) {
                        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "[ {0} ] does not declare any ejbFind<METHOD>(...) methods.", new Object[]{descriptor.getEjbClassName()}));
                    }
                }
                catch (ClassNotFoundException e10) {
                    Verifier.debug(e10);
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: EJB Class [ {1} ] does not exist or is not loadable.", new Object[]{descriptor.getEjbClassName()}));
                    oneFailed = true;
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else if (foundAtLeastOne == 0) {
                    result.setStatus(3);
                } else {
                    result.setStatus(0);
                }
                return result;
            }
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{EjbEntityDescriptor.BEAN_PERSISTENCE, descriptor.getName(), persistence}));
            return result;
        }
        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

