/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.createmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;
import java.util.Arrays;

public class HomeInterfaceCreateMethodMatchArgs
extends EjbTest
implements EjbCheck {
    Result result = null;
    boolean foundAtLeastOneCreate = false;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        if (descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor);
            }
            if (!oneFailed && descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor);
            }
            if (!this.foundAtLeastOneCreate) {
                this.result.addNaDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug3", "In Home Interface ", new Object[0]));
                this.result.addNaDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "No create method was found, test not applicable."));
                this.result.addNaDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                this.result.setStatus(3);
            } else if (oneFailed) {
                this.result.setStatus(1);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> c10 = jcl.loadClass(home);
            Method[] methods = c10.getDeclaredMethods();
            boolean signaturesMatch = false;
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].getName().equals("create")) {
                    if (!this.foundAtLeastOneCreate) {
                        this.foundAtLeastOneCreate = true;
                    }
                    signaturesMatch = false;
                    Class<?> EJBClass = jcl.loadClass(descriptor.getEjbClassName());
                    do {
                        Method[] businessMethods = EJBClass.getDeclaredMethods();
                        int z2 = 0;
                        while (z2 < businessMethods.length) {
                            Object[] businessMethodParameterTypes;
                            Object[] methodParameterTypes;
                            if (businessMethods[z2].getName().equals("ejbCreate") && Arrays.equals(methodParameterTypes = methods[i2].getParameterTypes(), businessMethodParameterTypes = businessMethods[z2].getParameterTypes())) {
                                signaturesMatch = true;
                                break;
                            }
                            ++z2;
                        }
                        if (!signaturesMatch) continue;
                        this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                        this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The corresponding ejbCreate method with matching parameters was found."));
                        this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                    } while ((EJBClass = EJBClass.getSuperclass()) != null && !signaturesMatch);
                    if (!signaturesMatch) {
                        oneFailed = true;
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: No corresponding ejbCreate method with matching parameters was found."));
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                    }
                }
                ++i2;
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] or bean class [ {1} ] does not exist or is not loadable within bean [ {2} ]", new Object[]{home, descriptor.getEjbClassName(), descriptor.getName()}));
            return oneFailed;
        }
    }
}

