/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class BusinessMethodStatic
extends EjbTest
implements EjbCheck {
    Result result = null;
    int foundAtLeastOne = 0;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getRemoteClassName(), descriptor);
            }
            if (!oneFailed && descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getLocalClassName(), descriptor);
            }
            if (oneFailed) {
                this.result.setStatus(1);
            } else if (this.foundAtLeastOne == 0) {
                this.result.setStatus(3);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean or {2} bean, but called with {3}.", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String remote, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> rc = jcl.loadClass(remote);
            boolean businessFound = false;
            boolean isStatic = false;
            Method[] remoteMethods = rc.getMethods();
            int h2 = 0;
            while (h2 < remoteMethods.length) {
                if (!remoteMethods[h2].getDeclaringClass().getName().equals("javax.ejb.EJBObject") && !remoteMethods[h2].getDeclaringClass().getName().equals("javax.ejb.EJBLocalObject")) {
                    businessFound = false;
                    isStatic = false;
                    Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
                    do {
                        Method[] methods = c10.getDeclaredMethods();
                        int i2 = 0;
                        while (i2 < methods.length) {
                            if (methods[i2].getName().equals(remoteMethods[h2].getName())) {
                                ++this.foundAtLeastOne;
                                businessFound = true;
                                int modifiers = methods[i2].getModifiers();
                                if (Modifier.isStatic(modifiers)) {
                                    isStatic = true;
                                }
                                if (businessFound && !isStatic) {
                                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] business method [ {1} ]", new Object[]{descriptor.getEjbClassName(), methods[i2].getName()}));
                                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly declares non-static business method [ {1} ].", new Object[]{descriptor.getEjbClassName(), methods[i2].getName()}));
                                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                                } else if (businessFound && isStatic) {
                                    oneFailed = true;
                                    this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] business method [ {1} ]", new Object[]{descriptor.getEjbClassName(), methods[i2].getName()}));
                                    this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: static business method [ {0} ] was found, but business method cannot be declared as static.", new Object[]{methods[i2].getName()}));
                                    this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                                }
                            }
                            ++i2;
                        }
                    } while ((c10 = c10.getSuperclass()) != null && !businessFound);
                }
                ++h2;
            }
            if (this.foundAtLeastOne == 0) {
                this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "[ {0} ] does not declare any business methods. ", new Object[]{descriptor.getEjbClassName()}));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            oneFailed = true;
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] or bean class [ {1} ] does not exist or is not loadable within bean [ {2} ].", new Object[]{remote, descriptor.getEjbClassName(), descriptor.getName()}));
            return oneFailed;
        }
    }
}

