/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;

public class BusinessMethodRmiIIOPReturn
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            int foundAtLeastOne = 0;
            try {
                if (descriptor.getRemoteClassName() == null || "".equals(descriptor.getRemoteClassName())) {
                    result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", " [ {0} ] does not have a remote interface. ", new Object[]{descriptor.getEjbClassName()}));
                    return result;
                }
                Context context = this.getVerifierContext();
                JarClassLoader jcl = context.getClassLoader();
                Class<?> rc = jcl.loadClass(descriptor.getRemoteClassName());
                boolean businessFound = false;
                boolean isLegalRMIIIOPReturn = false;
                Method[] remoteMethods = rc.getMethods();
                int h2 = 0;
                while (h2 < remoteMethods.length) {
                    if (!remoteMethods[h2].getDeclaringClass().getName().equals("javax.ejb.EJBObject")) {
                        businessFound = false;
                        isLegalRMIIIOPReturn = false;
                        Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
                        do {
                            Method[] methods = c10.getDeclaredMethods();
                            int i2 = 0;
                            while (i2 < methods.length) {
                                if (methods[i2].getName().equals(remoteMethods[h2].getName())) {
                                    ++foundAtLeastOne;
                                    businessFound = true;
                                    Class<?> methodReturnType = methods[i2].getReturnType();
                                    if (RmiIIOPUtils.isValidRmiIIOPReturnType(methodReturnType)) {
                                        isLegalRMIIIOPReturn = true;
                                    }
                                    if (businessFound && isLegalRMIIIOPReturn) {
                                        result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] business method [ {1} ]", new Object[]{descriptor.getEjbClassName(), methods[i2].getName()}));
                                        result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly declares business method [ {1} ] with valid RMI-IIOP return type.", new Object[]{descriptor.getEjbClassName(), methods[i2].getName()}));
                                        result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                                    } else if (businessFound && !isLegalRMIIIOPReturn) {
                                        oneFailed = true;
                                        result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] business method [ {1} ]", new Object[]{descriptor.getEjbClassName(), methods[i2].getName()}));
                                        result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: business method [ {0} ] was found, but business method has illegal return value.   Business methods return type must be legal types for RMI-IIOP.", new Object[]{methods[i2].getName()}));
                                        result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                                    }
                                }
                                ++i2;
                            }
                        } while ((c10 = c10.getSuperclass()) != null && !businessFound);
                    }
                    ++h2;
                }
                if (foundAtLeastOne == 0) {
                    result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", " [ {0} ] does not declare any business methods. ", new Object[]{descriptor.getEjbClassName()}));
                }
            }
            catch (ClassNotFoundException e10) {
                Verifier.debug(e10);
                oneFailed = true;
                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] or bean class [ {1} ] does not exist or is not loadable within bean [ {2} ].", new Object[]{descriptor.getRemoteClassName(), descriptor.getEjbClassName(), descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (foundAtLeastOne == 0) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
            return result;
        }
        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean or {2} bean, but called with {3}.", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return result;
    }
}

