/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.Iterator;
import java.util.Set;

public class SecurityIdentityRefs
extends EjbTest {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getUsesCallerIdentity()) {
            if (descriptor instanceof EjbMessageBeanDescriptor) {
                result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.failed2", "Security identity user-caller-identity is not supported for message-driven bean [ {0} ]", new Object[]{descriptor.getName()}));
            } else {
                result.notApplicable(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.notApplicable1", "Bean [ {0} ] use caller identity for the execution of the methods", new Object[]{descriptor.getName()}));
            }
            return result;
        }
        RunAsIdentityDescriptor identity = descriptor.getRunAsIdentity();
        if (identity == null) {
            result.notApplicable(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.notApplicable2", "Bean [ {0} ] does not specify a security identity", new Object[]{descriptor.getName()}));
            return result;
        }
        EjbBundleDescriptor bundleDescriptor = descriptor.getEjbBundleDescriptor();
        Set roles = bundleDescriptor.getRoles();
        Iterator roleIterator = roles.iterator();
        while (roleIterator.hasNext()) {
            Role role = (Role)roleIterator.next();
            if (!role.getName().equals(identity.getRoleName())) continue;
            result.passed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.passed", "Security identity run-as specified identity [ {0} ] role is found in the list of roles", new Object[]{role.getName()}));
            return result;
        }
        result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.failed", "Security identity run-as specified identity [ {0} ] role is not valid", new Object[]{identity.getRoleName()}));
        return result;
    }
}

