/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.io.File;

public class TransactionSupportExistence
extends ConnectorTest
implements ConnectorCheck {
    public Result check(ConnectorDescriptor descriptor) {
        Result result = this.getInitializedResult();
        String connectorTransactionSupport = descriptor.getTransSupport();
        if (connectorTransactionSupport == null) {
            result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.TransactionSupport.nonexist", "Error: No Transaction support specified for ressource adapter", new Object[]{connectorTransactionSupport}));
            return result;
        }
        File jarFile = Verifier.getJarFile(((ConnectorArchivist)descriptor.getArchivist()).getRarFile().getName());
        if (connectorTransactionSupport.equals(ConnectorNode.DD_NO_TRANSACTION)) {
            boolean oneFailed = false;
            if (this.findImplementorOf(jarFile, "javax.resource.spi.LocalTransaction") != null) {
                oneFailed = true;
                result.warning(VerifierTest.smh.getLocalString(this.getClass().getName() + ".warning", "Warning: Transaction support {0} is specified for ressource adapter but [ {1} ] is implemented", new Object[]{"NoTransaction", "javax.resource.spi.LocalTransaction"}));
            }
            if (this.findImplementorOf(jarFile, "javax.transaction.xa.XAResource") != null) {
                oneFailed = true;
                result.warning(VerifierTest.smh.getLocalString(this.getClass().getName() + ".wrning", "Warning: Transaction support {0} is specified for ressource adapter but [ {1} ] is implemented", new Object[]{"NoTransaction", "javax.transaction.xa.XAResource"}));
            }
            if (!oneFailed) {
                result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed1", "Transaction support NoTransaction is specified for ressource adapter and [ {1} ] are not implemented", new Object[]{"javax.transaction.xa.XAResource, javax.resource.spi.LocalTransaction"}));
            }
        } else if (connectorTransactionSupport.equals(ConnectorNode.DD_LOCAL_TRANSACTION)) {
            if (this.findImplementorOf(jarFile, "javax.resource.spi.LocalTransaction") == null) {
                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: Transaction support {0} is specified for ressource adapter but [ {1} ] is not implemented", new Object[]{"LocalTransaction", "javax.resource.spi.LocalTransaction"}));
            } else if (this.findImplementorOf(jarFile, "javax.transaction.xa.XAResource") != null) {
                result.addWarningDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".wrning", "Warning: Transaction support {0} is specified for ressource adapter but [ {1} ] is implemented", new Object[]{"LocalTransaction", "javax.transaction.xa.XAResource"}));
            } else {
                result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed2", "Transaction support {0} is specified for ressource adapter and [ {1} ] is(are) implemented", new Object[]{"LocalTransaction", "javax.resource.spi.LocalTransaction"}));
            }
        } else if (connectorTransactionSupport.equals(ConnectorNode.DD_XA_TRANSACTION)) {
            boolean oneFailed = false;
            if (this.findImplementorOf(jarFile, "javax.resource.spi.LocalTransaction") == null) {
                oneFailed = true;
                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: Transaction support {0} is specified for ressource adapter but [ {1} ] is not implemented", new Object[]{"XATransaction", "javax.resource.spi.LocalTransaction"}));
            }
            if (this.findImplementorOf(jarFile, "javax.transaction.xa.XAResource") == null) {
                oneFailed = true;
                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: Transaction support {0} is specified for ressource adapter but [ {1} ] is not implemented", new Object[]{"XATransaction", "javax.transaction.xa.XAResource"}));
            }
            if (!oneFailed) {
                result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed2", "Transaction support {0} is specified for ressource adapter and [ {1} ] is(are) implemented", new Object[]{"XATransaction", "javax.transaction.xa.Transaction, javax.resource.spi.LocalTransaction"}));
            }
        } else {
            result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.TransactionSupport.failed", "Error: Deployment descriptor transaction-support [ {0} ] for ressource adapter is not valid", new Object[]{connectorTransactionSupport}));
        }
        return result;
    }
}

