/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.appclient.elements;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientCheck;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientTest;
import java.util.Iterator;
import java.util.Set;

public class AppClientResourceType
extends AppClientTest
implements AppClientCheck {
    public Result check(ApplicationClientDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (!descriptor.getResourceReferenceDescriptors().isEmpty()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            Set resources = descriptor.getResourceReferenceDescriptors();
            Iterator itr = resources.iterator();
            while (itr.hasNext()) {
                foundIt = false;
                ResourceReferenceDescriptor next = (ResourceReferenceDescriptor)itr.next();
                String resType = next.getType();
                Verifier.debug("servlet resType: " + resType);
                foundIt = resType.equals("javax.sql.DataSource") || resType.equals("javax.jms.QueueConnectionFactory") || resType.equals("javax.jms.TopicConnectionFactory") || resType.equals("javax.mail.Session") || resType.equals("java.net.URL");
                if (foundIt) {
                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The resource-type [ {0} ] element specifies the Java class type of the data source within application client [ {1} ]", new Object[]{resType, descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: The resource-type [ {0} ] element does not specify valid Java class type of the data source within application client [ {1} ]", new Object[]{resType, descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no resource-type elements within the application client [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

