/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class UITitledList
extends UITitledControlButtonBox {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$utils$UITitledList == null ? (class$com$sun$enterprise$tools$deployment$ui$utils$UITitledList = UITitledList.class$("com.sun.enterprise.tools.deployment.ui.utils.UITitledList")) : class$com$sun$enterprise$tools$deployment$ui$utils$UITitledList);
    private MethodCellRenderer methCellRenderer = null;
    private Color listBackgroundColor = Color.white;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$utils$UITitledList;

    public UITitledList(String title, boolean showBorder) {
        super(title, showBorder);
    }

    public UITitledList(String title, boolean showBorder, JList list) {
        super(title, showBorder);
        this.setListView(list);
    }

    protected JList createDefaultListView() {
        JList list = new JList(new DefaultListModel());
        list.setFixedCellHeight(18);
        list.setSelectionMode(0);
        return list;
    }

    public void setListView(JList list) {
        super.setView(list, true);
        this.listBackgroundColor = list.getBackground();
        list.getSelectionModel().addListSelectionListener(this);
    }

    public JList getListView() {
        if (this.getView() == null) {
            this.setListView(this.createDefaultListView());
        }
        return (JList)this.getView();
    }

    public void setEnabled(boolean state) {
        JList list = this.getListView();
        if (list != null) {
            list.setBackground(state ? this.listBackgroundColor : UITitledBox.DisabledBackgroundColor);
        }
        super.setEnabled(state);
    }

    public void setButtonsEnabled(boolean state) {
        boolean hasSelection = !this.getListView().isSelectionEmpty();
        super.setButtonsEnabled(state, this.selectionControlList, state && hasSelection);
    }

    public void setValueTitleMethod(String methodName) {
        this.methCellRenderer = new MethodCellRenderer(methodName);
        this.getListView().setCellRenderer(this.methCellRenderer);
    }

    public void setCellRenderer(ListCellRenderer lcr) {
        this.getListView().setCellRenderer(lcr);
    }

    public void setDescriptorCellRenderer() {
        this.setCellRenderer(this.getDescriptorCellRenderer());
    }

    private DefaultListModel getDefaultListModel() {
        DefaultListModel model = this.getModel();
        if (!(model instanceof DefaultListModel)) {
            DefaultListModel dlm = new DefaultListModel();
            int i2 = 0;
            while (i2 < model.getSize()) {
                dlm.addElement(model.getElementAt(i2));
                ++i2;
            }
            this.setModel(dlm);
            model = dlm;
        }
        return model;
    }

    public ListModel getModel() {
        return this.getListView().getModel();
    }

    public void setModel(ListModel model) {
        this.getListView().setModel(model);
    }

    public void setListData(Object[] data) {
        this.getListView().setListData(data);
    }

    public void setListData(Vector data) {
        this.getListView().setListData(data);
    }

    public void setListData(Enumeration enumeration) {
        Vector data = new Vector();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                data.add(enumeration.nextElement());
            }
        }
        this.getListView().setListData(data);
    }

    public Vector getListData() {
        Vector data = new Vector();
        ListModel model = this.getModel();
        int i2 = 0;
        while (i2 < model.getSize()) {
            data.add(model.getElementAt(i2));
            ++i2;
        }
        return data;
    }

    public boolean containsListItem(Object item) {
        return this.getDefaultListModel().contains(item);
    }

    public void addListItem(Object item) {
        this.getDefaultListModel().addElement(item);
    }

    public void addListItems(Object[] items) {
        if (items == null || items.length == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < items.length) {
            if (!this.containsListItem(items[i2])) {
                this.addListItem(items[i2]);
            }
            ++i2;
        }
    }

    public boolean removeListItem(Object item) {
        return this.getDefaultListModel().removeElement(item);
    }

    public boolean removeListItems(Object[] items) {
        if (items == null || items.length == 0) {
            return false;
        }
        boolean didRemove = true;
        int i2 = 0;
        while (i2 < items.length) {
            if (!this.removeListItem(items[i2])) {
                didRemove = false;
            }
            ++i2;
        }
        return didRemove;
    }

    public void clear() {
        this.getDefaultListModel().clear();
    }

    public void setHeaderText(String title) {
        JComponent b10 = this.getBannerView();
        if (b10 instanceof JLabel) {
            ((JLabel)b10).setText(title);
        } else if (b10 instanceof AbstractButton) {
            ((AbstractButton)b10).setText(title);
        } else if (b10 instanceof JTextComponent) {
            ((JTextComponent)b10).setText(title);
        } else {
            JLabel banner = new JLabel(title, 0);
            banner.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            banner.setForeground(UIManager.getColor("TableHeader.foreground"));
            banner.setBackground(UIManager.getColor("TableHeader.background"));
            banner.setFont(UIManager.getFont("TableHeader.font"));
            super.setBannerView(banner);
        }
    }

    public boolean isSelectionEmpty() {
        return this.getListView().isSelectionEmpty();
    }

    public Object getSelectedValue() {
        return this.getListView().getSelectedValue();
    }

    public Object[] getSelectedValues() {
        return this.getListView().getSelectedValues();
    }

    public void setSelectedIndex(int index) {
        this.getListView().setSelectedIndex(index);
    }

    public void selectBlankRow() {
        ListModel m2 = this.getModel();
        int s2 = m2.getSize();
        int i2 = 0;
        while (i2 < s2) {
            String text;
            Object obj = m2.getElementAt(i2);
            String string = text = this.methCellRenderer != null ? this.methCellRenderer.getTargetText(obj) : obj.toString();
            if (text.equals("")) {
                this.setSelectedIndex(i2);
                return;
            }
            ++i2;
        }
    }

    public void clearSelection() {
        this.getListView().clearSelection();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.getListView().addListSelectionListener(listener);
    }

    public void setSelectionMode(int selectionMode) {
        this.getListView().setSelectionMode(selectionMode);
    }

    public Object[] confirmDeleteSelection(String msg, String title) {
        Object[] ref = this.getSelectedValues();
        if (ref != null && ref.length > 0) {
            String optTitle;
            String optMsg = msg == null ? localStrings.getLocalString("ui.uititledlist.oktodeleteselection", "Are you sure you want to delete the selection?") : msg;
            int n2 = JOptionPane.showConfirmDialog(this, optMsg, optTitle = title == null ? localStrings.getLocalString("ui.uititledlist.deleteselection", "Delete Selection") : title, 0);
            if (n2 == 0) {
                return ref;
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("ui.uititledlist.firstselectitemtodelete", "You must first select an item from the list"));
        }
        return null;
    }

    public ListCellRenderer getDescriptorCellRenderer() {
        return new DescriptorCellRenderer();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MethodCellRenderer
    extends DefaultListCellRenderer {
        private Color selBack = null;
        private UIActionDispatcher titleMeth = null;

        public MethodCellRenderer(String methName) {
            this.titleMeth = new UIActionDispatcher(null, methName);
            this.selBack = UIManager.getColor("Table.selectionBackground");
        }

        public String getTargetText(Object target) {
            String t2 = (String)this.titleMeth.setTarget(target).invoke();
            return t2 != null ? t2 : "";
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(this.selBack);
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setIcon(null);
            this.setText(this.getTargetText(value));
            this.setFont(list.getFont());
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : DefaultListCellRenderer.noFocusBorder);
            this.setEnabled(list.isEnabled());
            return this;
        }
    }

    private class DescriptorCellRenderer
    extends DefaultListCellRenderer {
        private DescriptorCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object v2 = value instanceof Descriptor ? ((Descriptor)value).getName() : value;
            return super.getListCellRendererComponent((JList<?>)list, v2, index, isSelected, cellHasFocus);
        }
    }
}

