/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import java.awt.GridBagConstraints;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;

public class UIRadioButtonBox
extends UITitledComboBox {
    private PrivateButtonGroup buttonGroup = null;

    public UIRadioButtonBox(String title, boolean showBorder, boolean isRadioButton) {
        super(title, showBorder, !isRadioButton);
    }

    public UIRadioButtonBox(String title, boolean showBorder) {
        this(title, showBorder, true);
    }

    public UIRadioButtonBox(String title) {
        this(title, true, true);
    }

    public UIRadioButtonBox() {
        this(null, true, true);
    }

    public static boolean getPrefersRadioButtons() {
        return Boolean.getBoolean("deploytool.preferRadioButtons");
    }

    private void addButton(Object obj) {
        AbstractButton btn = null;
        String key = null;
        if (obj instanceof AbstractButton) {
            btn = (AbstractButton)obj;
            key = btn.getText();
        } else if (obj instanceof String) {
            key = (String)obj;
            btn = new JRadioButton(key);
        } else {
            UIUtils.printImplementationError("UIRadioButtonBox.addButton", "Unsupported object type : " + obj.getClass().getName());
        }
        this.radioButtonGroup().addButton(key, btn);
        this.lastAddedItem = key;
        this.addWithGBConstraints(btn);
    }

    private void addButtonList(Set list) {
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            this.addButton(itr.next());
        }
    }

    private void addButtonList(Object[] list) {
        int i2 = 0;
        while (i2 < list.length) {
            this.addButton(list[i2]);
            ++i2;
        }
    }

    private void addButtonList(Vector list) {
        Enumeration e10 = list.elements();
        while (e10.hasMoreElements()) {
            this.addButton(e10.nextElement());
        }
    }

    private PrivateButtonGroup radioButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new PrivateButtonGroup();
        }
        return this.buttonGroup;
    }

    public void setItemEnabled(Object obj, boolean state) {
        if (!this.usingComboBox) {
            this.radioButtonGroup().setButtonEnabled(obj.toString(), state);
        }
    }

    public boolean isItemEnabled(Object obj) {
        if (this.usingComboBox) {
            return true;
        }
        return this.radioButtonGroup().isButtonEnabled(obj.toString());
    }

    public JComboBox getComboBox() {
        return this.usingComboBox ? super.getComboBox() : null;
    }

    public boolean isEditable() {
        return false;
    }

    public void setEditable(boolean state) {
        UIUtils.printImplementationError("UIRadioButtonBox.setEditable", "Can't set this to be editible");
    }

    public boolean containsItem(Object item) {
        if (this.usingComboBox) {
            return super.containsItem(item);
        }
        return this.radioButtonGroup().containsButton(item);
    }

    public void addItem(Object item) {
        if (this.usingComboBox) {
            super.addItem(item);
        } else {
            this.addButton(item);
        }
    }

    public void addItem(Object item, int mnemonic) {
        if (item instanceof AbstractButton) {
            ((AbstractButton)item).setMnemonic(mnemonic);
        }
        this.addItem(item);
    }

    public ComboBoxModel getModel() {
        return this.usingComboBox ? super.getModel() : null;
    }

    public void setModel(ComboBoxModel model) {
        if (this.usingComboBox) {
            super.setModel(model);
        } else {
            Object[] list = new Object[model.getSize()];
            int i2 = 0;
            while (i2 < list.length) {
                list[i2] = model.getElementAt(i2);
                ++i2;
            }
            this.addButtonList(list);
        }
    }

    public void setModel(DefaultComboBoxModel model) {
        this.setModel((ComboBoxModel)model);
    }

    public void setModel(Object[] items) {
        if (this.usingComboBox) {
            super.setModel(items);
        } else {
            this.addButtonList(items);
        }
    }

    public void setModel(Vector items) {
        if (this.usingComboBox) {
            super.setModel(items);
        } else {
            this.addButtonList(items);
        }
    }

    public void setModel(Set items) {
        if (this.usingComboBox) {
            super.setModel(items);
        } else {
            this.addButtonList(items);
        }
    }

    public void setSelectedItem(Object item) {
        if (this.usingComboBox) {
            super.setSelectedItem(item);
        } else if (this.clearWhenDisabled) {
            if (!this.isEnabled()) {
                this.lastEnabledSelection = item;
            } else {
                this._setSelectedItem(item);
            }
        } else {
            this._setSelectedItem(item);
        }
    }

    private void _setSelectedItem(Object item) {
        this.radioButtonGroup().setSelectedButton(item);
        this._enableComponentsForSelection();
    }

    public Object getSelectedItem() {
        if (this.usingComboBox) {
            return super.getSelectedItem();
        }
        return this.radioButtonGroup().getSelectedText();
    }

    public void setSelectedIndex(int index) {
        if (this.usingComboBox) {
            super.setSelectedIndex(index);
        } else if (this.clearWhenDisabled) {
            if (!this.isEnabled()) {
                this.lastEnabledSelection = this.radioButtonGroup().getButtonAt(index);
            } else {
                this._setSelectedIndex(index);
            }
        } else {
            this._setSelectedIndex(index);
        }
    }

    private void _setSelectedIndex(int index) {
        this.radioButtonGroup().setSelectedIndex(index);
        this._enableComponentsForSelection();
    }

    public int getSelectedIndex() {
        if (this.usingComboBox) {
            return super.getSelectedIndex();
        }
        return this.radioButtonGroup().getSelectedIndex();
    }

    public Object[] getSelectedObjects() {
        if (this.usingComboBox) {
            return super.getSelectedObjects();
        }
        return new Object[]{this.getSelectedItem()};
    }

    public void setEnabled(boolean state) {
        if (this.usingComboBox) {
            super.setEnabled(state);
        } else {
            this.radioButtonGroup().setEnabled(state);
            super._setEnabled(state);
            if (this.clearWhenDisabled) {
                if (!this.isEnabled() && this.lastEnabledSelection == null) {
                    this.lastEnabledSelection = this.getSelectedItem();
                    this._setSelectedIndex(-1);
                } else if (this.isEnabled() && this.lastEnabledSelection != null) {
                    this._setSelectedItem(this.lastEnabledSelection);
                    this.lastEnabledSelection = null;
                }
            }
        }
    }

    public void setReadOnly(boolean state) {
        if (this.usingComboBox) {
            super.setReadOnly(state);
        } else {
            this.radioButtonGroup().setReadOnly(state);
            super._setReadOnly(state);
        }
    }

    public void addItemListener(ItemListener listener) {
        if (this.usingComboBox) {
            super.addItemListener(listener);
        } else {
            this.radioButtonGroup().addItemListener(listener);
        }
    }

    public void removeItemListener(ItemListener listener) {
        if (this.usingComboBox) {
            super.removeItemListener(listener);
        } else {
            this.radioButtonGroup().removeItemListener(listener);
        }
    }

    public String toString() {
        if (this.usingComboBox) {
            return super.toString();
        }
        return this.radioButtonGroup().toString();
    }

    protected GridBagConstraints getDefaultGBConstraints(GridBagConstraints c10) {
        c10 = super.getDefaultGBConstraints(c10);
        if (!this.usingComboBox) {
            if (this.hasVisibleBorder()) {
                c10.insets.left += 2;
            }
            c10.weightx = 0.5;
            c10.weighty = 0.0;
            c10.fill = 2;
            c10.anchor = 17;
        }
        return c10;
    }

    private class PrivateButtonGroup
    extends ButtonGroup
    implements ItemSelectable {
        private final String NONE_SELECTED = "<NoneSelected>";
        private HashMap buttonTable = new HashMap();
        private ActionListener actionListener = null;
        private AbstractButton lastActionButton = null;
        private JRadioButton noneSelected = null;
        private Vector itemListeners = null;
        private Vector disabledList = new Vector();
        private boolean _isEnabled = true;
        private boolean _isReadOnly = false;

        public PrivateButtonGroup() {
            this.actionListener = new ActionListener(this){
                private final /* synthetic */ PrivateButtonGroup this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae2) {
                    if (PrivateButtonGroup.access$000(this.this$1) && !PrivateButtonGroup.access$100(this.this$1) && PrivateButtonGroup.access$200(this.this$1) != ae2.getSource()) {
                        PrivateButtonGroup.access$202(this.this$1, (AbstractButton)ae2.getSource());
                        PrivateButtonGroup.access$300(this.this$1);
                    }
                }
            };
        }

        public void addButton(String key, AbstractButton btn) {
            btn.addActionListener(this.actionListener);
            btn.setEnabled(this._isEnabled && !this._isReadOnly);
            this.buttonTable.put(key, btn);
            super.add(btn);
        }

        public void add(AbstractButton btn) {
            UIUtils.printImplementationError("PrivateButtonGroup", "Use 'addButton(...)' instead of 'add(...)'");
        }

        public void setSelected(ButtonModel m2, boolean b10) {
            super.setSelected(m2, b10);
            this._enableButtons();
            UIRadioButtonBox.this._enableComponentsForSelection();
        }

        public AbstractButton getButton(String key) {
            return key != null ? (AbstractButton)this.buttonTable.get(key) : null;
        }

        public AbstractButton getButtonAt(int index) {
            return index >= 0 ? this.buttons.elementAt(index) : this.getNoneSelectedButton();
        }

        public boolean containsButton(Object key) {
            return key != null && this.buttonTable.containsKey(key);
        }

        public void setSelectedIndex(int index) {
            this.getButtonAt(index).setSelected(true);
            this._enableButtons();
            UIRadioButtonBox.this._enableComponentsForSelection();
        }

        public int getSelectedIndex() {
            int i2 = 0;
            while (i2 < this.buttons.size()) {
                AbstractButton btn = this.buttons.elementAt(i2);
                if (btn != this.noneSelected && btn.isSelected()) {
                    return i2;
                }
                ++i2;
            }
            return -1;
        }

        public void setSelectedButton(Object item) {
            AbstractButton btn = null;
            if (item == null) {
                btn = this.getNoneSelectedButton();
            } else if (item instanceof AbstractButton) {
                btn = this.getButton(((AbstractButton)item).getText());
            } else if (item instanceof String) {
                btn = this.getButton((String)item);
            }
            if (btn != null) {
                btn.setSelected(true);
                this._enableButtons();
                UIRadioButtonBox.this._enableComponentsForSelection();
            }
        }

        public AbstractButton getSelectedButton() {
            int n2 = this.getSelectedIndex();
            return n2 < 0 ? null : this.buttons.elementAt(n2);
        }

        public String getSelectedText() {
            AbstractButton btn = this.getSelectedButton();
            return btn == null || btn == this.noneSelected ? null : btn.getText();
        }

        public void setReadOnly(boolean state) {
            if (this._isReadOnly != state) {
                this._isReadOnly = state;
                this._enableButtons();
            }
        }

        public void setEnabled(boolean state) {
            if (this._isEnabled != state) {
                this._isEnabled = state;
                this._enableButtons();
            }
        }

        public void setButtonEnabled(String key, boolean state) {
            AbstractButton b10 = this.getButton(key);
            if (b10 != null) {
                if (state) {
                    this.disabledList.remove(b10);
                } else if (!this.disabledList.contains(b10)) {
                    this.disabledList.add(b10);
                }
                this._enableButton(b10);
                if (!b10.isEnabled() && b10.isSelected()) {
                    int i2 = 0;
                    while (i2 < this.buttons.size()) {
                        AbstractButton btn = this.buttons.elementAt(i2);
                        if (btn != this.noneSelected && btn.isEnabled()) {
                            this.setSelectedIndex(i2);
                        }
                        ++i2;
                    }
                }
            }
        }

        public boolean isButtonEnabled(String key) {
            AbstractButton b10 = this.getButton(key);
            return b10 != null ? b10.isEnabled() : false;
        }

        private void _enableButtons() {
            Enumeration<AbstractButton> e10 = this.buttons.elements();
            while (e10.hasMoreElements()) {
                this._enableButton(e10.nextElement());
            }
        }

        private void _enableButton(AbstractButton b10) {
            if (!this._isEnabled) {
                b10.setEnabled(false);
            } else if (this._isReadOnly && !b10.isSelected()) {
                b10.setEnabled(false);
            } else if (this.disabledList.contains(b10)) {
                b10.setEnabled(false);
            } else {
                b10.setEnabled(true);
            }
        }

        private JRadioButton getNoneSelectedButton() {
            if (this.noneSelected == null) {
                this.noneSelected = new JRadioButton("<NoneSelected>");
                super.add(this.noneSelected);
            }
            return this.noneSelected;
        }

        private void selectionChanged() {
            UIRadioButtonBox.this._enableComponentsForSelection();
            UIRadioButtonBox.this.updateComponent(UIRadioButtonBox.this);
            if (this.itemListeners != null) {
                ItemEvent ie = new ItemEvent(this, 701, this.lastActionButton, 1);
                Enumeration enumeration = this.itemListeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((ItemListener)enumeration.nextElement()).itemStateChanged(ie);
                }
            }
        }

        public void addItemListener(ItemListener listener) {
            if (listener != null) {
                if (this.itemListeners == null) {
                    this.itemListeners = new Vector();
                }
                this.itemListeners.add(listener);
            }
        }

        public void removeItemListener(ItemListener listener) {
            if (listener != null && this.itemListeners != null) {
                this.itemListeners.remove(listener);
            }
        }

        public Object[] getSelectedObjects() {
            return new Object[]{this.lastActionButton};
        }

        static /* synthetic */ boolean access$000(PrivateButtonGroup x0) {
            return x0._isEnabled;
        }

        static /* synthetic */ boolean access$100(PrivateButtonGroup x0) {
            return x0._isReadOnly;
        }

        static /* synthetic */ AbstractButton access$200(PrivateButtonGroup x0) {
            return x0.lastActionButton;
        }

        static /* synthetic */ AbstractButton access$202(PrivateButtonGroup x0, AbstractButton x1) {
            x0.lastActionButton = x1;
            return x0.lastActionButton;
        }

        static /* synthetic */ void access$300(PrivateButtonGroup x0) {
            x0.selectionChanged();
        }
    }
}

