/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackager;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;

public class UIJarPackagerBox
extends UITitledControlButtonBox
implements ActionListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$utils$UIJarPackagerBox == null ? (class$com$sun$enterprise$tools$deployment$ui$utils$UIJarPackagerBox = UIJarPackagerBox.class$("com.sun.enterprise.tools.deployment.ui.utils.UIJarPackagerBox")) : class$com$sun$enterprise$tools$deployment$ui$utils$UIJarPackagerBox);
    private static final String CONTENTS = localStrings.getLocalString("ui.uijarpackagerbox.title", "Contents:");
    private static final String OKTODEL_CONTENTS = localStrings.getLocalString("ui.uijarpackagerbox.oktodelete_contents_msg", "Are you sure you want to delete selected contents?");
    private static final String DELETE_CONTENTS = localStrings.getLocalString("ui.uijarpackagerbox.oktodelete_contents_title", "Delete contents");
    private UpdateListener inspector = null;
    private BundleDescriptor bundleDescriptor = null;
    private UIJarPackager jarPackager = null;
    private UIJarPackager.PackagerTreeViewInterface contentsView = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$utils$UIJarPackagerBox;

    private static String ERR_ADDING_CONTENT(Object v0) {
        return localStrings.getLocalString("ui.uijarpackagerbox.error_adding_content", "There was an error while adding content to this module.\nA helper class may be missing.\n {0}", new Object[]{v0});
    }

    public UIJarPackagerBox(UpdateListener inspector, String type, boolean hasBorder) {
        this(CONTENTS, inspector, type, hasBorder);
    }

    public UIJarPackagerBox(String title, UpdateListener inspector, String type, boolean hasBorder) {
        super(title, hasBorder);
        this.inspector = inspector;
        this.jarPackager = UIJarPackager.newBrowser(this, type);
        this.contentsView = this.jarPackager.getDestinationTreeView();
        this.setView((JPanel)((Object)this.contentsView));
        UIButton editPB = UIButton.createEditButton(this, true);
        this.addControlButton(editPB);
    }

    public void setContents(BundleDescriptor bd2, FileContentsDescriptor classes, FileContentsDescriptor files) {
        this.bundleDescriptor = bd2;
        if (this.inspector.isWizardMode()) {
            try {
                Hashtable h2 = null;
                if (bd2 instanceof WebBundleDescriptor) {
                    WebBundleArchivist arch = (WebBundleArchivist)bd2.getArchivist();
                    h2 = arch.createEntryNameMap(classes, files);
                    if (UIConfig.testMode()) {
                        UIJarPackager.printArchiveHash(h2, "WAR contents");
                    }
                } else if (bd2 != null) {
                    if (classes != null) {
                        UIUtils.debugImplementationError("'classes' not valid here - ignored");
                    }
                    Archivist arch = bd2.getArchivist();
                    h2 = arch.createEntryNameMap(files);
                    if (UIConfig.testMode()) {
                        UIJarPackager.printArchiveHash(h2, "Bundle contents");
                    }
                } else {
                    if (classes != null) {
                        UIUtils.debugImplementationError("'classes' not valid here - ignored");
                    }
                    UIUtils.debugImplementationError("BundleDescriptor is 'null'!!!");
                    h2 = UIJarPackager.getFileContentHashtable(files);
                    if (h2 == null) {
                        h2 = new Hashtable();
                    }
                    if (UIConfig.testMode()) {
                        UIJarPackager.printArchiveHash(h2, "FCD contents");
                    }
                }
                this.contentsView.updateTreeView(h2, bd2);
            }
            catch (Throwable t2) {
                UIUtils.printImplementationError("Updating Contents View", t2);
            }
        } else {
            this.contentsView.updateTreeView(bd2);
        }
    }

    public void setContents(BundleDescriptor bd2) {
        this.setContents(bd2, null, null);
    }

    public void setContents(FileContentsDescriptor files) {
        this.setContents(null, null, files);
    }

    public void actionPerformed(ActionEvent e10) {
        String cmd = e10.getActionCommand();
        if (cmd.equals("edit")) {
            Object src = this.contentsView.getTreeViewSource();
            Object alt = this.contentsView.getTreeViewAltSource();
            String name = this.bundleDescriptor != null ? this.bundleDescriptor.getName() : null;
            this.jarPackager.setDestination(src, name);
            this.jarPackager.setAlternateDestination(alt);
            if (this.jarPackager.showBrowser()) {
                FileContentsDescriptor clsFcd = this.jarPackager.getClassDescriptor();
                FileContentsDescriptor conFcd = this.jarPackager.getContentsDescriptor();
                Vector delCon = this.jarPackager.getRemovedContents();
                if (UIConfig.testMode()) {
                    UIJarPackager.printFileList(delCon, "Deleted Items");
                    UIJarPackager.printFileContentsDescriptor(clsFcd, "Added Classes");
                    UIJarPackager.printFileContentsDescriptor(conFcd, "Added Content");
                }
                try {
                    this.inspector.addContentsAction(clsFcd, conFcd, delCon);
                }
                catch (Throwable t2) {
                    UIUtils.printException("Adding Contents", t2);
                    UIOptionPane.showErrorDialog(this, UIJarPackagerBox.ERR_ADDING_CONTENT(t2.toString()));
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface UpdateListener {
        public boolean isWizardMode();

        public void addContentsAction(FileContentsDescriptor var1, FileContentsDescriptor var2, Vector var3) throws IOException;
    }
}

