/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIBusyCursor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;

public class UIDialog
extends JDialog
implements DescriptionInspector.DescriptionInspectorManager {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$utils$UIDialog == null ? (class$com$sun$enterprise$tools$deployment$ui$utils$UIDialog = UIDialog.class$("com.sun.enterprise.tools.deployment.ui.utils.UIDialog")) : class$com$sun$enterprise$tools$deployment$ui$utils$UIDialog);
    private boolean disposeOnHide = false;
    private boolean isDisposed = false;
    private int isHiding = 0;
    private int isDisposing = 0;
    private int isShowing = 0;
    private boolean installBusyCursor = false;
    private DescriptionInspector _UIDialog_descInspector = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$utils$UIDialog;

    protected static UIDialog newDialog(DialogFactory factory, Component owner, boolean modal) {
        return factory.newInstance(UIUtils.getAncestorWindow(owner), modal);
    }

    public static UIDialog newDialog(Component ownerComp, boolean modal) {
        return UIDialog.newDialog(new DialogFactoryImpl(), ownerComp, modal);
    }

    private UIDialog() {
    }

    protected UIDialog(Dialog win, boolean modal) {
        super(win, modal);
        this._init();
    }

    protected UIDialog(Frame win, boolean modal) {
        super(win, modal);
        this._init();
    }

    private void _init() {
        this.doNothingOnClose();
    }

    public void doNothingOnClose() {
        this.setDefaultCloseOperation(0);
    }

    public void setWindowClosingAction(final ActionListener listener) {
        this.setDefaultCloseOperation(0);
        if (listener != null) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    ActionEvent ae2 = new ActionEvent(UIDialog.this, 1001, "windowClosing");
                    listener.actionPerformed(ae2);
                }
            });
        }
    }

    public void setDisposeOnHide(boolean disposeOnHide) {
        this.disposeOnHide = disposeOnHide;
    }

    public boolean getDisposeOnHide() {
        return this.disposeOnHide;
    }

    public void setEnableBusyCursor(boolean enableBusyCursor) {
        this.installBusyCursor = enableBusyCursor;
    }

    protected void _showDialog() {
        ++this.isShowing;
        super.show();
        --this.isShowing;
    }

    protected void _hideDialog() {
        ++this.isHiding;
        if (this.disposeOnHide) {
            ++this.isDisposing;
            super.dispose();
            --this.isDisposing;
            this.isDisposed = true;
        } else {
            super.hide();
        }
        --this.isHiding;
    }

    public void setVisible(boolean visible) {
        if (this.isShowing > 0 || this.isHiding > 0) {
            UIUtils.debugImplementationError("Recursive 'setVisible' detected");
            super.setVisible(visible);
        } else if (visible) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show() {
        if (this.isDisposed) {
            UIUtils.printImplementationError("Dialog has already been disposed");
        } else if (this.installBusyCursor) {
            UIBusyCursor bc2 = new UIBusyCursor(this);
            bc2.install();
            this._showDialog();
            bc2.remove();
        } else {
            this._showDialog();
        }
    }

    public void hide() {
        if (this.isHiding > 0) {
            if (this.isDisposing == 0) {
                UIUtils.debugImplementationError("Recursive 'hide' detected");
            }
            super.hide();
        } else {
            this._hideDialog();
        }
    }

    public void dispose() {
        if (this.isHiding > 0) {
            UIUtils.debugImplementationError("Recursive 'dispose' detected");
            ++this.isDisposing;
            super.dispose();
            --this.isDisposing;
        } else {
            this.disposeOnHide = true;
            this._hideDialog();
        }
    }

    public void centerOnScreen() {
        Dimension d10 = this.getToolkit().getScreenSize();
        Rectangle r2 = this.getBounds();
        int x2 = (d10.width - r2.width) / 2;
        int y2 = (d10.height - r2.height) / 2;
        ((Component)this).setLocation(x2, y2);
    }

    public void setLocationRelativeToOwner() {
        this.setLocationRelativeTo(this.getOwner());
    }

    public void setLocationRelativeToOwner(int ofsX, int ofsY) {
        Window w2 = UIUtils.getAncestorWindow(this.getOwner());
        if (w2 != null) {
            Point p2 = w2.getLocation();
            ((Component)this).setLocation(p2.x + ofsX, p2.y + ofsY);
        }
    }

    public DescriptionInspector getDescriptionInspector() {
        if (this._UIDialog_descInspector == null) {
            this._UIDialog_descInspector = new DescriptionInspector(this);
        }
        return this._UIDialog_descInspector;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DialogFactoryImpl
    implements DialogFactory {
        public UIDialog newInstance(Window win, boolean modal) {
            if (win instanceof Dialog) {
                return new UIDialog((Dialog)win, modal);
            }
            if (win instanceof Frame) {
                return new UIDialog((Frame)win, modal);
            }
            return new UIDialog((Frame)null, modal);
        }
    }

    public static interface DialogFactory {
        public UIDialog newInstance(Window var1, boolean var2);
    }
}

