/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;

public class UIBusyCursor
extends EventQueue {
    private static final long BUSY_CURSOR_DELAY = 1750L;
    private static final long CLEAR_CURSOR_DELAY = 200L;
    private static final boolean TEMP_DISABLE = false;
    private static int installLevel = 0;
    private boolean isProcessingEvent = false;
    private BusyCursorWatchdog busyThread = null;
    private int dispatchLevel = 0;
    private int targetLevel = 0;
    private Window targetWindow = null;
    private boolean isRunning = false;
    private int installedAtLevel = -1;

    public UIBusyCursor(Window targetWindow) {
        this.targetWindow = targetWindow;
    }

    public void install() {
        if (!UIConfig.getConfigBoolean("ui.startup.disableBusyCursor")) {
            this.isRunning = true;
            this.busyThread = new BusyCursorWatchdog();
            this.busyThread.start();
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(this);
            UIUtils.debugPrintln("'BusyCursor' installed [" + installLevel + "]");
            this.installedAtLevel = installLevel++;
        } else {
            UIConfig.println("'BusyCursor' has been disabled");
        }
    }

    public void remove() {
        if (this.isRunning) {
            this.isRunning = false;
            this.busyThread.pingTimer();
            super.pop();
            this.busyThread = null;
            UIUtils.debugPrintln("'BusyCursor' removed [" + this.installedAtLevel + "]");
            if (--installLevel != this.installedAtLevel) {
                UIUtils.debugPrintln("Improper BusyCursor block removal");
            }
            this.installedAtLevel = -1;
        }
    }

    protected void dispatchEvent(AWTEvent e10) {
        if (this.dispatchLevel == this.targetLevel) {
            this.isProcessingEvent = true;
            if (this.busyThread != null) {
                this.busyThread.pingTimer();
            }
        }
        ++this.dispatchLevel;
        try {
            super.dispatchEvent(e10);
        }
        catch (Throwable t2) {
            UIUtils.printException("UIBusyCursor.dispatchEvent:" + this.dispatchLevel, t2);
        }
        if (--this.dispatchLevel <= this.targetLevel) {
            this.isProcessingEvent = false;
            if (this.busyThread != null) {
                this.busyThread.pingTimer();
            }
        }
    }

    static /* synthetic */ boolean access$100(UIBusyCursor x0) {
        return x0.isRunning;
    }

    static /* synthetic */ boolean access$200(UIBusyCursor x0) {
        return x0.isProcessingEvent;
    }

    static /* synthetic */ Window access$300(UIBusyCursor x0) {
        return x0.targetWindow;
    }

    private class BusyCursorWatchdog
    extends Thread {
        private Cursor waitCursor = Cursor.getPredefinedCursor(3);
        private Cursor savedCursor = null;
        private boolean notified = false;
        private int sleepMethod = 1;

        private BusyCursorWatchdog() {
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            watchdogDelay = 1750L;
            ** GOTO lbl34
            {
                block8: {
                    try {
                        block9: {
                            if (this.sleepMethod != 0) break block9;
                            Thread.sleep(watchdogDelay);
                            ** GOTO lbl24
                        }
                        var3_2 = this;
                        synchronized (var3_2) {
                            this.notified = false;
                            this.wait(watchdogDelay);
                            if (this.notified) break block8;
                            ** GOTO lbl24
                        }
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                if (!UIBusyCursor.access$200(UIBusyCursor.this)) ** GOTO lbl24
                do {
                    if (UIBusyCursor.access$100(UIBusyCursor.this)) continue block5;
lbl24:
                    // 4 sources

                    if (UIBusyCursor.access$100(UIBusyCursor.this) && UIBusyCursor.access$200(UIBusyCursor.this)) {
                        if (this.savedCursor != null || (c = UIBusyCursor.access$300(UIBusyCursor.this).getCursor()).getName().equals(this.waitCursor.getName())) continue;
                        this.savedCursor = c;
                        UIBusyCursor.access$300(UIBusyCursor.this).setCursor(this.waitCursor);
                        watchdogDelay = 200L;
                        continue;
                    }
                    if (this.savedCursor == null) continue;
                    UIBusyCursor.access$300(UIBusyCursor.this).setCursor(this.savedCursor);
                    this.savedCursor = null;
                    watchdogDelay = 1750L;
lbl34:
                    // 5 sources

                } while (UIBusyCursor.access$100(UIBusyCursor.this));
            }
        }

        public void pingTimer() {
            if (this.sleepMethod == 0) {
                super.interrupt();
            } else {
                BusyCursorWatchdog busyCursorWatchdog = this;
                synchronized (busyCursorWatchdog) {
                    this.notified = true;
                    this.notify();
                }
            }
        }
    }
}

