/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.UIUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;

public class UIActionDispatcher
extends AbstractAction
implements Runnable,
ActionListener {
    private Object target = null;
    private String methodName = null;
    private Object[] methodArgs = null;
    private Class[] methodArgTypes = null;
    private Method methodSig = null;
    private Object methodReturn = null;
    private Thread invokeLater = null;
    static /* synthetic */ Class class$java$lang$Object;

    public UIActionDispatcher(Object target, String meth) {
        this(target, meth, null);
    }

    public UIActionDispatcher(Object target, String meth, Object[] args) {
        this.setTarget(target);
        this.methodName = meth;
        this.methodSig = null;
        this.setMethodArgs(args);
    }

    public UIActionDispatcher(Object target, Method methSig) {
        this(target, methSig, null);
    }

    public UIActionDispatcher(Object target, Method methSig, Object[] args) {
        this.setTarget(target);
        this.methodName = methSig.getName();
        this.methodSig = methSig;
        this.setMethodArgs(args);
    }

    public UIActionDispatcher setTarget(Object target) {
        this.target = target;
        return this;
    }

    public UIActionDispatcher setMethodArgs(Object[] args) {
        this.methodArgs = args != null ? args : new Object[]{};
        this.methodArgTypes = UIActionDispatcher.getArgumentTypes(this.methodArgs);
        return this;
    }

    public Object invoke(Object[] args) {
        if (args != null) {
            this.setMethodArgs(args);
        }
        if (this.methodSig == null) {
            try {
                this.methodSig = UIActionDispatcher.getTargetMethod(this.target, this.methodName, this.methodArgTypes);
            }
            catch (Throwable x2) {
                UIActionDispatcher.printInvocationError(x2, this.target, this.methodName, this.methodArgTypes, "Method not found");
                return null;
            }
        }
        try {
            this.methodReturn = this.methodSig.invoke(this.target, this.methodArgs);
            return this.methodReturn;
        }
        catch (IllegalAccessException iae) {
            UIActionDispatcher.printInvocationError(iae, this.target, this.methodName, this.methodArgTypes, "Illegal method access (must be 'public')");
        }
        catch (Throwable t2) {
            UIActionDispatcher.printInvocationError(t2, this.target, this.methodName, this.methodArgTypes, "Error invoking method on target");
        }
        return null;
    }

    public Object invoke() {
        return this.invoke(null);
    }

    public void run() {
        this.invoke();
    }

    public void actionPerformed(ActionEvent ae2) {
        this.invoke();
    }

    public static Class[] getArgumentTypes(Object[] args) {
        Class[] argTypes = null;
        if (args == null) {
            argTypes = new Class[]{};
        } else if (args instanceof Class[]) {
            argTypes = (Class[])args;
        } else {
            argTypes = new Class[args.length];
            int i2 = 0;
            while (i2 < args.length) {
                argTypes[i2] = args[i2] != null ? args[i2].getClass() : (class$java$lang$Object == null ? UIActionDispatcher.class$("java.lang.Object") : class$java$lang$Object);
                ++i2;
            }
        }
        return argTypes;
    }

    public static Method getTargetMethod(Object target, String methName, Object[] args) throws NoSuchMethodException, SecurityException {
        return target.getClass().getMethod(methName, UIActionDispatcher.getArgumentTypes(args));
    }

    public static void printInvocationError(Throwable exception, Object target, String methName, Class[] argTypes, String msg) {
        String className = target.getClass().getName();
        int cdot = className.lastIndexOf(".");
        if (cdot >= 0) {
            className = className.substring(cdot + 1);
        }
        String argList = "";
        int i2 = 0;
        while (i2 < argTypes.length) {
            String name;
            int pdot;
            if (i2 > 0) {
                argList = argList + ", ";
            }
            if ((pdot = (name = argTypes[i2].getName()).lastIndexOf(".")) >= 0) {
                name = name.substring(pdot + 1);
            }
            argList = argList + name;
            ++i2;
        }
        String classMeth = "<" + className + ">." + methName + "(" + argList + ")";
        UIUtils.printException(msg + " - " + classMeth, exception);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

