/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.rescfg;

import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.ResourceAdmin;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.rescfg.ConfigurationDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class ConfInstlDlgConnFactPnl
extends JPanel {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgConnFactPnl == null ? (class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgConnFactPnl = ConfInstlDlgConnFactPnl.class$("com.sun.enterprise.tools.deployment.ui.rescfg.ConfInstlDlgConnFactPnl")) : class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgConnFactPnl);
    private static String MAIN_BOX = localStrings.getLocalString("ui.confinstldlgconnfactpnl.connectionfactoriesbox", "JMS Connection Factories");
    private static String PROPERTIES_BOX = localStrings.getLocalString("ui.confinstldlgconnfactpnl.proeprtiesbox", "Configuration Properties");
    private static String PROPERTIES_FOR_BOX = localStrings.getLocalString("ui.confinstldlgconnfactpnl.proeprtiesforbox", "Configuration Properties for ");
    private static String JNDI_NAME = localStrings.getLocalString("ui.confinstldlgconnfactpnl.jndiname", "JNDI Name");
    private static String ADD_BTN = localStrings.getLocalString("ui.configurationdialog.add", "Add");
    private static String REMOVE_BTN = localStrings.getLocalString("ui.configurationdialog.remove", "Remove...");
    private static String PROPERTY_NAME = localStrings.getLocalString("ui.confinstldlgconnfactpnl.propertyname", "Property Name");
    private static String TYPE = localStrings.getLocalString("ui.confinstldlgconnfactpnl.type", "Type");
    private static String VALUE = localStrings.getLocalString("ui.confinstldlgconnfactpnl.value", "Value");
    public static final String TOPIC = "Topic";
    public static final String QUEUE = "Queue";
    private String[] connFactTypes = new String[]{"Queue", "Topic"};
    private JndiTable jndiTable;
    private JndiTableModel jndiTableModel;
    private PropertiesTable propertyTable;
    private PropertiesTableModel propertyTableModel;
    private UITitledBox proeprtyBox;
    private JButton propertyAddBtn;
    private Vector resToBeDeleted = null;
    private Vector originalRes = null;
    private ConnFactObject currCnxFactObj = null;
    private boolean isRestart = false;
    private boolean isChanged = false;
    private boolean debug = false;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgConnFactPnl;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public ConfInstlDlgConnFactPnl() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        UITitledBox mainBox = new UITitledBox(MAIN_BOX, true);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        this.add((Component)mainBox, gbc);
        GridBagConstraints c10 = mainBox.getGBConstraints();
        UITitledTable jndiTableBox = new UITitledTable("", false);
        c10.gridx = 0;
        c10.gridy = 0;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        mainBox.add((Component)jndiTableBox, c10);
        this.jndiTable = new JndiTable(new JndiTableModel());
        jndiTableBox.setTableView(this.jndiTable);
        this.jndiTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e10) {
                int rowIndex = ConfInstlDlgConnFactPnl.this.jndiTable.getSelectedRow();
                ConfInstlDlgConnFactPnl.this.currCnxFactObj = ConfInstlDlgConnFactPnl.this.getConnFactTableModel().getRow(rowIndex);
                ConfInstlDlgConnFactPnl.this.refreshPropertiesTable();
                if (ConfInstlDlgConnFactPnl.this.currCnxFactObj != null) {
                    ConfInstlDlgConnFactPnl.this.proeprtyBox.setTitle(PROPERTIES_FOR_BOX + ConfInstlDlgConnFactPnl.this.currCnxFactObj.getName());
                    ConfInstlDlgConnFactPnl.this.propertyAddBtn.setEnabled(true);
                } else {
                    ConfInstlDlgConnFactPnl.this.proeprtyBox.setTitle(PROPERTIES_BOX);
                    ConfInstlDlgConnFactPnl.this.propertyAddBtn.setEnabled(false);
                }
            }
        });
        JButton jndiAddBtn = new JButton(ADD_BTN);
        jndiAddBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgConnFactPnl.this.addConnFact(e10);
            }
        });
        jndiTableBox.addControlButton(jndiAddBtn);
        JButton jndiRemoveBtn = new JButton(REMOVE_BTN);
        jndiRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgConnFactPnl.this.removeConnFact(e10);
            }
        });
        jndiTableBox.addSelectionEnabledButton(jndiRemoveBtn);
        this.proeprtyBox = new UITitledBox(PROPERTIES_BOX, true);
        c10.gridx = 0;
        c10.gridy = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        mainBox.add((Component)this.proeprtyBox, c10);
        UITitledTable proeprtyTableBox = new UITitledTable("", false);
        this.propertyTable = new PropertiesTable(new PropertiesTableModel());
        proeprtyTableBox.setTableView(this.propertyTable);
        this.proeprtyBox.addWithGBConstraints(proeprtyTableBox);
        this.propertyAddBtn = new JButton(ADD_BTN);
        this.propertyAddBtn.setEnabled(false);
        this.propertyAddBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgConnFactPnl.this.addProperties(e10);
            }
        });
        proeprtyTableBox.addControlButton(this.propertyAddBtn);
        JButton propertyRemoveBtn = new JButton(REMOVE_BTN);
        propertyRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgConnFactPnl.this.removeProperties(e10);
            }
        });
        proeprtyTableBox.addSelectionEnabledButton(propertyRemoveBtn);
        this.refresh();
    }

    public void refresh() {
        this.getPropertiesTableModel().removeAllRows();
        this.getConnFactTableModel().removeAllRows();
        this.getPropertiesTableModel().fireTableDataChanged();
        this.getConnFactTableModel().fireTableDataChanged();
        this.resToBeDeleted = new Vector();
        this.originalRes = new Vector();
        this.isRestart = false;
        ResourceAdmin resAdmin = ConfigurationDialog.getResourceAdmin();
        try {
            Vector allRes = new Vector(resAdmin.getResources(2));
            ConnFactObject obj = null;
            Vector<PropertyObject> properties = null;
            String resName = "";
            boolean type = true;
            Enumeration enumeration = allRes.elements();
            while (enumeration.hasMoreElements()) {
                JmsCnxFactoryResource resource = (JmsCnxFactoryResource)enumeration.nextElement();
                if (resource == null) continue;
                resName = resource.getName();
                type = resource.getIsQueue();
                Set props = resource.getProperties();
                properties = new Vector<PropertyObject>();
                Iterator pItr = props.iterator();
                while (pItr.hasNext()) {
                    ResourceProperty prop = (ResourceProperty)pItr.next();
                    PropertyObject propObj = new PropertyObject(prop.getName(), "", (String)prop.getValue());
                    properties.add(propObj);
                }
                obj = type ? new ConnFactObject(resName, QUEUE, properties) : new ConnFactObject(resName, TOPIC, properties);
                this.getConnFactTableModel().addRow(obj);
                this.originalRes.add(resName);
            }
            this.getConnFactTableModel().fireTableDataChanged();
        }
        catch (J2EEResourceException e10) {
            System.out.println("J2EEResourceException: There was a problem while getting resources");
            e10.printStackTrace();
        }
    }

    public void addConnFact(ActionEvent evt) {
        int index = this.getConnFactTableModel().findRowWithValue(0, 0, "");
        if (index > 0) {
            return;
        }
        this.getConnFactTableModel().addRow(new ConnFactObject("", TOPIC, null));
        this.getConnFactTableModel().fireTableDataChanged();
    }

    public void removeConnFact(ActionEvent evt) {
        int n2;
        ListSelectionModel sm = this.jndiTable.getSelectionModel();
        int minIndex = sm.getMinSelectionIndex();
        int maxIndex = sm.getMaxSelectionIndex();
        ConnFactObject obj = null;
        if (minIndex >= 0 && (n2 = JOptionPane.showConfirmDialog(this.getFrame(), localStrings.getLocalString("ui.confinstldlgconnfactpnl.deleteconnfactconfirmation", "Are you sure you want to delete selected JNDI Name(s)?"), "Confirmation Dialog", 0)) == 0) {
            Vector<ConnFactObject> objs = new Vector<ConnFactObject>();
            Vector<String> names = new Vector<String>();
            while (minIndex <= maxIndex) {
                obj = this.getConnFactTableModel().getRow(minIndex);
                objs.add(obj);
                names.add(obj.getName());
                ++minIndex;
            }
            this.getConnFactTableModel().removeRows(objs);
            this.resToBeDeleted.addAll(names);
            this.getConnFactTableModel().fireTableDataChanged();
            this.setDirty(true);
        }
    }

    public void addProperties(ActionEvent evt) {
        int blankRow = this.getPropertiesTableModel().findRowWithValue(0, 0, "");
        if (blankRow > 0) {
            return;
        }
        PropertyObject obj = new PropertyObject("", "", "");
        this.getPropertiesTableModel().addRow(obj);
        this.getPropertiesTableModel().fireTableDataChanged();
        this.getCurrCnxObj().addProperty(obj);
        this.propertyTable.setSelectedIndex(-1);
        this.propertyTable.setSelectedIndex(this.getPropertiesTableModel().findRowWithValue(0, 0, ""));
    }

    public void removeProperties(ActionEvent evt) {
        int n2;
        ListSelectionModel sm = this.propertyTable.getSelectionModel();
        int minIndex = sm.getMinSelectionIndex();
        int maxIndex = sm.getMaxSelectionIndex();
        PropertyObject obj = null;
        if (minIndex >= 0 && (n2 = JOptionPane.showConfirmDialog(this.getFrame(), localStrings.getLocalString("ui.confinstldlgconnfactpnl.deletepropertiesconfirmation", "Are you sure you want to delete selected Properties?"), "Confirmation Dialog", 0)) == 0) {
            Vector<PropertyObject> objs = new Vector<PropertyObject>();
            while (minIndex <= maxIndex) {
                obj = this.getPropertiesTableModel().getRow(minIndex);
                objs.add(obj);
                ++minIndex;
            }
            this.getPropertiesTableModel().removeRows(objs);
            this.getPropertiesTableModel().fireTableDataChanged();
            this.getCurrCnxObj().removeProperties(objs);
            this.resToBeDeleted.add(this.getCurrCnxObj().getName());
            this.setDirty(true);
        }
    }

    public void refreshPropertiesTable() {
        ListSelectionModel sm = this.jndiTable.getSelectionModel();
        PropertiesTableModel ptm = this.getPropertiesTableModel();
        if (!sm.isSelectionEmpty()) {
            ptm.removeAllRows();
            ptm.fireTableDataChanged();
            int rowIndex = this.jndiTable.getSelectedRow();
            ConnFactObject cObj = this.getConnFactTableModel().getRow(rowIndex);
            Vector props = cObj.getProperties();
            int i2 = 0;
            while (i2 < props.size()) {
                ptm.addRow(props.elementAt(i2));
                ++i2;
            }
            ptm.fireTableDataChanged();
        } else {
            ptm.removeAllRows();
            ptm.fireTableDataChanged();
        }
    }

    private void valuesChanged(String connFactName) {
        if (!this.resToBeDeleted.contains(connFactName)) {
            this.resToBeDeleted.add(connFactName);
            this.setDirty(true);
        }
    }

    private boolean isDirty() {
        return this.isChanged;
    }

    private void setDirty(boolean value) {
        this.isChanged = value;
    }

    private PropertiesTableModel getPropertiesTableModel() {
        return (PropertiesTableModel)this.propertyTable.getModel();
    }

    private JndiTableModel getConnFactTableModel() {
        return (JndiTableModel)this.jndiTable.getModel();
    }

    private ConnFactObject getCurrCnxObj() {
        return this.currCnxFactObj;
    }

    private JFrame getFrame() {
        return (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ConfInstlDlgConnFactPnl.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this);
    }

    public boolean isSrvrRestart() {
        return this.isRestart;
    }

    public void saveData() {
        if (this.isDirty()) {
            ResourceAdmin resAdmin = ConfigurationDialog.getResourceAdmin();
            try {
                Hashtable<String, ConnFactObject> resources = new Hashtable<String, ConnFactObject>();
                ConnFactObject obj = null;
                Enumeration keys = null;
                String resName = "";
                int noOfRes = this.getConnFactTableModel().getRowCount();
                int i2 = 0;
                while (i2 < noOfRes) {
                    obj = this.getConnFactTableModel().getRow(i2);
                    resName = obj.getName();
                    if (resources.containsKey(resName)) {
                        System.out.println("Found duplicate datasource: earlier one will be replaced by this");
                    }
                    resources.put(resName, obj);
                    ++i2;
                }
                if (this.debug) {
                    System.out.println("\n\n Removing dltd/modfied CNX Factories:");
                }
                int i3 = 0;
                while (i3 < this.resToBeDeleted.size()) {
                    resName = (String)this.resToBeDeleted.elementAt(i3);
                    if (!resName.equals("") && this.originalRes.contains(resName)) {
                        resAdmin.removeResource(resName, 2);
                        this.originalRes.remove(resName);
                        this.isRestart = true;
                        if (this.debug) {
                            System.out.println("     deleted Res :" + resName);
                        }
                    }
                    ++i3;
                }
                if (this.debug) {
                    System.out.println("\n\n Add New CNX Factories:");
                }
                JmsCnxFactoryResource resource = null;
                String type = "";
                keys = resources.keys();
                while (keys.hasMoreElements()) {
                    resName = (String)keys.nextElement();
                    if (resName.equals("") || this.originalRes.contains(resName)) continue;
                    obj = (ConnFactObject)resources.get(resName);
                    type = obj.getType();
                    Vector properties = obj.getProperties();
                    resource = new JmsCnxFactoryResource(resName);
                    if (this.debug) {
                        System.out.println("        Properties : ");
                    }
                    int j2 = 0;
                    while (j2 < properties.size()) {
                        PropertyObject prop = (PropertyObject)properties.elementAt(j2);
                        if (!prop.getName().equals("") && !prop.getValue().equals("")) {
                            ResourcePropertyImpl resProp = new ResourcePropertyImpl(prop.getName(), prop.getValue());
                            resource.addProperty(resProp);
                            if (this.debug) {
                                System.out.println("               " + prop.getName() + " -> " + prop.getValue());
                            }
                        }
                        ++j2;
                    }
                    if (type.equals(QUEUE)) {
                        resource.setIsQueue(true);
                    } else {
                        if (!type.equals(TOPIC)) continue;
                        resource.setIsQueue(false);
                    }
                    resAdmin.addResource(resource);
                    this.isRestart = true;
                }
            }
            catch (J2EEResourceException e10) {
                System.out.println("J2EEResourceException: There was a problem while saving resources");
                e10.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        JFrame frm = new JFrame();
        frm.getContentPane().setLayout(new BorderLayout());
        frm.getContentPane().add(new ConfInstlDlgConnFactPnl());
        ((Component)frm).setSize(450, 350);
        frm.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e10) {
                System.exit(0);
            }
        });
        ((Component)frm).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PropertiesTableModel
    extends InspectorTableModel {
        public PropertiesTableModel(String[] columnNames) {
            super(columnNames);
        }

        public PropertiesTableModel() {
            this(new String[]{PROPERTY_NAME, VALUE});
        }

        public void addRow(Object property) {
            super.getData().add(property);
        }

        public void addRows(Collection rows) {
            super.getData().addAll(rows);
        }

        public void removeRow(int index) {
            super.getData().remove(index);
        }

        public void removeRows(Collection rows) {
            super.getData().removeAll(rows);
        }

        public void removeAllRows() {
            super.getData().clear();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return super.getData().size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public PropertyObject getRow(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (PropertyObject)super.getRowObject(index);
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public Object getValueAt(int row, int col) {
            String value = "";
            Object obj = super.getRowObject(row);
            switch (col) {
                case 0: {
                    value = ((PropertyObject)obj).getName();
                    break;
                }
                case 1: {
                    value = ((PropertyObject)obj).getValue();
                    break;
                }
            }
            return value;
        }

        public void setValueAt(Object value, int row, int col) {
            PropertyObject obj = (PropertyObject)super.getRowObject(row);
            String name = obj.getName();
            String val = obj.getValue();
            if (col == 0 && value.equals(name)) {
                return;
            }
            if (col == 1 && value.equals(val)) {
                return;
            }
            switch (col) {
                case 0: {
                    obj.setName((String)value);
                    ConfInstlDlgConnFactPnl.this.valuesChanged(ConfInstlDlgConnFactPnl.this.getCurrCnxObj().getName());
                    break;
                }
                case 1: {
                    obj.setValue((String)value);
                    ConfInstlDlgConnFactPnl.this.valuesChanged(ConfInstlDlgConnFactPnl.this.getCurrCnxObj().getName());
                    break;
                }
            }
        }

        public Object getObjectValue(Object obj, int col) {
            return null;
        }

        public void setObjectValue(Object obj, int col, Object value) {
        }
    }

    class PropertiesTable
    extends InspectorTable {
        public PropertiesTable(PropertiesTableModel model) {
            super(model);
            this.setSelectionMode(1);
            this.setColumnSelectionAllowed(false);
        }
    }

    class JndiTableModel
    extends InspectorTableModel {
        public JndiTableModel(String[] columnNames) {
            super(columnNames);
        }

        public JndiTableModel() {
            this(new String[]{JNDI_NAME, TYPE});
        }

        public void addRow(Object row) {
            super.getData().add(row);
        }

        public void removeRow(int index) {
            super.getData().remove(index);
        }

        public void removeRows(Collection rows) {
            super.getData().removeAll(rows);
        }

        public void removeAllRows() {
            super.getData().clear();
        }

        public ConnFactObject getRow(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (ConnFactObject)super.getRowObject(index);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return super.getData().size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public Object getValueAt(int row, int col) {
            String value = "";
            ConnFactObject obj = (ConnFactObject)super.getRowObject(row);
            switch (col) {
                case 0: {
                    value = obj.getName();
                    break;
                }
                case 1: {
                    value = obj.getType();
                    break;
                }
            }
            return value;
        }

        public void setValueAt(Object value, int row, int col) {
            ConnFactObject obj = (ConnFactObject)super.getRowObject(row);
            String name = obj.getName();
            String type = obj.getType();
            if (col == 0 && value.equals(name)) {
                return;
            }
            if (col == 1 && value.equals(type)) {
                return;
            }
            switch (col) {
                case 0: {
                    obj.setName((String)value);
                    ConfInstlDlgConnFactPnl.this.valuesChanged(obj.getName());
                    break;
                }
                case 1: {
                    obj.setType((String)value);
                    ConfInstlDlgConnFactPnl.this.valuesChanged(obj.getName());
                    break;
                }
            }
        }

        public Object getObjectValue(Object obj, int col) {
            return null;
        }

        public void setObjectValue(Object obj, int col, Object value) {
        }
    }

    class JndiTable
    extends InspectorTable {
        public JndiTable(JndiTableModel model) {
            super(model);
            this.setSelectionMode(1);
            TableColumn typeColumn = this.getColumnModel().getColumn(1);
            typeColumn.setCellEditor(this.getComboBoxEditor(ConfInstlDlgConnFactPnl.this.connFactTypes));
            DefaultTableCellRenderer typeRenderer = new DefaultTableCellRenderer();
            typeRenderer.setToolTipText("Click to edit property type");
            typeColumn.setCellRenderer(typeRenderer);
        }
    }

    class PropertyObject {
        private String name;
        private String value;

        public PropertyObject(String name, String type, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    class ConnFactObject {
        private String name;
        private String type;
        private Vector properties;

        public ConnFactObject(String name, String type, Vector props) {
            this.name = name;
            this.type = type;
            this.properties = props != null ? props : new Vector();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Vector getProperties() {
            return this.properties;
        }

        public void addProperty(PropertyObject obj) {
            this.properties.add(obj);
        }

        public void removeProperty(PropertyObject obj) {
            this.properties.remove(obj);
        }

        public void removeProperties(Collection objs) {
            this.properties.removeAll(objs);
        }
    }
}

