/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.JspDescriptorImpl;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.descriptor.RolesInspector;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIRoleRefsTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JRadioButton;

public class WebComponentSecurityInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentSecurityInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentSecurityInspector = WebComponentSecurityInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebComponentSecurityInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentSecurityInspector);
    private static String TABNAME = localStrings.getLocalString("ui.webcomponentsecurityinspector.tabname", "Security");
    private static final String SECURITY_IDENTITY = localStrings.getLocalString("ui.webcomponentsecurityinspector.security_identity", "Security Identity");
    private static final String USE_CALLER_ID = localStrings.getLocalString("ui.webcomponentsecurityinspector.use_caller_id", "Use Caller ID");
    private static final String RUN_AS_ROLE = localStrings.getLocalString("ui.webcomponentsecurityinspector.run_as_role", "Run As Role");
    private static final String EDIT_ROLES = localStrings.getLocalString("ui.webcomponentsecurityinspector.edit_roles", "Edit Roles...");
    private static final String DEPLOYMENT_SETTINGS = localStrings.getLocalString("ui.webcomponentsecurityinspector.deployment_settings", "Deployment Settings...");
    private static final String RUN_AS_USER = localStrings.getLocalString("ui.webcomponentsecurityinspector.depsettings.run_as_user", "Run as Specified User:");
    private static String wizardHelpID = "RoleRef";
    private static String deployHelpID = "Security";
    private WebComponentDescriptorImpl descriptor = null;
    private UIRoleRefsTable roleNamesPanel = null;
    private JRadioButton rbUseCallerId = null;
    private JRadioButton rbRunAsRole = null;
    private UITitledComboBox cbRoleName = null;
    private SecDeploymentSettingsDialog secDSDialog = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentSecurityInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$WebComponentDescriptorImpl;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new WebComponentSecurityInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$WebComponentDescriptorImpl == null ? (class$com$sun$enterprise$deployment$WebComponentDescriptorImpl = WebComponentSecurityInspector.class$("com.sun.enterprise.deployment.WebComponentDescriptorImpl")) : class$com$sun$enterprise$deployment$WebComponentDescriptorImpl;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebComponentDescriptorImpl ? (WebComponentDescriptorImpl)desc : null;
            this.roleNamesPanel.clearTableData();
        }
    }

    private WebComponentSecurityInspector(String mode) {
        this.setInspectorMode(mode);
        this.initLayout();
    }

    private void initLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        UITitledControlButtonBox secDepBox = new UITitledControlButtonBox(null, false);
        secDepBox.setControlButtonLocation(13);
        UIRadioButtonBox secIdBox = new UIRadioButtonBox(SECURITY_IDENTITY, true);
        secDepBox.setView(secIdBox);
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 2;
        this.add((Component)secDepBox, c10);
        this.rbUseCallerId = new JRadioButton(USE_CALLER_ID);
        secIdBox.addItem(this.rbUseCallerId);
        this.rbRunAsRole = new JRadioButton(RUN_AS_ROLE);
        secIdBox.addItem(this.rbRunAsRole);
        secIdBox.getGBConstraints().insets.left += 25;
        this.cbRoleName = new UITitledComboBox(null, false);
        this.cbRoleName.setClearWhenDisabled(true);
        this.cbRoleName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebComponentSecurityInspector.this.updateRunAsRole();
            }
        });
        secIdBox.addWithGBConstraints(this.cbRoleName);
        secIdBox.addSelectionEnabledComponent(this.cbRoleName, null);
        this.rbUseCallerId.setSelected(true);
        secIdBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                boolean useCID = WebComponentSecurityInspector.this.descriptor.getUsesCallerIdentity();
                if (useCID && !WebComponentSecurityInspector.this.rbUseCallerId.isSelected()) {
                    WebComponentSecurityInspector.this.descriptor.setUsesCallerIdentity(false);
                } else if (!useCID && WebComponentSecurityInspector.this.rbUseCallerId.isSelected()) {
                    WebComponentSecurityInspector.this.descriptor.setUsesCallerIdentity(true);
                }
                WebComponentSecurityInspector.this.invokeRefresh();
            }
        });
        JButton editRoles = new JButton(EDIT_ROLES);
        editRoles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebComponentSecurityInspector.this.editRolesAction();
            }
        });
        secDepBox.addControlButton(editRoles);
        JButton deploySettings = new JButton(DEPLOYMENT_SETTINGS);
        deploySettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebComponentSecurityInspector.this.deploymentSettingsAction();
            }
        });
        secDepBox.addControlButton(deploySettings);
        this.roleNamesPanel = new UIRoleRefsTable(true, "WAR"){

            public Collection getRoleReferences() {
                ArrayList list = new ArrayList();
                Enumeration e10 = WebComponentSecurityInspector.this.descriptor.getSecurityRoleReferences();
                while (e10.hasMoreElements()) {
                    list.add(e10.nextElement());
                }
                return list;
            }

            public void addRoleReference(RoleReference roleRef) {
                WebComponentSecurityInspector.this.descriptor.addSecurityRoleReference(roleRef);
                WebComponentSecurityInspector.this.invokeRefresh();
            }

            public void removeRoleReference(RoleReference roleRef) {
                WebComponentSecurityInspector.this.descriptor.removeSecurityRoleReference(roleRef);
                WebComponentSecurityInspector.this.invokeRefresh();
            }

            public Roles getRolesDescriptor() {
                return WebComponentSecurityInspector.this.descriptor.getWebBundleDescriptor();
            }

            public void roleReferenceChanged(RoleReference roleRef) {
                WebComponentSecurityInspector.this.descriptor.changed();
                WebComponentSecurityInspector.this.invokeRefresh();
            }
        };
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)this.roleNamesPanel, c10);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        if (this.descriptor.getUsesCallerIdentity()) {
            this.rbUseCallerId.setSelected(true);
        } else {
            Set rolesSet;
            WebBundleDescriptor ebd = this.descriptor.getWebBundleDescriptor();
            Vector<String> roleList = new Vector<String>();
            Set set = rolesSet = ebd != null ? ebd.getRoles() : null;
            if (rolesSet != null) {
                Iterator i2 = rolesSet.iterator();
                while (i2.hasNext()) {
                    String rn = i2.next().toString();
                    roleList.add(rn);
                }
            }
            this.cbRoleName.setModel(roleList);
            this.rbRunAsRole.setSelected(true);
            RunAsIdentityDescriptor rad = this.getWebRunAsIdentity();
            if (rad == null) {
                rad = new RunAsIdentityDescriptor("");
                this.descriptor.setRunAsIdentity(rad);
            }
            if (rad.getRoleName().equals("") && this.cbRoleName.getItemCount() > 0) {
                rad.setRoleName(this.cbRoleName.getItemAt(0).toString());
            }
            this.cbRoleName.setText(rad.getRoleName());
        }
        this.roleNamesPanel.refresh();
    }

    private RunAsIdentityDescriptor getWebRunAsIdentity() {
        return !this.descriptor.getUsesCallerIdentity() ? this.descriptor.getRunAsIdentity() : null;
    }

    private void updateRunAsRole() {
        RunAsIdentityDescriptor rad;
        if (!this.rbRunAsRole.isSelected()) {
            UIUtils.debugPrintln("Run-As-Role not selected!");
            return;
        }
        if (this.descriptor.getUsesCallerIdentity()) {
            this.descriptor.setUsesCallerIdentity(false);
        }
        if ((rad = this.getWebRunAsIdentity()) == null) {
            rad = new RunAsIdentityDescriptor("");
            this.descriptor.setRunAsIdentity(rad);
        }
        String roleName = this.cbRoleName.getText();
        rad.setRoleName(roleName);
        this.invokeRefresh();
    }

    private void editRolesAction() {
        InspectorPane.InspectorPaneDialog rd = RolesInspector.createRolesInspectorDialog(this.getOwner(), this, true);
        rd.setDescriptor(this.descriptor.getWebBundleDescriptor());
        rd.show();
        this.invokeRefresh();
    }

    private void deploymentSettingsAction() {
        if (this.secDSDialog == null) {
            Window win = this.getMyParentWindow();
            this.secDSDialog = win instanceof Frame ? new SecDeploymentSettingsDialog((Frame)win) : new SecDeploymentSettingsDialog((Dialog)win);
            this.secDSDialog.setLocationRelativeTo(this);
        }
        this.secDSDialog.showDialog(this.descriptor);
    }

    public static void main(String[] args) {
        final WebComponentSecurityInspector ei2 = new WebComponentSecurityInspector("WizardMode");
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(10, 10, 300, 300);
        f2.getContentPane().add(ei2);
        f2.show();
        final JspDescriptorImpl descriptor = new JspDescriptorImpl();
        WebBundleDescriptor wbd = new WebBundleDescriptor();
        wbd.addWebComponentDescriptor(descriptor);
        wbd.addNotificationListener(new NotificationListener(){

            public void notification(NotificationEvent ae2) {
                ei2.setDescriptor(descriptor);
            }
        });
        ei2.setDescriptor(descriptor);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SecDeploymentSettingsDialog
    extends UIDialog
    implements ActionListener {
        private String helpId = "WebSecurityDeploymentSettings";
        private WebComponentDescriptorImpl descriptor = null;
        private UITitledComboBox cbUserNames = null;
        private boolean isOk = false;

        public SecDeploymentSettingsDialog(Frame frame) {
            super(frame, true);
            this._init();
        }

        public SecDeploymentSettingsDialog(Dialog dialog) {
            super(dialog, true);
            this._init();
        }

        private void _init() {
            this.setTitle(DEPLOYMENT_SETTINGS);
            this.doNothingOnClose();
            UITitledControlButtonBox content = new UITitledControlButtonBox(null, false);
            content.setControlButtonLocation(101);
            this.setContentPane(content);
            content.getGBConstraints().insets.left += 10;
            content.getGBConstraints().insets.right += 10;
            GridBagConstraints gbc = content.getGBConstraintsCopy();
            UITitledBox secIdBox = new UITitledBox(SECURITY_IDENTITY, true);
            content.setView(secIdBox);
            this.cbUserNames = new UITitledComboBox(RUN_AS_USER, false);
            gbc.weightx = 0.5;
            gbc.weighty = 0.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.fill = 2;
            secIdBox.add((Component)this.cbUserNames, gbc);
            content.addControlButton(UIButton.createOkButton(this));
            content.addControlButton(UIButton.createCancelButton(this));
            content.addControlButton(new UIHelpButton(this.helpId));
            Rectangle b10 = this.getOwner().getBounds();
            ((Component)this).setBounds(b10.x + 20, b10.y + 20, 320, 160);
        }

        public void actionPerformed(ActionEvent ae2) {
            String cmd = ae2.getActionCommand();
            if (cmd.equals("ok")) {
                this.isOk = true;
                this.updateDescriptor();
                this.setVisible(false);
            } else if (cmd.equals("cancel")) {
                this.isOk = false;
                this.setVisible(false);
            } else {
                UIUtils.printImplementationError("Unsupported ActionCommand: '" + cmd + "'");
            }
        }

        public boolean showDialog(WebComponentDescriptorImpl web) {
            this.descriptor = web;
            this.isOk = false;
            this.refreshDialog();
            this.show();
            return this.isOk;
        }

        private RunAsIdentityDescriptor getWebRunAsIdentity() {
            return !this.descriptor.getUsesCallerIdentity() ? this.descriptor.getRunAsIdentity() : null;
        }

        private void updateDescriptor() {
            if (!this.descriptor.getUsesCallerIdentity()) {
                String userName = (String)this.cbUserNames.getSelectedItem();
                RunAsIdentityDescriptor rad = this.getWebRunAsIdentity();
                if (rad != null) {
                    rad.setPrincipal(userName);
                }
            }
        }

        private void refreshDialog() {
            RunAsIdentityDescriptor rad = this.getWebRunAsIdentity();
            this.cbUserNames.setEnabled(rad != null);
            if (rad != null) {
                Vector<String> v2 = new Vector<String>();
                Application app = this.descriptor.getApplication();
                if (app != null) {
                    RoleMapper rm = app.getRoleMapper();
                    Role r2 = new Role(rad.getRoleName());
                    Enumeration e10 = rm.getUsersAssignedTo(r2);
                    while (e10.hasMoreElements()) {
                        PrincipalImpl p2 = (PrincipalImpl)e10.nextElement();
                        v2.addElement(p2.getName());
                    }
                }
                this.cbUserNames.setModel(v2);
                String currentUser = rad.getPrincipal();
                if (currentUser != null && !currentUser.equals("")) {
                    this.cbUserNames.setSelectedItem(currentUser);
                }
            }
        }
    }
}

