/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ErrorPageDescriptorImpl;
import com.sun.enterprise.deployment.TagLibConfigurationDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;

public class WebAppFileRefsInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppFileRefsInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppFileRefsInspector = WebAppFileRefsInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebAppFileRefsInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppFileRefsInspector);
    private static final String WELCOME_TOOLTIP = localStrings.getLocalString("ui.webappfilerefsinspector.welcome.tooltip", "Table of Welcome Files");
    private static final String WELCOME_TITLE = localStrings.getLocalString("ui.webappfilerefsinspector.welcome.title", "Welcome Files");
    private static final String WELCOME_ADD = localStrings.getLocalString("ui.webappfilerefsinspector.welcome.add", "Add");
    private static final String WELCOME_DEL = localStrings.getLocalString("ui.webappfilerefsinspector.welcome.delete", "Delete...");
    private static String _WELCOME_OK_TO_DELETE = null;
    private static String _WELCOME_DELETE_FILE = null;
    private static String _WELCOME_PLEASE_SELECT = null;
    private static final String JSPTAG_TOOLTIP = localStrings.getLocalString("ui.webappfilerefsinspector.jsptag.tooltip", "Table of JSP Tag Libraries");
    private static final String JSPTAG_TITLE = localStrings.getLocalString("ui.webappfilerefsinspector.jsptag.title", "JSP Tag Libraries");
    private static final String JSPTAG_CODEDREF = localStrings.getLocalString("ui.webappfilerefsinspector.jsptag.coded_ref", "Coded Reference");
    private static final String JSPTAG_TAG_LIBRARY = localStrings.getLocalString("ui.webappfilerefsinspector.jsptag.tag_library", "Tag Library");
    private static final String JSPTAG_ADD = localStrings.getLocalString("ui.webappfilerefsinspector.jsptag.add", "Add");
    private static final String JSPTAG_DEL = localStrings.getLocalString("ui.webappfilerefsinspector.jsptag.delete", "Delete...");
    private static String _JSPTAG_OK_TO_DELETE = null;
    private static String _JSPTAG_DELETE_TAG = null;
    private static final String ERRORMAP_TOOLTIP = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.tooltip", "Table of context parameters");
    private static final String ERRORMAP_TITLE = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.title", "Error Mapping");
    private static final String ERRORMAP_EXCEPTION = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.exception", "Error/Exception");
    private static final String ERRORMAP_RESOURCE = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.resource", "Resource to be Called");
    private static final String ERRORMAP_ADD = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.add", "Add");
    private static final String ERRORMAP_DEL = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.delete", "Delete...");
    private static String _ERRORMAP_OK_TO_DELETE = null;
    private static String _ERRORMAP_DELETE_MAP = null;
    private static String _ERRORMAP_PLEASE_SELECT = null;
    private static final String TABNAME = localStrings.getLocalString("ui.webappfilerefsinspector.tabname", "File Ref's");
    private static String wizardHelpID = "FileRef";
    private static String deployHelpID = "FileRef";
    private WebBundleDescriptor descriptor = null;
    private WelcomeTable welcomeTable = null;
    private ErrorMappingTable errorMappingTable = null;
    private JSPTagLibTable jspTagLibTable = null;
    private Vector welcomeContents = new Vector();
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppFileRefsInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$WebBundleDescriptor;

    private static final String WELCOME_OK_TO_DELETE() {
        return _WELCOME_OK_TO_DELETE != null ? _WELCOME_OK_TO_DELETE : (_WELCOME_OK_TO_DELETE = localStrings.getLocalString("ui.webappfilerefsinspector.welcome.ok_to_delete", "Are you sure you want to delete the selected welcome file?"));
    }

    private static final String WELCOME_DELETE_FILE() {
        return _WELCOME_DELETE_FILE != null ? _WELCOME_DELETE_FILE : (_WELCOME_DELETE_FILE = localStrings.getLocalString("ui.webappfilerefsinspector.welcome.delete_file", "Delete welcome file"));
    }

    private static String WELCOME_PLEASE_SELECT() {
        return _WELCOME_PLEASE_SELECT != null ? _WELCOME_PLEASE_SELECT : (_WELCOME_PLEASE_SELECT = localStrings.getLocalString("ui.webappfilerefsinspector.welcome.please_select", "You must first select a welcome file from the list"));
    }

    private static final String JSPTAG_OK_TO_DELETE() {
        return _JSPTAG_OK_TO_DELETE != null ? _JSPTAG_OK_TO_DELETE : (_JSPTAG_OK_TO_DELETE = localStrings.getLocalString("ui.webappfilerefsinspector.jsptag.ok_to_delete", "Are you sure you want to delete the selected JSP Tag Library?"));
    }

    private static final String JSPTAG_DELETE_TAG() {
        return _JSPTAG_DELETE_TAG != null ? _JSPTAG_DELETE_TAG : (_JSPTAG_DELETE_TAG = localStrings.getLocalString("ui.webappfilerefsinspector.jsptag.delete_tag", "Delete JSP Tag Library"));
    }

    private static final String ERRORMAP_OK_TO_DELETE() {
        return _ERRORMAP_OK_TO_DELETE != null ? _ERRORMAP_OK_TO_DELETE : (_ERRORMAP_OK_TO_DELETE = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.ok_to_delete", "Are you sure you want to delete the selected error mapping?"));
    }

    private static final String ERRORMAP_DELETE_MAP() {
        return _ERRORMAP_DELETE_MAP != null ? _ERRORMAP_DELETE_MAP : (_ERRORMAP_DELETE_MAP = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.delete_map", "Delete error mapping"));
    }

    private static String ERRORMAP_PLEASE_SELECT() {
        return _ERRORMAP_PLEASE_SELECT != null ? _ERRORMAP_PLEASE_SELECT : (_ERRORMAP_PLEASE_SELECT = localStrings.getLocalString("ui.webappfilerefsinspector.errormap.please_select", "You must first select an error mapping from the list"));
    }

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new WebAppFileRefsInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$WebBundleDescriptor == null ? (class$com$sun$enterprise$deployment$WebBundleDescriptor = WebAppFileRefsInspector.class$("com.sun.enterprise.deployment.WebBundleDescriptor")) : class$com$sun$enterprise$deployment$WebBundleDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : null;
            this.welcomeTable.clearTableData();
            this.errorMappingTable.clearTableData();
            this.jspTagLibTable.clearTableData();
        }
    }

    private WebAppFileRefsInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        UITitledTable pnlWelcomeFiles = new UITitledTable(WELCOME_TITLE, true);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)pnlWelcomeFiles, c10);
        this.welcomeTable = new WelcomeTable(new WelcomeTableModel());
        pnlWelcomeFiles.setTableView(this.welcomeTable);
        JButton btnAddWelcomeFile = new JButton(WELCOME_ADD);
        btnAddWelcomeFile.setMnemonic('A');
        btnAddWelcomeFile.setActionCommand("Add");
        btnAddWelcomeFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAppFileRefsInspector.this.addWelcomeFileAction();
            }
        });
        pnlWelcomeFiles.addControlButton(btnAddWelcomeFile);
        JButton btnDeleteWelcomeFile = new JButton(WELCOME_DEL);
        btnDeleteWelcomeFile.setMnemonic('D');
        btnDeleteWelcomeFile.setActionCommand("Delete");
        btnDeleteWelcomeFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebAppFileRefsInspector.this.deleteWelcomeFileAction();
            }
        });
        pnlWelcomeFiles.addSelectionEnabledButton(btnDeleteWelcomeFile);
        UITitledTable pnlJSPTagLibs = new UITitledTable(JSPTAG_TITLE, true);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)pnlJSPTagLibs, c10);
        this.jspTagLibTable = new JSPTagLibTable(new JSPTagLibTableModel());
        pnlJSPTagLibs.setTableView(this.jspTagLibTable);
        JButton btnAddJSPTagLib = new JButton(JSPTAG_ADD);
        btnAddJSPTagLib.setMnemonic('A');
        btnAddJSPTagLib.setActionCommand("Add");
        btnAddJSPTagLib.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAppFileRefsInspector.this.addJSPTagLibAction();
            }
        });
        pnlJSPTagLibs.addControlButton(btnAddJSPTagLib);
        JButton btnDeleteJSPTagLib = new JButton(JSPTAG_DEL);
        btnDeleteJSPTagLib.setMnemonic('D');
        btnDeleteJSPTagLib.setActionCommand("Delete");
        btnDeleteJSPTagLib.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebAppFileRefsInspector.this.deleteJSPTagLibAction();
            }
        });
        pnlJSPTagLibs.addSelectionEnabledButton(btnDeleteJSPTagLib);
        UITitledTable pnlErrorMapping = new UITitledTable(ERRORMAP_TITLE, true);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)pnlErrorMapping, c10);
        this.errorMappingTable = new ErrorMappingTable(new ErrorMappingTableModel());
        pnlErrorMapping.setTableView(this.errorMappingTable);
        JButton btnAddErrorMapping = new JButton(ERRORMAP_ADD);
        btnAddErrorMapping.setMnemonic('A');
        btnAddErrorMapping.setActionCommand("Add");
        btnAddErrorMapping.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebAppFileRefsInspector.this.addErrorMappingAction();
            }
        });
        pnlErrorMapping.addControlButton(btnAddErrorMapping);
        JButton btnDeleteErrorMapping = new JButton(ERRORMAP_DEL);
        btnDeleteErrorMapping.setMnemonic('D');
        btnDeleteErrorMapping.setActionCommand("Delete");
        btnDeleteErrorMapping.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebAppFileRefsInspector.this.deleteErrorMappingAction();
            }
        });
        pnlErrorMapping.addSelectionEnabledButton(btnDeleteErrorMapping);
    }

    public void refresh() {
        Vector wf = this.welcomeTable.wrapData(this.descriptor.getWelcomeFiles());
        this.welcomeTable.updateTableData(wf);
        this.welcomeTable.resetEditors(this.getWelcomeFileList());
        this.jspTagLibTable.updateTableData(this.descriptor.getTagLibConfigs());
        this.errorMappingTable.updateTableData(this.descriptor.getErrorPageDescriptors());
    }

    public void setWelcomeFileContents(Vector contents) {
        this.welcomeContents = new Vector();
        if (contents != null) {
            Enumeration enumeration = contents.elements();
            while (enumeration.hasMoreElements()) {
                String item = enumeration.nextElement().toString();
                String _item = item.toLowerCase();
                if (_item.startsWith("web-inf") || _item.endsWith("/") || _item.endsWith(".class") || _item.endsWith(".jar")) continue;
                this.welcomeContents.addElement(item.startsWith("/") ? item : "/" + item);
            }
        }
    }

    private Vector getWelcomeFileList() {
        if (this.isDeploymentMode()) {
            this.welcomeContents = null;
            try {
                Vector entries = this.descriptor.getArchivist().getEntryNames();
                this.setWelcomeFileContents(entries);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.welcomeContents == null) {
            this.welcomeContents = new Vector();
        }
        return this.welcomeContents;
    }

    private void addWelcomeFileAction() {
        String blankRef = null;
        if (this.welcomeTable.getRowWithValue(0, "") != null) {
            blankRef = "";
        } else if (this.welcomeTable.getRowWithValue(0, "/") != null) {
            blankRef = "/";
        } else {
            blankRef = "";
            this.descriptor.addWelcomeFile(blankRef);
        }
        this.welcomeTable.selectRowWithValueOnUpdate(0, blankRef);
        this.invokeRefresh();
    }

    private void deleteWelcomeFileAction() {
        Object[] list = this.welcomeTable.confirmDeleteSelection(null, null);
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                String ref = list[i2].toString();
                this.descriptor.removeWelcomeFile(ref);
                ++i2;
            }
            this.invokeRefresh();
        }
    }

    private void addJSPTagLibAction() {
        if (this.jspTagLibTable.getRowWithValue(0, "") == null) {
            this.descriptor.addTagLibConfig(new TagLibConfigurationDescriptor("", ""));
        }
        this.jspTagLibTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteJSPTagLibAction() {
        Object[] list = this.jspTagLibTable.confirmDeleteSelection(null, null);
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                TagLibConfigurationDescriptor ref = (TagLibConfigurationDescriptor)list[i2];
                this.descriptor.removeTagLibConfig(ref);
                ++i2;
            }
            this.invokeRefresh();
        }
    }

    private void addErrorMappingAction() {
        if (this.errorMappingTable.getRowWithValue(0, "") == null) {
            this.descriptor.addErrorPageDescriptor(new ErrorPageDescriptorImpl("", ""));
        }
        this.errorMappingTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteErrorMappingAction() {
        Object[] list = this.errorMappingTable.confirmDeleteSelection(null, null);
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                ErrorPageDescriptorImpl ref = (ErrorPageDescriptorImpl)list[i2];
                this.descriptor.removeErrorPageDescriptor(ref);
                ++i2;
            }
            this.invokeRefresh();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ErrorMappingTableModel
    extends InspectorTableModel {
        public ErrorMappingTableModel() {
            super(new String[]{ERRORMAP_EXCEPTION, ERRORMAP_RESOURCE});
        }

        public Object getObjectValue(Object obj, int col) {
            ErrorPageDescriptorImpl ref = (ErrorPageDescriptorImpl)obj;
            if (ref == null) {
                return null;
            }
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getErrorSignifierAsString();
                    if (!value.equals("0")) break;
                    value = "";
                    break;
                }
                case 1: {
                    value = ref.getLocation();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            ErrorPageDescriptorImpl ref = (ErrorPageDescriptorImpl)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ref.setErrorSignifierAsString(value.toString());
                    break;
                }
                case 1: {
                    ref.setLocation(value.toString());
                }
            }
            WebAppFileRefsInspector.this.descriptor.changed();
        }
    }

    private class ErrorMappingTable
    extends InspectorTable {
        public ErrorMappingTable(ErrorMappingTableModel model) {
            super(model);
            this.setToolTipText(ERRORMAP_TOOLTIP);
            this.setSelectionMode(0);
        }
    }

    public class JSPTagLibTableModel
    extends InspectorTableModel {
        public JSPTagLibTableModel() {
            super(new String[]{JSPTAG_CODEDREF, JSPTAG_TAG_LIBRARY});
        }

        public Object getObjectValue(Object obj, int col) {
            TagLibConfigurationDescriptor ref = (TagLibConfigurationDescriptor)obj;
            if (ref == null) {
                return null;
            }
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getTagLibURI();
                    break;
                }
                case 1: {
                    value = ref.getTagLibLocation();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            TagLibConfigurationDescriptor ref = (TagLibConfigurationDescriptor)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ref.setTagLibURI(value.toString());
                    break;
                }
                case 1: {
                    ref.setTagLibLocation(value.toString());
                }
            }
            WebAppFileRefsInspector.this.descriptor.changed();
        }
    }

    private class JSPTagLibTable
    extends InspectorTable {
        public JSPTagLibTable(JSPTagLibTableModel model) {
            super(model);
            this.setToolTipText(JSPTAG_TOOLTIP);
            this.setSelectionMode(0);
        }
    }

    public class WelcomeTableModel
    extends InspectorTableModel {
        public WelcomeTableModel() {
            super(new String[]{""});
        }

        public Object getObjectValue(Object obj, int col) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.toString();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            InspectorTableModel.InspectorDataWrapper ref = (InspectorTableModel.InspectorDataWrapper)obj;
            switch (col) {
                case 0: {
                    String oldValue = ref.toString();
                    String newValue = value.toString();
                    if (!newValue.equals("") && !newValue.startsWith("/")) {
                        newValue = "/" + newValue;
                    }
                    if (oldValue.equals(newValue)) break;
                    WebAppFileRefsInspector.this.descriptor.removeWelcomeFile(oldValue);
                    ref.setObject(newValue);
                    WebAppFileRefsInspector.this.descriptor.addWelcomeFile(newValue);
                    break;
                }
            }
        }
    }

    private class WelcomeTable
    extends InspectorTable {
        DefaultCellEditor welcomeFiles = null;

        public WelcomeTable(WelcomeTableModel model) {
            super(model);
            this.setToolTipText(WELCOME_TOOLTIP);
            this.setSelectionMode(0);
        }

        public void resetEditors(Vector evl) {
            JComboBox cb2 = new JComboBox(evl);
            cb2.setEditable(true);
            this.welcomeFiles = new DefaultCellEditor(cb2);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 0: {
                    rtn = this.welcomeFiles;
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }
}

