/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;

public class WebAppContextParametersInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppContextParametersInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppContextParametersInspector = WebAppContextParametersInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebAppContextParametersInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppContextParametersInspector);
    private static final String TABLE_TITLE = localStrings.getLocalString("ui.webappcontextparametersinspector.ctxparm_title", "Context Parameters Referenced in Code");
    private static final String TABLE_CONTEXT_PARM = localStrings.getLocalString("ui.webappcontextparametersinspector.coded_parm", "Coded Parameter");
    private static final String TABLE_VALUE = localStrings.getLocalString("ui.webappcontextparametersinspector.parm_value", "Value");
    private static final String TABNAME = localStrings.getLocalString("ui.webappcontextparametersinspector.tabname", "Context");
    private static String wizardHelpID = "ContextParam";
    private static String deployHelpID = "Context";
    private WebBundleDescriptor descriptor = null;
    private InspectorTable contextParametersTable = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebAppContextParametersInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$WebBundleDescriptor;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new WebAppContextParametersInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$WebBundleDescriptor == null ? (class$com$sun$enterprise$deployment$WebBundleDescriptor = WebAppContextParametersInspector.class$("com.sun.enterprise.deployment.WebBundleDescriptor")) : class$com$sun$enterprise$deployment$WebBundleDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : null;
            this.contextParametersTable.clearTableData();
        }
    }

    private WebAppContextParametersInspector() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        UITitledTable cpPanel = new UITitledTable(TABLE_TITLE, true);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb1.setConstraints(cpPanel, c10);
        this.add(cpPanel);
        this.contextParametersTable = new ContextParametersTable(new ContextParametersTableModel());
        cpPanel.setTableView(this.contextParametersTable);
        UIButton addButton = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebAppContextParametersInspector.this.addAction();
            }
        });
        cpPanel.addControlButton(addButton);
        UIButton delButton = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebAppContextParametersInspector.this.deleteAction();
            }
        }, true);
        cpPanel.addSelectionEnabledButton(delButton);
    }

    public void refresh() {
        this.contextParametersTable.updateTableData(this.descriptor.getContextParametersSet());
    }

    public void addAction() {
        if (this.contextParametersTable.getRowWithValue(0, "") == null) {
            this.descriptor.addContextParameter(new EnvironmentProperty("", "", ""));
        }
        this.contextParametersTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    public void deleteAction() {
        Object[] list = this.contextParametersTable.confirmDeleteSelection(null, null);
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                EnvironmentProperty ref = (EnvironmentProperty)list[i2];
                this.descriptor.removeContextParameter(ref);
                ++i2;
            }
            this.invokeRefresh();
        }
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(0, 0, 300, 300);
        f2.getContentPane().add(new WebAppContextParametersInspector());
        f2.show();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ContextParametersTableModel
    extends InspectorTableModel {
        public ContextParametersTableModel() {
            super(new String[]{TABLE_CONTEXT_PARM, TABLE_VALUE});
        }

        public Object getObjectValue(Object obj, int col) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    value = ref.getValue();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ref.setName(value.toString());
                    WebAppContextParametersInspector.this.descriptor.changed();
                    break;
                }
                case 1: {
                    ref.setValue(value.toString());
                    WebAppContextParametersInspector.this.descriptor.changed();
                }
            }
        }
    }

    private class ContextParametersTable
    extends InspectorTable {
        public ContextParametersTable(ContextParametersTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
        }
    }
}

