/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;

public class ResAdaptSecurityInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$ResAdaptSecurityInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$ResAdaptSecurityInspector = ResAdaptSecurityInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.ResAdaptSecurityInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$ResAdaptSecurityInspector);
    private static final String TABNAME = localStrings.getLocalString("ui.resadaptsecurityinspector.tabname", "Security");
    private static final String SPECIFICATION = localStrings.getLocalString("ui.resadaptsecurityinspector.specification", "Specification");
    private static final String AUTH_MECH = localStrings.getLocalString("ui.resadaptsecurityinspector.auth_mechanisms", "Authentication Mechanisms");
    private static final String PASSWORD = localStrings.getLocalString("ui.resadaptsecurityinspector.password", "Password");
    private static final String KERBEROS = localStrings.getLocalString("ui.resadaptsecurityinspector.kerberos_v50", "Kerberos Version 5.0");
    private static final String REAUTH = localStrings.getLocalString("ui.resadaptsecurityinspector.kerberos_reauth_supported", "Reauthentication Supported");
    private static final String SECURITY_PERM = localStrings.getLocalString("ui.resadaptsecurityinspector.sec_perm", "Security Permissions");
    private static final String SECURITY_PERM_ADD = localStrings.getLocalString("ui.resadaptsecurityinspector.sec_perm.add", "Add");
    private static final String SECURITY_PERM_DEL = localStrings.getLocalString("ui.resadaptsecurityinspector.sec_perm.delete", "Delete...");
    private static final String OKTODEL_SECURITY = localStrings.getLocalString("ui.resadaptsecurityinspector.sec_perm.delete.confirm", "Are you sure you want to delete selected security permissions?");
    private static final String DELETE_SECURITY = localStrings.getLocalString("ui.resadaptsecurityinspector.sec_perm.delete.confirm_btn", "Delete Security Permissions");
    private static String wizardHelpID = "Security";
    private static String deployHelpID = "Security";
    private ConnectorDescriptor descriptor;
    private JCheckBox authPassword = null;
    private JCheckBox authKerberos = null;
    private JCheckBox authReAuthSupport = null;
    private UITitledTable securityTable = null;
    private RASecurityPermTable securityPermTable = null;
    private static boolean replaceExistingAuthMeth = true;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$ResAdaptSecurityInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ConnectorDescriptor;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new ResAdaptSecurityInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$ConnectorDescriptor == null ? (class$com$sun$enterprise$deployment$ConnectorDescriptor = ResAdaptSecurityInspector.class$("com.sun.enterprise.deployment.ConnectorDescriptor")) : class$com$sun$enterprise$deployment$ConnectorDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof ConnectorDescriptor) {
            this.descriptor = (ConnectorDescriptor)obj;
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private ResAdaptSecurityInspector(String mode) {
        this.setInspectorMode(mode);
        this.initLayout();
    }

    private void initLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = -1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 0, 5, 0);
        c10.fill = 1;
        c10.anchor = 10;
        UITitledBox authMechBox = new UITitledBox(AUTH_MECH, true);
        this.authPassword = new JCheckBox(PASSWORD);
        this.authPassword.setSelected(false);
        this.authPassword.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                ResAdaptSecurityInspector.this.setDescriptorAuthMech(0, ResAdaptSecurityInspector.this.authPassword.isSelected());
            }
        });
        authMechBox.add((Component)this.authPassword, authMechBox.getGBConstraints());
        this.authKerberos = new JCheckBox(KERBEROS);
        this.authKerberos.setSelected(false);
        this.authKerberos.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                ResAdaptSecurityInspector.this.setDescriptorAuthMech(1, ResAdaptSecurityInspector.this.authKerberos.isSelected());
            }
        });
        authMechBox.add((Component)this.authKerberos, authMechBox.getGBConstraints());
        this.authReAuthSupport = new JCheckBox(REAUTH);
        this.authReAuthSupport.setSelected(false);
        this.authReAuthSupport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                ResAdaptSecurityInspector.this.descriptor.setReauthenticationSupport(ResAdaptSecurityInspector.this.authReAuthSupport.isSelected());
            }
        });
        authMechBox.addWithGBConstraints(this.authReAuthSupport);
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.fill = 0;
        c10.anchor = 17;
        this.add((Component)authMechBox, c10);
        this.securityTable = new UITitledTable(SECURITY_PERM, true);
        this.securityPermTable = new RASecurityPermTable();
        this.securityTable.setTableView(this.securityPermTable);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.fill = 1;
        c10.anchor = 10;
        this.add((Component)this.securityTable, c10);
        JButton addPB = new JButton(SECURITY_PERM_ADD);
        addPB.setActionCommand("Add");
        addPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ResAdaptSecurityInspector.this.addSecurityPermissionAction();
            }
        });
        this.securityTable.addControlButton(addPB);
        JButton delPB = new JButton(SECURITY_PERM_DEL);
        delPB.setActionCommand("Delete");
        delPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ResAdaptSecurityInspector.this.deleteSecurityPermissionAction();
            }
        });
        this.securityTable.addSelectionEnabledButton(delPB);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        boolean authpass = false;
        boolean authkerb = false;
        Iterator authMech = this.descriptor.getAuthMechanisms().iterator();
        while (authMech.hasNext()) {
            AuthMechanism auth = (AuthMechanism)authMech.next();
            if (auth.getAuthMechVal() == 0) {
                authpass = true;
                continue;
            }
            if (auth.getAuthMechVal() != 1) continue;
            authkerb = true;
        }
        this.authPassword.setSelected(authpass);
        this.authKerberos.setSelected(authkerb);
        this.authReAuthSupport.setSelected(this.descriptor.supportsReauthentication());
        ArrayList<SecurityPermissionWrapper> secWrapper = new ArrayList<SecurityPermissionWrapper>();
        Iterator secIter = this.descriptor.getSecurityPermissions().iterator();
        while (secIter.hasNext()) {
            SecurityPermission secPerm = (SecurityPermission)secIter.next();
            secWrapper.add(new SecurityPermissionWrapper(secPerm));
        }
        this.securityTable.updateTableData(secWrapper);
    }

    private void addSecurityPermissionAction() {
        if (this.securityPermTable.getRowWithValue(0, "") == null) {
            this.descriptor.addSecurityPermission(new SecurityPermission("", ""));
        }
        this.securityPermTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteSecurityPermissionAction() {
        Object[] list = this.securityTable.confirmDeleteSelection(null, null);
        if (list != null && list.length > 0) {
            int i2 = 0;
            while (i2 < list.length) {
                this.descriptor.removeSecurityPermission(((SecurityPermissionWrapper)list[i2]).getSecurityPermission());
                ++i2;
            }
            this.securityPermTable.clearSelection();
            this.invokeRefresh();
        }
    }

    private void setDescriptorAuthMech(int mech, boolean state) {
        if (state) {
            if (replaceExistingAuthMeth) {
                this.descriptor.removeAuthMechanism(mech);
            }
            this.descriptor.addAuthMechanism(mech);
        } else {
            this.descriptor.removeAuthMechanism(mech);
        }
        this.invokeRefresh();
    }

    public static void main(String[] args) {
        String mode = "DeploymentMode";
        JFrame frame = new JFrame();
        ResAdaptSecurityInspector myPanel = (ResAdaptSecurityInspector)ResAdaptSecurityInspector.newInspectorPane(mode, null);
        ConnectorDescriptor d10 = new ConnectorDescriptor();
        myPanel.setDescriptor(d10);
        frame.getContentPane().add((Component)myPanel, "Center");
        ((Component)frame).setSize(myPanel.getPreferredSize());
        ((Component)frame).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RASecurityPermModel
    extends InspectorTableModel {
        public RASecurityPermModel() {
            super(new String[]{SPECIFICATION, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public Object getObjectValue(Object obj, int col) {
            SecurityPermissionWrapper sp = (SecurityPermissionWrapper)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = sp.getPermission();
                    break;
                }
                case 1: {
                    value = sp.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            SecurityPermissionWrapper sp = (SecurityPermissionWrapper)obj;
            String vs = value.toString();
            switch (col) {
                case 0: {
                    sp.setPermission(vs);
                    break;
                }
                case 1: {
                    sp.setDescription(vs);
                }
            }
        }
    }

    private static class RASecurityPermTable
    extends InspectorTable {
        public RASecurityPermTable() {
            super(new RASecurityPermModel());
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }
    }

    private class SecurityPermissionWrapper
    extends Descriptor {
        private SecurityPermission secPerm = null;

        public SecurityPermissionWrapper(String d10, String p2) {
            this(new SecurityPermission(d10, p2));
        }

        public SecurityPermissionWrapper(SecurityPermission sp) {
            this.secPerm = sp;
        }

        public SecurityPermission getSecurityPermission() {
            return this.secPerm;
        }

        public String getDescription() {
            return this.secPerm.getDescription();
        }

        public void setDescription(String description) {
            this.secPerm.setDescription(description);
        }

        public String getPermission() {
            return this.secPerm.getPermission();
        }

        public void setPermission(String permission) {
            this.secPerm.setPermission(permission);
        }

        public String getName() {
            return this.getPermission();
        }

        public boolean equals(Object ref) {
            return this.secPerm.equals(ref);
        }
    }
}

