/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;

public class ResAdaptConnFactInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$ResAdaptConnFactInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$ResAdaptConnFactInspector = ResAdaptConnFactInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.ResAdaptConnFactInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$ResAdaptConnFactInspector);
    private static final String CFG_PROPERTY = localStrings.getLocalString("ui.resadaptconnfactinspector.table.config_property", "Property");
    private static final String CFG_TYPE = localStrings.getLocalString("ui.resadaptconnfactinspector.table.config_type", "Type");
    private static final String CFG_VALUE = localStrings.getLocalString("ui.resadaptconnfactinspector.table.config_value", "Default Value");
    private static String TABNAME = localStrings.getLocalString("ui.resadaptconnfactinspector.tabname", "Configuration Properties");
    private static String wizardHelpID = "ConfigProp";
    private static String deployHelpID = "ConfigProp";
    private ConnectorDescriptor descriptor = null;
    private ConnFactPropertiesTable connFactPropsTable = null;
    private static final String JAVA_LANG = "java.lang.";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$ResAdaptConnFactInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ConnectorDescriptor;
    static /* synthetic */ Class class$java$lang$String;

    private static String ILLEGAL_VALUE(String v0) {
        return localStrings.getLocalString("ui.resadaptconnfactinspector.table.illegal_type", "{0} is not a legal value for this environment entry type", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new ResAdaptConnFactInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$ConnectorDescriptor == null ? (class$com$sun$enterprise$deployment$ConnectorDescriptor = ResAdaptConnFactInspector.class$("com.sun.enterprise.deployment.ConnectorDescriptor")) : class$com$sun$enterprise$deployment$ConnectorDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof ConnectorDescriptor ? (ConnectorDescriptor)desc : null;
            this.connFactPropsTable.clearTableData();
        }
    }

    private ResAdaptConnFactInspector(String mode) {
        this.setInspectorMode(mode);
        this.initLayout();
    }

    private void initLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 0, 5, 0);
        c10.fill = 1;
        c10.anchor = 10;
        UITitledTable configTbl = new UITitledTable(localStrings.getLocalString("ui.resadaptconnfactinspector.connfactconfigprops", "Configuration Properties for Connection Factories"), true);
        c10.weightx = 1.0;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 2;
        c10.gridheight = 1;
        this.add((Component)configTbl, c10);
        this.connFactPropsTable = new ConnFactPropertiesTable(new ConnFactPropertiesModel());
        configTbl.setTableView(this.connFactPropsTable);
        UIButton addPB = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ResAdaptConnFactInspector.this.addConfigPropertyAction();
            }
        });
        configTbl.addControlButton(addPB);
        UIButton delPB = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ResAdaptConnFactInspector.this.removeConfigPropertyAction();
            }
        }, true);
        configTbl.addControlButton(delPB);
        UITitledTable deployTbl = new UITitledTable(localStrings.getLocalString("ui.resadaptconnfactinspector.connfactdeployed", "Connection Factories to be Deployed"), true);
        c10.weightx = 0.65;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        JButton newPB = new JButton(localStrings.getLocalString("ui.resadaptconnfactinspector.connfactdeployed_new", "New..."));
        newPB.setActionCommand("New");
        newPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
            }
        });
        deployTbl.addControlButton(newPB);
        JButton editPB = new JButton(localStrings.getLocalString("ui.resadaptconnfactinspector.connfactdeployed_edit", "Edit..."));
        editPB.setActionCommand("Edit");
        editPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
            }
        });
        deployTbl.addControlButton(editPB);
        JButton ddelPB = new JButton(localStrings.getLocalString("ui.resadaptconnfactinspector.connfactdeployed_delete", "Delete..."));
        ddelPB.setActionCommand("Delete");
        ddelPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
            }
        });
        deployTbl.addControlButton(ddelPB);
        JPanel filler = new JPanel();
        c10.weightx = 0.35;
        c10.weighty = 0.5;
        c10.gridx = 1;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        this.add((Component)filler, c10);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        this.connFactPropsTable.updateTableData(this.descriptor.getConfigProperties());
    }

    private void addConfigPropertyAction() {
        if (this.connFactPropsTable.getRowWithValue(0, "") == null) {
            this.descriptor.addConfigProperty(new EnvironmentProperty("", "", "", (class$java$lang$String == null ? (class$java$lang$String = ResAdaptConnFactInspector.class$("java.lang.String")) : class$java$lang$String).getName()));
        }
        this.connFactPropsTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void removeConfigPropertyAction() {
        Object[] list = this.connFactPropsTable.confirmDeleteSelection(null, null);
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                EnvironmentProperty ref = (EnvironmentProperty)list[i2];
                this.descriptor.removeConfigProperty(ref);
                ++i2;
            }
        }
        this.invokeRefresh();
    }

    public static void main(String[] args) {
        String mode = "DeploymentMode";
        JFrame frame = new JFrame();
        ResAdaptConnFactInspector myPanel = (ResAdaptConnFactInspector)ResAdaptConnFactInspector.newInspectorPane(mode, null);
        ConnectorDescriptor d10 = new ConnectorDescriptor();
        myPanel.setDescriptor(d10);
        frame.getContentPane().add((Component)myPanel, "Center");
        ((Component)frame).setSize(myPanel.getPreferredSize());
        ((Component)frame).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConnFactPropertiesModel
    extends InspectorTableModel {
        public ConnFactPropertiesModel() {
            super(new String[]{CFG_PROPERTY, CFG_TYPE, CFG_VALUE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public Object getObjectValue(Object obj, int col) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    String type = ref.getType();
                    if (type == null) {
                        type = "String";
                    }
                    value = type.startsWith(ResAdaptConnFactInspector.JAVA_LANG) ? type.substring(ResAdaptConnFactInspector.JAVA_LANG.length()) : type;
                    break;
                }
                case 2: {
                    value = ref.getValue();
                    break;
                }
                case 3: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            if (ref == null) {
                return;
            }
            String valStr = value.toString();
            switch (col) {
                case 0: {
                    ref.setName(valStr);
                    break;
                }
                case 1: {
                    if (!valStr.startsWith(ResAdaptConnFactInspector.JAVA_LANG)) {
                        valStr = ResAdaptConnFactInspector.JAVA_LANG + valStr;
                    }
                    if (valStr.equals(ref.getType())) break;
                    ref.setType(valStr);
                    this.setObjectValue(obj, 2, "");
                    break;
                }
                case 2: {
                    try {
                        ref.setValue(super.validatePrimitiveValue(ref.getType(), valStr));
                    }
                    catch (IllegalArgumentException iae) {
                        UIOptionPane.showErrorDialog(null, ResAdaptConnFactInspector.ILLEGAL_VALUE(valStr));
                    }
                    break;
                }
                case 3: {
                    ref.setDescription(valStr);
                }
            }
            ((Descriptor)ResAdaptConnFactInspector.this.descriptor).changed();
        }
    }

    private class ConnFactPropertiesTable
    extends InspectorTable {
        public ConnFactPropertiesTable(ConnFactPropertiesModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 1: {
                    rtn = super.getPrimitiveTypesEditor();
                    break;
                }
                case 2: {
                    EnvironmentProperty ref = (EnvironmentProperty)this.getRowObject(row);
                    rtn = super.getPrimitiveValueEditor(ref.getType());
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }
}

