/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.ejb.sqlgen.DBInfo;
import com.sun.ejb.sqlgen.SQLGenerator;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.tools.deployment.ui.DeploymentSettingsInspector;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.IconInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.ManifestClasspathInspector;
import com.sun.enterprise.tools.deployment.ui.TreeCombo;
import com.sun.enterprise.tools.deployment.ui.utils.UIDisplayNameBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackager;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackagerBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.ListModel;

public class EjbJarGeneralInspector
extends InspectorPane
implements IconInspector.UpdateListener,
ManifestClasspathInspector.UpdateListener,
DeploymentSettingsInspector.UpdateListener,
DescriptionInspector.UpdateListener,
UIJarPackagerBox.UpdateListener {
    private static final boolean EnableAlternate = true;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbJarGeneralInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbJarGeneralInspector = EjbJarGeneralInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.EjbJarGeneralInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbJarGeneralInspector);
    private static final String TABNAME = localStrings.getLocalString("ui.ejbjargeneralinspector.tabname", "General");
    private static final String LOCATION = localStrings.getLocalString("ui.ejbjargeneralinspector.location", "Location:");
    private static final String JAR_FILE_NAME = localStrings.getLocalString("ui.ejbjargeneralinspector.jar_filename", "JAR File Name:");
    private static final String TARGET = localStrings.getLocalString("ui.ejbjargeneralinspector.bean_target", "Enterprise Bean will Go In:");
    private static final String MFCLASSPATH = localStrings.getLocalString("ui.ejbjargeneralinspector.manifest_classpath", "Manifest Classpath:");
    private static final String BASEDIR = localStrings.getLocalString("ui.ejbjargeneralinspector.base_directory", "Base directory:");
    private static final String DISPLAYNAME = localStrings.getLocalString("ui.ejbjargeneralinspector.jar_display_name", "JAR Display Name:");
    private static String wizardHelpID = "NewJAR";
    private static String deployHelpID = "General";
    private EjbBundleDescriptor descriptor;
    private UITitledTextField locationField = null;
    private ManifestClasspathInspector.DialogDisplayButton classpathButton = null;
    private DeploymentSettingsInspector.DialogDisplayButton deploymentSettingsButton = null;
    private FileContentsDescriptor archiveContents = null;
    UIDisplayNameBox fileDisplayBox = null;
    private UIJarPackagerBox contentsPanel = null;
    private IconInspector.DialogDisplayButton iconInspector = null;
    private DescriptionInspector.DialogDisplayButton descInspector = null;
    private JComponent targetChooser = null;
    private boolean bundleInfoEnabled = true;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbJarGeneralInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbBundleDescriptor;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new EjbJarGeneralInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$EjbBundleDescriptor == null ? (class$com$sun$enterprise$deployment$EjbBundleDescriptor = EjbJarGeneralInspector.class$("com.sun.enterprise.deployment.EjbBundleDescriptor")) : class$com$sun$enterprise$deployment$EjbBundleDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof EjbBundleDescriptor) {
            this.descriptor = (EjbBundleDescriptor)obj;
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private EjbJarGeneralInspector(String mode) {
        this.setInspectorMode(mode);
        this.archiveContents = new FileContentsDescriptor();
        this.initializeWidgets();
    }

    public FileContentsDescriptor getArchiveFileContentsDescriptor() {
        return this.archiveContents;
    }

    public FileContentsDescriptor getFileContentsDescriptor() {
        Object obj;
        if (this.isWizardMode() && (obj = this.fileDisplayBox.getSelectedParentDescriptor()) instanceof EjbBundleDescriptor) {
            return UIJarPackager.getMergedFileContentDescriptor(this.archiveContents, (EjbBundleDescriptor)obj);
        }
        return this.archiveContents;
    }

    public String getJarFile() {
        return this.locationField.getText();
    }

    public void setJarFile(String jarFilename) {
        this.locationField.setText(jarFilename);
    }

    public void setBundleInfoEnabled(boolean state) {
        this.bundleInfoEnabled = state;
    }

    private void initializeWidgets() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c10 = new GridBagConstraints();
        this.fileDisplayBox = new UIDisplayNameBox(2, this.isWizardMode());
        if (this.isWizardMode()) {
            this.fileDisplayBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae2) {
                    if (EjbJarGeneralInspector.this.fileDisplayBox.isCreateNew()) {
                        EjbJarGeneralInspector.this.descriptor.setName(EjbJarGeneralInspector.this.fileDisplayBox.getDisplayName());
                        EjbJarGeneralInspector.this.setBundleInfoEnabled(true);
                    } else {
                        Object obj = EjbJarGeneralInspector.this.fileDisplayBox.getSelectedParentDescriptor();
                        if (obj instanceof EjbBundleDescriptor) {
                            EjbBundleDescriptor t2 = (EjbBundleDescriptor)obj;
                            EjbJarGeneralInspector.this.descriptor.setName(t2.getName());
                            EjbJarGeneralInspector.this.descriptor.setDescription(t2.getDescription());
                            EjbJarGeneralInspector.this.descriptor.setApplication(t2.getApplication());
                            EjbJarGeneralInspector.this.setBundleInfoEnabled(false);
                        } else {
                            EjbJarGeneralInspector.this.setBundleInfoEnabled(true);
                        }
                    }
                    EjbJarGeneralInspector.this.invokeRefresh();
                }
            });
        } else {
            this.fileDisplayBox.setFileLocation(new File("ejb.jar").getAbsolutePath());
            this.fileDisplayBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae2) {
                    EjbJarGeneralInspector.this.descriptor.setName(EjbJarGeneralInspector.this.fileDisplayBox.getDisplayName());
                    EjbJarGeneralInspector.this.invokeRefresh();
                }
            });
        }
        c10.weightx = 1.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 2;
        c10.anchor = 10;
        this.add((Component)this.fileDisplayBox, c10);
        this.contentsPanel = new UIJarPackagerBox(this, "ejbjar", true);
        c10.weightx = 1.0;
        c10.weighty = 0.7;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 5, 5);
        c10.fill = 1;
        c10.anchor = 10;
        this.add((Component)this.contentsPanel, c10);
        UITitledControlButtonBox buttonBox = new UITitledControlButtonBox(null, false);
        buttonBox.setControlButtonLocation(15, true);
        c10.weightx = 1.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 5, 5);
        c10.fill = 2;
        c10.anchor = 10;
        this.add((Component)buttonBox, c10);
        this.descInspector = new DescriptionInspector.DialogDisplayButton(this);
        buttonBox.addControlButton(this.descInspector);
        this.classpathButton = new ManifestClasspathInspector.DialogDisplayButton(this);
        buttonBox.addControlButton(this.classpathButton);
        this.iconInspector = new IconInspector.DialogDisplayButton(this);
        buttonBox.addControlButton(this.iconInspector);
        this.deploymentSettingsButton = new DeploymentSettingsInspector.DialogDisplayButton(this);
        buttonBox.addControlButton(this.deploymentSettingsButton);
    }

    public Object getSelectedTargetDescriptor() {
        if (this.targetChooser != null) {
            return ((TreeCombo)this.targetChooser).getSelectedDescriptor();
        }
        return null;
    }

    public Object getSelectedParentDescriptor() {
        return this.fileDisplayBox.getSelectedParentDescriptor();
    }

    public void descriptionUpdated(String description, Object ref) {
        this.descriptor.setDescription(description);
    }

    public void addLargeIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("large", iconFile, this.descriptor.getApplication().getApplicationArchivist(), this.descriptor, this.descriptor);
        } else {
            this._addWizardIcon("large", iconFile, this.archiveContents, this.descriptor);
        }
    }

    public void addSmallIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("small", iconFile, this.descriptor.getApplication().getApplicationArchivist(), this.descriptor, this.descriptor);
        } else {
            this._addWizardIcon("small", iconFile, this.archiveContents, this.descriptor);
        }
    }

    public void manifestClasspathUpdated(ListModel listModel) {
        Set mfc = this.descriptor.getArchivist().getManifestClasspaths();
        HashSet newSet = new HashSet();
        int i2 = 0;
        while (i2 < listModel.getSize()) {
            newSet.add(listModel.getElementAt(i2));
            ++i2;
        }
        mfc.clear();
        mfc.addAll(newSet);
    }

    public void resourceReferenceUpdated(String dbNameText, String userNameText, String passwdText) {
        ResourceReferenceDescriptor rrd = this.descriptor.getCMPResourceReference();
        if (rrd == null) {
            rrd = new ResourceReferenceDescriptor();
        }
        rrd.setJndiName(dbNameText);
        ResourcePrincipal rp = new ResourcePrincipal(userNameText, passwdText);
        rrd.setResourcePrincipal(rp);
        this.descriptor.setCMPResourceReference(rrd);
    }

    public void generateSQL(String dbName, String userName, String passwd, JDialog owner) throws Exception {
        ResourceReferenceDescriptor rrd = new ResourceReferenceDescriptor();
        rrd.setJndiName(dbName);
        ResourcePrincipal rp = new ResourcePrincipal(userName, passwd);
        rrd.setResourcePrincipal(rp);
        String server = InspectorPane.getServerManager().getCurrentServer();
        DBInfo dBInfo = InspectorPane.getServerManager().getDBInfo(server);
        SQLGenerator.generateSQL(this.descriptor, rrd, true, dBInfo);
    }

    public void addContentsAction(FileContentsDescriptor clsFcd, FileContentsDescriptor conFcd, Vector delCon) throws IOException {
        if (this.isWizardMode()) {
            Enumeration e10 = delCon.elements();
            while (e10.hasMoreElements()) {
                File f2 = (File)e10.nextElement();
                this.archiveContents.removeFile(f2);
            }
            this.archiveContents.addAll(conFcd);
        } else {
            EjbBundleArchivist arch = (EjbBundleArchivist)this.descriptor.getArchivist();
            Vector del = UIJarPackager.convertFilesToArchive(delCon);
            arch.removeEntries(del);
            arch.addFiles(arch.createEntryNameMap(conFcd));
            Application app = this.descriptor.getApplication();
            if (app != null) {
                app.getApplicationArchivist().setClassLoader(null);
            }
            arch.setClassLoader(null);
        }
        this.invokeRefresh();
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        if (this.isDeploymentMode()) {
            this.fileDisplayBox.setFileLocation(this.descriptor.getArchivist().getArchiveUri());
            this.fileDisplayBox.setDisplayName(this.descriptor.getName());
            this.contentsPanel.setContents(this.descriptor);
            DefaultListModel<String> classPathListModel = new DefaultListModel<String>();
            Iterator itr = this.descriptor.getArchivist().getManifestClasspaths().iterator();
            while (itr.hasNext()) {
                String next = (String)itr.next();
                classPathListModel.addElement(next);
            }
            this.classpathButton.setManifestClasspathInspector(classPathListModel, this.descriptor.getName(), this.descriptor);
            ResourceReferenceDescriptor rrd = this.descriptor.getCMPResourceReference();
            this.deploymentSettingsButton.setEnabled(true);
            if (rrd != null) {
                ResourcePrincipal rp = rrd.getResourcePrincipal();
                this.deploymentSettingsButton.setDeploymentSettingsInspector(rrd.getJndiName(), rp.getName(), rp.getPassword());
            } else {
                this.deploymentSettingsButton.setDeploymentSettingsInspector("", "", "");
            }
        } else {
            this.deploymentSettingsButton.setEnabled(false);
            this.classpathButton.setEnabled(this.bundleInfoEnabled);
            this.iconInspector.setEnabled(this.bundleInfoEnabled);
            DefaultListModel contentsListModel = new DefaultListModel();
            DefaultListModel<String> classPathListModel = new DefaultListModel<String>();
            Object obj = this.fileDisplayBox.getSelectedParentDescriptor();
            if (obj instanceof EjbBundleDescriptor) {
                EjbBundleDescriptor ebd = (EjbBundleDescriptor)obj;
                this.contentsPanel.setContents(ebd, null, this.archiveContents);
                Iterator itr = ebd.getArchivist().getManifestClasspaths().iterator();
                while (itr.hasNext()) {
                    String next = (String)itr.next();
                    classPathListModel.addElement(next);
                }
            } else {
                this.contentsPanel.setContents(this.descriptor, null, this.archiveContents);
                Iterator itr = this.descriptor.getArchivist().getManifestClasspaths().iterator();
                while (itr.hasNext()) {
                    String next = (String)itr.next();
                    classPathListModel.addElement(next);
                }
                if (this.fileDisplayBox.getDisplayName().equals("")) {
                    String dispName = this.descriptor.getName();
                    if (obj instanceof Application) {
                        Vector<String> nameList = new Vector<String>();
                        Iterator itr2 = ((Application)obj).getEjbBundleDescriptors().iterator();
                        while (itr2.hasNext()) {
                            nameList.add(((Descriptor)itr2.next()).getName());
                        }
                        String newName = Descriptor.createUniqueNameAmongst(dispName, nameList);
                        if (!newName.equals(dispName)) {
                            dispName = newName;
                            this.descriptor.setName(dispName);
                        }
                    }
                    this.fileDisplayBox.setDisplayName(dispName);
                } else {
                    this.descriptor.setName(this.fileDisplayBox.getDisplayName());
                }
            }
            this.classpathButton.setManifestClasspathInspector(classPathListModel, this.descriptor.getName(), (Descriptor)obj);
        }
        this.descInspector.setDescriptionInspector(this.descriptor.getDescription(), this.descriptor.getName(), this, this.descriptor);
        this.invalidate();
        this.validate();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        ((Component)frame).setBounds(0, 0, 300, 300);
        frame.setContentPane(new EjbJarGeneralInspector(null));
        ((Component)frame).setVisible(true);
    }

    public String toString() {
        return "Ejb Jar Inspector";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

