/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.NewEjbWizard;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.descriptor.DeploymentSettingsDialog;
import com.sun.enterprise.tools.deployment.ui.descriptor.FinderSelectDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIComponentUpdateHandler;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledCheckBoxList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;

public class EjbEntityInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbEntityInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbEntityInspector = EjbEntityInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.EjbEntityInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbEntityInspector);
    private static String TOOLTIP = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.entitybeaninfo", "EntityBean information");
    private static String CMP_TOOLTIP = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.containermanagedfields", "Container managed fields");
    private static String PERSISTENCE_MGMT = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.persistencemanagement", "Persistence management");
    private static String PERSISTENCE_BMP = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.bmp", "Bean managed persistence");
    private static String PERSISTENCE_CMP1 = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.cmpversion1", "Container managed persistence (1.0)");
    private static String PERSISTENCE_CMP2 = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.cmpversion2", "Container managed persistence (2.0)");
    private static String DEPLOYMENT_SETTINGS = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.entitydeploymentsettings", "Deployment Settings...");
    private static String PRIMARY_KEY_CLASS = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.primarykeyclass", "Primary key class:");
    private static String PRIMARY_KEY_FIELD = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.primarykeyfieldname", "Primary key field name:");
    private static String REENTRANT = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.reentrant", "Reentrant");
    private static String ABSTRACT_SCHEMA = localStrings.getLocalString("ui.ejbentityinspector.abstractschemaname", "Abstract Schema Name:");
    private static String FINDER_SELMETH_BTN = localStrings.getLocalString("ui.ejbentityinspector.finderselectmethods_button", "Finder/Select Methods...");
    private static String PERSISTED_FIELDS = localStrings.getLocalString("ui.ejbentityinspector.fieldstobepersisted", "Fields To Be Persisted");
    private static String TABNAME = localStrings.getLocalString("ui.ejbentityinspector.tabname", "Entity");
    private static String wizardHelpID = "Entity";
    private static String deployHelpID = "Entity";
    NewEjbWizard wizard = null;
    private EjbEntityDescriptor descriptor;
    private UITitledTextField primKeyClassText;
    private UITitledComboBox primKeyFieldCombo;
    private UITitledTextField abstractSchemaName;
    private JButton finderSelectPB;
    private JButton deploymentSettingsPB;
    private DeploymentSettingsDialog deploymentSettingsDialog = null;
    private FinderSelectDialog finderSelectDialog;
    private JCheckBox reentrantCB;
    private UITitledCheckBoxList cmpFieldBox;
    private JList cmpFieldList;
    private DefaultListModel cmpFieldListModel;
    private UIRadioButtonBox persistenceMgtPanel;
    private boolean isAdjusting = false;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbEntityInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbEntityDescriptor;

    public void setWizard(NewEjbWizard wizard) {
        this.wizard = wizard;
    }

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new EjbEntityInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$EjbEntityDescriptor == null ? (class$com$sun$enterprise$deployment$EjbEntityDescriptor = EjbEntityInspector.class$("com.sun.enterprise.deployment.EjbEntityDescriptor")) : class$com$sun$enterprise$deployment$EjbEntityDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof EjbEntityDescriptor) {
            this.descriptor = (EjbEntityDescriptor)obj;
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private EjbEntityInspector(String mode) {
        GridBagConstraints c10 = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.setInspectorMode(mode);
        this.setToolTipText(TOOLTIP);
        this.persistenceMgtPanel = new UIRadioButtonBox(PERSISTENCE_MGMT, true);
        this.persistenceMgtPanel.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                if (EjbEntityInspector.this.descriptor != null) {
                    EjbEntityDescriptor newEjb = null;
                    String item = (String)EjbEntityInspector.this.persistenceMgtPanel.getSelectedItem();
                    if (item.equals(PERSISTENCE_BMP)) {
                        if (EjbEntityInspector.this.descriptor instanceof EjbCMPEntityDescriptor) {
                            newEjb = new EjbEntityDescriptor(EjbEntityInspector.this.descriptor);
                        } else if (EjbEntityInspector.this.descriptor instanceof EjbEntityDescriptor) {
                            newEjb = EjbEntityInspector.this.descriptor;
                        }
                        newEjb.setPersistenceType(EjbEntityDescriptor.BEAN_PERSISTENCE);
                    } else {
                        if (EjbEntityInspector.this.descriptor instanceof EjbCMPEntityDescriptor) {
                            newEjb = EjbEntityInspector.this.descriptor;
                        } else if (EjbEntityInspector.this.descriptor instanceof EjbEntityDescriptor) {
                            newEjb = new EjbCMPEntityDescriptor(EjbEntityInspector.this.descriptor);
                        }
                        if (item.equals(PERSISTENCE_CMP1)) {
                            ((EjbCMPEntityDescriptor)newEjb).setCMPVersion(EjbCMPEntityDescriptor.CMP_1_VERSION);
                        } else if (item.equals(PERSISTENCE_CMP2)) {
                            ((EjbCMPEntityDescriptor)newEjb).setCMPVersion(EjbCMPEntityDescriptor.CMP_2_VERSION);
                        }
                    }
                    if (newEjb != EjbEntityInspector.this.descriptor) {
                        newEjb.replaceEntityDescriptor(EjbEntityInspector.this.descriptor);
                        EjbEntityInspector.this.descriptor = newEjb;
                        if (EjbEntityInspector.this.isWizardMode()) {
                            EjbEntityInspector.this.wizard.setCurrentEjbDescriptor(EjbEntityInspector.this.descriptor);
                        }
                    }
                    EjbEntityInspector.this.refreshCMPFields();
                }
            }
        });
        this.persistenceMgtPanel.setReadOnly(this.isDeploymentMode());
        this.persistenceMgtPanel.setModel(new Object[]{PERSISTENCE_BMP, PERSISTENCE_CMP1, PERSISTENCE_CMP2});
        this.persistenceMgtPanel.setSelectedItem(PERSISTENCE_CMP1);
        this.cmpFieldBox = new UITitledCheckBoxList(null, true);
        this.cmpFieldBox.setHeaderText(PERSISTED_FIELDS);
        GridBagConstraints gbc = this.persistenceMgtPanel.getGBConstraintsCopy();
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.insets.left += 15;
        this.persistenceMgtPanel.add((Component)this.cmpFieldBox, gbc);
        this.cmpFieldBox.setToolTipText(CMP_TOOLTIP);
        this.cmpFieldBox.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                UITitledCheckBoxList listBox = (UITitledCheckBoxList)c10;
                FieldDescriptor fieldDesc = (FieldDescriptor)listBox.getSelectedCheckBoxData();
                if (fieldDesc != null) {
                    DefaultComboBoxModel dcbm = (DefaultComboBoxModel)EjbEntityInspector.this.primKeyFieldCombo.getModel();
                    PersistenceDescriptor pers = ((EjbCMPEntityDescriptor)EjbEntityInspector.this.descriptor).getPersistenceDescriptor();
                    String field = fieldDesc.getName();
                    if (listBox.getSelectedCheckBoxState()) {
                        pers.addCMPField(fieldDesc);
                        dcbm.addElement(field);
                    } else {
                        pers.removeCMPField(fieldDesc);
                        dcbm.removeElement(field);
                        EjbEntityInspector.this.savePrimKey();
                    }
                    EjbEntityInspector.this.descriptor.changed();
                }
            }
        });
        this.cmpFieldBox.setControlButtonAnchor(15);
        this.abstractSchemaName = new UITitledTextField(ABSTRACT_SCHEMA, false);
        this.abstractSchemaName.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                if (EjbEntityInspector.this.descriptor instanceof EjbCMPEntityDescriptor) {
                    ((EjbCMPEntityDescriptor)EjbEntityInspector.this.descriptor).setAbstractSchemaName(EjbEntityInspector.this.abstractSchemaName.getText());
                }
            }
        });
        this.cmpFieldBox.addControlComponent(this.abstractSchemaName);
        this.finderSelectPB = new JButton(FINDER_SELMETH_BTN);
        this.finderSelectPB.setMnemonic('F');
        this.finderSelectPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                if (EjbEntityInspector.this.finderSelectDialog == null) {
                    EjbEntityInspector.this.finderSelectDialog = new FinderSelectDialog(EjbEntityInspector.this.finderSelectPB);
                }
                EjbEntityInspector.this.finderSelectDialog.setDescriptor(EjbEntityInspector.this.descriptor);
                EjbEntityInspector.this.finderSelectDialog.show();
            }
        });
        this.cmpFieldBox.addControlButton(this.finderSelectPB);
        this.deploymentSettingsPB = new JButton(DEPLOYMENT_SETTINGS);
        this.deploymentSettingsPB.setMnemonic('D');
        this.deploymentSettingsPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                if (EjbEntityInspector.this.deploymentSettingsDialog == null) {
                    EjbEntityInspector.this.deploymentSettingsDialog = new DeploymentSettingsDialog(EjbEntityInspector.this.getMyParentFrame());
                }
                EjbEntityInspector.this.deploymentSettingsDialog.setDescriptor(EjbEntityInspector.this.descriptor);
                EjbEntityInspector.this.deploymentSettingsDialog.show();
            }
        });
        this.deploymentSettingsPB.setEnabled(this.isDeploymentMode());
        this.cmpFieldBox.addControlButton(this.deploymentSettingsPB);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 2;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        c10.anchor = 10;
        gridbag.setConstraints(this.persistenceMgtPanel, c10);
        this.add(this.persistenceMgtPanel);
        this.primKeyClassText = new UITitledTextField(PRIMARY_KEY_CLASS, false);
        this.primKeyClassText.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                EjbEntityInspector.this.descriptor.setPrimaryKeyClassName(EjbEntityInspector.this.primKeyClassText.getText());
            }
        });
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(2, 10, 2, 5);
        c10.fill = 2;
        c10.anchor = 10;
        gridbag.setConstraints(this.primKeyClassText, c10);
        this.add(this.primKeyClassText);
        this.primKeyFieldCombo = new UITitledComboBox(PRIMARY_KEY_FIELD, false);
        this.primKeyFieldCombo.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                EjbEntityInspector.this.savePrimKey();
            }
        });
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(2, 10, 7, 5);
        c10.fill = 2;
        c10.anchor = 10;
        this.add((Component)this.primKeyFieldCombo, c10);
        this.reentrantCB = new JCheckBox(REENTRANT);
        this.reentrantCB.setMnemonic('r');
        this.reentrantCB.setSelected(false);
        this.reentrantCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbEntityInspector.this.descriptor.setReentrant(EjbEntityInspector.this.reentrantCB.isSelected());
            }
        });
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 3;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 20, 5, 30);
        c10.fill = 0;
        c10.anchor = 17;
        gridbag.setConstraints(this.reentrantCB, c10);
        this.add(this.reentrantCB);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        this.primKeyClassText.setText(this.descriptor.getPrimaryKeyClassName());
        this.reentrantCB.setSelected(this.descriptor.isReentrant());
        this.refreshCMPFields();
    }

    private void refreshCMPFields() {
        if (this.descriptor == null) {
            return;
        }
        this.isAdjusting = true;
        DefaultComboBoxModel<String> dcbm = new DefaultComboBoxModel<String>();
        dcbm.addElement("");
        if (this.descriptor.getPersistenceType().equals(EjbEntityDescriptor.BEAN_PERSISTENCE)) {
            this.cmpFieldBox.setEnabled(false);
            this.cmpFieldBox.clearList();
            this.deploymentSettingsPB.setEnabled(false);
            this.primKeyFieldCombo.setEnabled(false);
            this.persistenceMgtPanel.setSelectedItem(PERSISTENCE_BMP);
        } else if (this.descriptor.getPersistenceType().equals(EjbEntityDescriptor.CONTAINER_PERSISTENCE)) {
            EjbCMPEntityDescriptor cmpDescriptor = (EjbCMPEntityDescriptor)this.descriptor;
            this.cmpFieldBox.setEnabled(true);
            this.cmpFieldBox.clearList();
            this.deploymentSettingsPB.setEnabled(this.isDeploymentMode());
            if (cmpDescriptor.isEJB20()) {
                this.persistenceMgtPanel.setSelectedItem(PERSISTENCE_CMP2);
                this.abstractSchemaName.setText(cmpDescriptor.getAbstractSchemaName());
                this.finderSelectPB.setEnabled(true);
            } else {
                this.persistenceMgtPanel.setSelectedItem(PERSISTENCE_CMP1);
                this.abstractSchemaName.setEnabled(false);
                this.abstractSchemaName.setText("");
                this.finderSelectPB.setEnabled(false);
            }
            PersistenceDescriptor pers = cmpDescriptor.getPersistenceDescriptor();
            Vector allFields = null;
            try {
                allFields = this.descriptor.getFieldDescriptors();
            }
            catch (Throwable t2) {
                if (this.descriptor.getApplication() == null) {
                    UIUtils.debugPrintln("EjbEntityInspector.refreshCMPFields", "descriptor application is NULL!");
                } else {
                    UIUtils.printImplementationError("EjbEntityInspector.refreshCMPFields", "(see stack trace)", t2);
                }
                allFields = new Vector();
            }
            int i2 = 0;
            while (i2 < allFields.size()) {
                FieldDescriptor fieldDesc = (FieldDescriptor)allFields.elementAt(i2);
                boolean isCMPField = pers.isCMPField(fieldDesc.getName());
                this.cmpFieldBox.addCheckBoxData(fieldDesc.getName(), isCMPField, fieldDesc);
                if (isCMPField) {
                    dcbm.addElement(fieldDesc.getName());
                }
                ++i2;
            }
            this.primKeyFieldCombo.setEnabled(true);
            this.primKeyFieldCombo.setModel(dcbm);
            if (cmpDescriptor.getPrimaryKeyFieldDesc() == null) {
                this.primKeyFieldCombo.setSelectedItem("");
            } else {
                this.primKeyFieldCombo.setSelectedItem(cmpDescriptor.getPrimaryKeyFieldDesc().getName());
            }
        }
        this.isAdjusting = false;
    }

    private void savePrimKey() {
        if (!this.isAdjusting) {
            String fieldName = (String)this.primKeyFieldCombo.getSelectedItem();
            if (this.descriptor.getPersistenceType().equals(EjbEntityDescriptor.CONTAINER_PERSISTENCE)) {
                EjbCMPEntityDescriptor desc = (EjbCMPEntityDescriptor)this.descriptor;
                if (!"".equals(fieldName)) {
                    desc.setPrimaryKeyFieldDesc(new FieldDescriptor(fieldName, ""));
                } else {
                    desc.setPrimaryKeyFieldDesc(null);
                }
            }
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        EjbEntityInspector myPanel = new EjbEntityInspector("DeploymentMode");
        frame.getContentPane().add((Component)myPanel, "Center");
        ((Component)frame).setSize(myPanel.getPreferredSize());
        ((Component)frame).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

