/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class UIUtils {
    public static final String ABOUT_MSG = "J2EE Deploytool 1.0";
    public static JWindow splashPanel;
    private static final String UI_PACKAGE = "com.sun.enterprise.tools.deployment.ui.";
    private static final String DEBUG_LOG_FILE = ".j2eeDeploytoolDebugLog.out";
    private static final String EXCEPTION_LOG_FILE = ".j2eeDeploytoolExceptionLog.out";
    private static boolean initDebugLogPrintStream;
    private static PrintStream debugLogPrintStream;
    private static File excepLogFile;
    private static PrintStream excepLogPrintStream;
    private static long startTime;
    private static Comparator stringComparator;
    static /* synthetic */ Class class$java$awt$Container;
    static /* synthetic */ Class class$java$awt$Dialog;
    static /* synthetic */ Class class$java$awt$Frame;

    public static String getStackFrame(int num, boolean fmt) {
        Throwable t2 = new Throwable();
        t2.fillInStackTrace();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        t2.printStackTrace(ps);
        StringTokenizer st = new StringTokenizer(bos.toString(), "\n");
        st.nextToken();
        st.nextToken();
        while (num > 0) {
            st.nextToken();
            --num;
        }
        String frame = st.nextToken().trim();
        if (frame.startsWith("at ")) {
            frame = frame.substring(3);
        }
        if (fmt) {
            int fs = frame.startsWith(UI_PACKAGE) ? UI_PACKAGE.length() : 0;
            int fe2 = frame.indexOf(40);
            if (fe2 < 0) {
                fe2 = frame.length();
            }
            String classDotMeth = frame.substring(fs, fe2);
            if (fe2 < frame.length()) {
                int ln2;
                int ln1 = frame.indexOf(58, fe2);
                int n2 = ln2 = ln1 >= 0 ? frame.indexOf(41, ln1) : ln1;
                if (ln2 >= 0) {
                    classDotMeth = classDotMeth + frame.substring(ln1, ln2);
                }
            }
            frame = classDotMeth;
        }
        return frame;
    }

    public static String debugClassName(Class c10) {
        String cn2 = c10.getName();
        return cn2.startsWith(UI_PACKAGE) ? cn2.substring(UI_PACKAGE.length()) : cn2;
    }

    public static boolean debugMode() {
        return UIConfig.debugMode();
    }

    public static void debugPrintln(String frame, String msg) {
        if (UIConfig.debugMode()) {
            UIUtils._debugPrintln(frame, msg);
        }
    }

    public static void debugPrintln(String msg) {
        if (UIConfig.debugMode()) {
            UIUtils._debugPrintln(UIUtils.getStackFrame(1, true), msg);
        }
    }

    public static void debugPrintln(int subFrame, String msg) {
        if (UIConfig.debugMode()) {
            UIUtils._debugPrintln(UIUtils.getStackFrame(1 + subFrame, true), msg);
        }
    }

    private static void _debugPrintln(String frame, String msg) {
        if (frame != null) {
            UIUtils.println("[" + frame + "] " + msg);
        } else {
            UIUtils.println("[DEBUG] " + msg);
        }
    }

    public static PrintStream getDebugLogStream() {
        if (!initDebugLogPrintStream) {
            initDebugLogPrintStream = true;
            String tmpdir = System.getProperties().getProperty("java.io.tmpdir", "/tmp");
            File logFile = new File(tmpdir, DEBUG_LOG_FILE);
            try {
                debugLogPrintStream = new PrintStream(new FileOutputStream(logFile), true);
                UIUtils.debugPrintln("Openned debug logfile: " + logFile.getPath());
            }
            catch (Exception ex2) {
                UIUtils.debugPrintln("Unable to open debug logfile: " + logFile.getPath() + " [" + ex2.toString() + "]");
            }
        }
        return debugLogPrintStream;
    }

    public static void printException(String msg, Throwable t2) {
        int log;
        int n2 = log = UIConfig.debugMode() ? 2 : UIConfig.getConfigInteger("ui.logExceptions", 0);
        if (log > 0) {
            PrintStream out;
            PrintStream printStream = out = log > 1 ? UIUtils.getExceptionLogStream() : null;
            if (out != null) {
                UIUtils.println("Exception Log: " + msg + " - " + t2.toString() + "(see file " + excepLogFile.toString() + ")");
            }
            UIUtils.formatStackTrace("Exception", out, UIUtils.getStackFrame(1, true), msg, t2);
        }
    }

    private static PrintStream getExceptionLogStream() {
        if (excepLogFile == null && excepLogPrintStream == null) {
            String tmpdir = System.getProperties().getProperty("java.io.tmpdir", "/tmp");
            excepLogFile = new File(tmpdir, EXCEPTION_LOG_FILE);
            try {
                excepLogPrintStream = new PrintStream(new FileOutputStream(excepLogFile), true);
                UIUtils.debugPrintln("Openned exception logfile: " + excepLogFile.getPath());
            }
            catch (Exception ex2) {
                UIUtils.debugPrintln("Unable to open exception logfile: " + excepLogFile.getPath() + " [" + ex2.toString() + "]");
            }
        }
        return excepLogPrintStream;
    }

    public static void testPrintln(String msg) {
        if (UIConfig.testMode()) {
            UIUtils._debugPrintln(UIUtils.getStackFrame(1, true), msg);
        }
    }

    private static void print(PrintStream out, String msg) {
        (out != null ? out : System.out).print(msg);
    }

    public static void print(String msg) {
        UIUtils.print(null, msg);
    }

    public static void println(PrintStream out, String msg) {
        UIUtils.print(out, msg + "\n");
    }

    public static void println(String msg) {
        UIUtils.println(null, msg);
    }

    public static void printImplementationError(String msg) {
        UIUtils.formatStackTrace("Implementation Error", null, UIUtils.getStackFrame(1, true), msg, null);
    }

    public static void printImplementationError(String msg, Throwable t2) {
        UIUtils.formatStackTrace("Implementation Error", null, UIUtils.getStackFrame(1, true), msg, t2);
    }

    public static void printImplementationError(String name, String msg) {
        UIUtils.formatStackTrace("Implementation Error", null, name, msg, null);
    }

    public static void printImplementationError(String name, String msg, Throwable t2) {
        UIUtils.formatStackTrace("Implementation Error", null, name, msg, t2);
    }

    public static void debugLogStackTrace(String msg) {
        if (UIUtils.debugMode()) {
            String frame = UIUtils.getStackFrame(1, true);
            PrintStream out = UIUtils.getDebugLogStream();
            if (out != null) {
                UIUtils.debugPrintln(frame, "{log} " + msg);
            }
            UIUtils.formatStackTrace("Debug Stack Trace", out, frame, msg, null);
        }
    }

    public static void debugImplementationError(String msg) {
        if (UIUtils.debugMode()) {
            String frame = UIUtils.getStackFrame(1, true);
            PrintStream out = UIUtils.getDebugLogStream();
            if (out != null) {
                UIUtils.debugPrintln(frame, "{log} " + msg);
            }
            UIUtils.formatStackTrace("Debug Implementation Error", out, frame, msg, null);
        }
    }

    public static void debugImplementationError(String msg, Throwable t2) {
        if (UIUtils.debugMode()) {
            String frame = UIUtils.getStackFrame(1, true);
            PrintStream out = UIUtils.getDebugLogStream();
            if (out != null) {
                UIUtils.debugPrintln(frame, "{log} " + msg + " (" + t2.toString() + ")");
            }
            UIUtils.formatStackTrace("Debug Implementation Error", out, frame, msg, t2);
        }
    }

    public static void debugImplementationError(String frame, String msg) {
        if (UIUtils.debugMode()) {
            PrintStream out = UIUtils.getDebugLogStream();
            if (out != null) {
                UIUtils.debugPrintln(frame, "{log} " + msg);
            }
            UIUtils.formatStackTrace("Debug Implementation Error", out, frame, msg, null);
        }
    }

    public static void debugImplementationError(String frame, String msg, Throwable t2) {
        if (UIUtils.debugMode()) {
            PrintStream out = UIUtils.getDebugLogStream();
            if (out != null) {
                UIUtils.debugPrintln(frame, "{log} " + msg + " (" + t2.toString() + ")");
            }
            UIUtils.formatStackTrace("Debug Implementation Error", out, frame, msg, t2);
        }
    }

    private static void formatStackTrace(String title, PrintStream out, String name, String msg, Throwable exception) {
        String _dash = "--------------------";
        String dashLine = "--------------------------------------------------------------------------------\n";
        String _ttl = " " + title + " ";
        String errTitle = "--------------------------------------------------------------------------------\n".substring(0, 16) + _ttl + "--------------------------------------------------------------------------------\n".substring(16 + _ttl.length());
        if (out == null) {
            out = System.out;
        }
        UIUtils.print(out, "\n");
        UIUtils.print(out, "--------------------------------------------------------------------------------\n" + errTitle);
        UIUtils.print(out, "ERROR: [" + name + "]\n" + msg + "\n");
        if (exception != null) {
            UIUtils.print(out, exception.toString() + "\n");
            UIUtils.print(out, "--------------------------------------------------------------------------------\n");
            exception.printStackTrace(out);
        } else {
            UIUtils.print(out, "--------------------------------------------------------------------------------\n");
            UIUtils.print(out, "Stack Trace:\n");
            Throwable t2 = new Throwable();
            t2.fillInStackTrace();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            t2.printStackTrace(ps);
            StringTokenizer st = new StringTokenizer(bos.toString(), "\n");
            st.nextToken();
            st.nextToken();
            st.nextToken();
            while (st.hasMoreTokens()) {
                UIUtils.println(out, st.nextToken());
            }
        }
        UIUtils.print(out, "--------------------------------------------------------------------------------\n");
        UIUtils.print(out, "\n");
    }

    public static void showNotImplemented(Component c10) {
        UIOptionPane.showNotImplemented(c10);
    }

    public static void debugPrintLapseTime(String msg) {
        if (startTime == 0L) {
            startTime = System.currentTimeMillis();
        }
        long now = System.currentTimeMillis();
        UIUtils.println("[LapseTime=" + (now - startTime) + "ms] " + msg);
    }

    public static Comparator getStringComparator() {
        if (stringComparator == null) {
            stringComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return o1.toString().compareTo(o2.toString());
                }

                public boolean equals(Object o2) {
                    return super.equals(o2);
                }
            };
        }
        return stringComparator;
    }

    public static void showSplashPanel() {
        if (splashPanel == null) {
            splashPanel = new JWindow();
            splashPanel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent me) {
                    if (splashPanel != null) {
                        ((Component)splashPanel).setVisible(false);
                    }
                }
            });
            splashPanel.getContentPane().setLayout(new BorderLayout());
            ImageIcon imageIcon = UIIcons.getImageIconFor(UIIcons.SPLASH_ICON);
            if (imageIcon == null) {
                UIUtils.println("Could not find splash screen image: " + UIIcons.SPLASH_ICON);
            }
            splashPanel.getContentPane().add(new JLabel(imageIcon));
            int splashWidth = imageIcon.getIconWidth();
            int splashHeight = imageIcon.getIconHeight();
            Dimension screenRectangle = Toolkit.getDefaultToolkit().getScreenSize();
            double splashX = (screenRectangle.getWidth() - (double)splashWidth) / 2.0;
            double splashY = (screenRectangle.getHeight() - (double)splashHeight) / 2.0;
            ((Component)splashPanel).setBounds((int)splashX, (int)splashY, splashWidth, splashHeight);
        }
        ((Component)splashPanel).setVisible(true);
    }

    public static void hideSplashPanel() {
        if (splashPanel != null) {
            ((Component)splashPanel).setVisible(false);
            splashPanel = null;
        }
    }

    public static Container getAncestorOfClass(Class c10, Component comp) {
        if (comp == null || c10 == null) {
            UIUtils.printImplementationError("UIUtils.getAncestorOfClass", "null argument");
            return null;
        }
        if (!c10.isInterface() && !(class$java$awt$Container == null ? (class$java$awt$Container = UIUtils.class$("java.awt.Container")) : class$java$awt$Container).isAssignableFrom(c10)) {
            UIUtils.printImplementationError("UIUtils.getAncestorOfClass", "Not a Container class [" + c10.getName() + "]");
            return null;
        }
        if (c10.isInstance(comp)) {
            return (Container)comp;
        }
        return SwingUtilities.getAncestorOfClass(c10, comp);
    }

    public static Window getAncestorWindow(Component comp) {
        Window win = (Window)UIUtils.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = UIUtils.class$("java.awt.Dialog")) : class$java$awt$Dialog, comp);
        if (win == null) {
            win = (Window)UIUtils.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = UIUtils.class$("java.awt.Frame")) : class$java$awt$Frame, comp);
        }
        return win;
    }

    public static Frame getAncestorFrame(Component comp) {
        return (Frame)UIUtils.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = UIUtils.class$("java.awt.Frame")) : class$java$awt$Frame, comp);
    }

    public static Dialog getAncestorDialog(Component comp) {
        return (Dialog)UIUtils.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = UIUtils.class$("java.awt.Dialog")) : class$java$awt$Dialog, comp);
    }

    public static Rectangle getCenterRectangleFrom(Rectangle rectangle, double proportionX, double proportionY) {
        int newX = (int)(rectangle.getWidth() * (1.0 - proportionX) / 2.0);
        int newY = (int)(rectangle.getHeight() * (1.0 - proportionY) / 2.0);
        Rectangle r2 = new Rectangle(newX, newY, (int)(proportionX * rectangle.getWidth()), (int)(proportionY * rectangle.getHeight()));
        return r2;
    }

    public static void makeFontPlain(JComponent component) {
        component.setFont(component.getFont().deriveFont(0));
        component.setForeground(Color.black);
    }

    public static JPanel createBorderedPanel(String title, LayoutManager l2) {
        TitledBorder b10 = new TitledBorder(new LineBorder(Color.black, 0), title);
        JPanel p2 = new JPanel();
        UIUtils.makeFontPlain(p2);
        p2.setBorder(b10);
        if (l2 != null) {
            p2.setLayout(l2);
        }
        UIUtils.makeFontPlain(p2);
        return p2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        initDebugLogPrintStream = false;
        debugLogPrintStream = null;
        excepLogFile = null;
        excepLogPrintStream = null;
        startTime = 0L;
        stringComparator = null;
    }

    public static class ImagePanel
    extends JPanel {
        private Image image;

        public ImagePanel(Image i2) {
            this.image = i2;
            this.setSize(this.image.getWidth(this), this.image.getHeight(this));
        }

        protected void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            g2.drawImage(this.image, 0, 0, this.getSize().width, this.getSize().height, 0, 0, this.image.getWidth(this), this.image.getHeight(this), this);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        }
    }
}

