/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.tools.deployment.main.ApplicationManager;
import com.sun.enterprise.tools.deployment.main.ServerException;
import com.sun.enterprise.tools.deployment.main.ServerManager;
import com.sun.enterprise.tools.deployment.main.StandAloneManager;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.DeployedAppDescriptor;
import com.sun.enterprise.tools.deployment.ui.DeployedObjectDescriptor;
import com.sun.enterprise.tools.deployment.ui.ServerDescriptor;
import com.sun.enterprise.tools.deployment.ui.TreeCombo;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class DescriptorTreeView
extends JPanel
implements NotificationListener {
    protected static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$DescriptorTreeView == null ? (class$com$sun$enterprise$tools$deployment$ui$DescriptorTreeView = DescriptorTreeView.class$("com.sun.enterprise.tools.deployment.ui.DescriptorTreeView")) : class$com$sun$enterprise$tools$deployment$ui$DescriptorTreeView);
    private static final String FILES_DESCRIPTOR = localStrings.getLocalString("ui.descriptortreeview.root.files", "Files");
    private static final String APPS_DESCRIPTOR = localStrings.getLocalString("ui.descriptortreeview.root.applications", "Applications");
    private static final String RAR_DESCRIPTOR = localStrings.getLocalString("ui.descriptortreeview.root.resource_adapters", "Resource Adapters");
    private static final String SA_DESCRIPTOR = localStrings.getLocalString("ui.descriptortreeview.root.stand_alone", "Stand Alone");
    private static final String SERV_DESCRIPTOR = localStrings.getLocalString("ui.descriptortreeview.root.servers", "Servers");
    private static Color selectedServerTextColor = Color.darkGray;
    public static int AppType_Client;
    public static int AppType_ClientOnly;
    public static int AppType_Client_sn;
    public static int AppType_EJB;
    public static int AppType_EJBOnly;
    public static int AppType_EJB_sn;
    public static int AppType_WAR;
    public static int AppType_WAROnly;
    public static int AppType_WAR_sn;
    public static int AppType_ResAdapt;
    public static int AppType_ResAdaptOnly;
    public static int AppType_ResAdapt_sn;
    public static int AppType_Apps;
    public static int AppType_AppsOnly;
    public static int AppType_AppsAndEJBs;
    public static int AppType_AppsAndWars;
    public static int AppType_AppsEjbsWars;
    private static int BUILDTREE_APPLICATION;
    private static int BUILDTREE_STANDALONE;
    private static int BUILDTREE_SERVER;
    private static int BUILDTREE_ALL;
    private JTree rootTree = null;
    private Descriptor lastSelectedDescriptor = null;
    private DefaultMutableTreeNode fixedRootNode = null;
    private DefaultMutableTreeNode fixedFilesNode = null;
    private DefaultMutableTreeNode fixedApplicationNode = null;
    private DefaultMutableTreeNode fixedStandAloneNode = null;
    private DefaultMutableTreeNode fixedServerNode = null;
    private static String[] dbgDepCls;
    private static int dbgNdx;
    private static final String FAKE_EDITOR_OBJECT = "*Resizer*";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$DescriptorTreeView;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$BundleDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ApplicationClientDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ConnectorDescriptor;

    public static String createNodeString(Descriptor node, Descriptor app) {
        if (node == null) {
            return "";
        }
        return app == null || app == node ? node.getName() : node.getName() + " (" + app.getName() + ")";
    }

    public DescriptorTreeView() {
        this(new RootTree());
    }

    public DescriptorTreeView(JTree rootTree) {
        this.rootTree = rootTree;
        this.fixedRootNode = new DefaultMutableTreeNode(new GrandpaRootDescriptor(), true);
        this.fixedFilesNode = new DescriptorTreeNode(new FilesRootDescriptor(), true);
        this.fixedApplicationNode = new DescriptorTreeNode(new ApplicationsRootDescriptor(), true);
        this.fixedStandAloneNode = new DescriptorTreeNode(new StandAloneRootDescriptor(), true);
        this.fixedServerNode = new DescriptorTreeNode(new ServersRootDescriptor(), true);
        this.resetRootNodes();
        this.rootTree.setModel(new DefaultTreeModel(this.fixedRootNode));
        this.rootTree.setCellRenderer(new RootTreeCellRenderer());
        this.rootTree.setCellEditor(new DefaultTreeCellEditor(this.rootTree, null, new RootTreeCellEditor()));
        this.rootTree.setRootVisible(false);
        this.rootTree.setShowsRootHandles(true);
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new LineBorder(Color.black, 0));
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add(new JScrollPane(rootTree));
        this.add(mainPanel);
        TreeSelectionModel selectionModel = this.rootTree.getSelectionModel();
        selectionModel.setSelectionMode(1);
        this.rootTree.setSelectionModel(selectionModel);
        this.buildView();
        this.rootTree.addTreeSelectionListener(new TreeSelectionListener(){
            int disable = 0;

            public void valueChanged(TreeSelectionEvent tse) {
                if (this.disable != 0) {
                    return;
                }
                ++this.disable;
                DescriptorTreeView.this.manageTreeSelections(tse);
                --this.disable;
                TreePath selPath = tse.getNewLeadSelectionPath();
                DescriptorTreeView.this.lastSelectedDescriptor = selPath != null ? (Descriptor)((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject() : null;
                Descriptor mainDesc = DescriptorTreeView.this.getMainDescriptorFor(selPath);
                if (DescriptorTreeView.this._setActiveDescriptor(mainDesc)) {
                    // empty if block
                }
            }
        });
        this.rootTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e10) {
                if (e10.getModifiers() == 17) {
                    DescriptorTreeView.this.buildView();
                    return;
                }
            }
        });
        DT.getApplicationManager().addNotificationListener(this);
        DT.getStandAloneManager().addNotificationListener(this);
        DT.getServerManager().addNotificationListener(this);
        this.setPreferredSize(this.getMaximumSize());
    }

    public void manageTreeSelections(TreeSelectionEvent tse) {
        JTree tree = (JTree)tse.getSource();
        if (tree.getSelectionModel().getSelectionMode() == 1) {
            return;
        }
    }

    public JTree getRootTree() {
        return this.rootTree;
    }

    public Descriptor getSelectedParent() {
        TreePath selection = this.rootTree.getSelectionPath();
        if (selection == null) {
            return null;
        }
        Object[] p2 = selection.getPath();
        DefaultMutableTreeNode n2 = p2.length >= 2 ? (DefaultMutableTreeNode)p2[p2.length - 2] : (DefaultMutableTreeNode)p2[p2.length - 1];
        return (Descriptor)n2.getUserObject();
    }

    public Application getSelectedApplication() {
        TreePath[] selPath = this.rootTree.getSelectionModel().getSelectionPaths();
        if (selPath != null) {
            int i2 = 0;
            while (i2 < selPath.length) {
                Descriptor clickNode = this.getMainDescriptorFor(selPath[i2]);
                if (clickNode instanceof Application) {
                    return (Application)clickNode;
                }
                ++i2;
            }
        }
        return null;
    }

    public Descriptor getSelectedStandAlone() {
        TreePath[] selPath = this.rootTree.getSelectionModel().getSelectionPaths();
        if (selPath != null) {
            int i2 = 0;
            while (i2 < selPath.length) {
                Descriptor clickNode = this.getMainDescriptorFor(selPath[i2]);
                if (clickNode instanceof ConnectorDescriptor) {
                    return clickNode;
                }
                ++i2;
            }
        }
        return null;
    }

    public ServerDescriptor getSelectedServer() {
        TreePath[] selPath = this.rootTree.getSelectionModel().getSelectionPaths();
        if (selPath != null) {
            int i2 = 0;
            while (i2 < selPath.length) {
                Descriptor clickNode = this.getMainDescriptorFor(selPath[i2]);
                if (clickNode instanceof ServerDescriptor) {
                    return (ServerDescriptor)clickNode;
                }
                ++i2;
            }
        }
        return null;
    }

    public Descriptor getSelectedServerObject() {
        Descriptor d10 = this.getSelectedDescriptor();
        if (d10 instanceof DeployedAppDescriptor || d10 instanceof DeployedObjectDescriptor) {
            return d10;
        }
        return null;
    }

    private void resetRootNodes() {
        if (this.fixedFilesNode != null && !this.fixedRootNode.isNodeChild(this.fixedFilesNode)) {
            this.fixedRootNode.add(this.fixedFilesNode);
        }
    }

    private void buildView(int reason) {
        Enumeration e10;
        NotificationListener am2;
        DefaultTreeModel treeModel = this.getRootTreeModel();
        if (reason == 0) {
            reason = BUILDTREE_ALL;
        }
        TreePath selection = this.rootTree.getSelectionPath();
        if ((reason & BUILDTREE_APPLICATION) != 0) {
            if (this.fixedApplicationNode.getParent() != null) {
                treeModel.removeNodeFromParent(this.fixedApplicationNode);
            }
            this.fixedApplicationNode.removeAllChildren();
            am2 = DT.getApplicationManager();
            if (am2 != null) {
                e10 = ((ApplicationManager)am2).getApplications().elements();
                while (e10.hasMoreElements()) {
                    this.addApplicationNode((Application)e10.nextElement(), null);
                }
            }
        }
        if ((reason & BUILDTREE_STANDALONE) != 0) {
            if (this.fixedStandAloneNode.getParent() != null) {
                treeModel.removeNodeFromParent(this.fixedStandAloneNode);
            }
            this.fixedStandAloneNode.removeAllChildren();
            am2 = DT.getStandAloneManager();
            if (am2 != null) {
                e10 = ((StandAloneManager)am2).getStandAlones().elements();
                while (e10.hasMoreElements()) {
                    this.addStandAloneNode((Descriptor)e10.nextElement());
                }
            }
        }
        if ((reason & BUILDTREE_SERVER) != 0) {
            if (this.fixedServerNode.getParent() != null) {
                treeModel.removeNodeFromParent(this.fixedServerNode);
            }
            this.fixedServerNode.removeAllChildren();
            ServerManager sm = DT.getServerManager();
            if (sm != null) {
                e10 = sm.getServerNames().elements();
                while (e10.hasMoreElements()) {
                    this.addServerNode(new ServerDescriptor((String)e10.nextElement()));
                }
            }
        }
        this.rootTree.setSelectionPath(selection);
    }

    public void buildView() {
        this.buildView(BUILDTREE_ALL);
    }

    public DefaultTreeModel getRootTreeModel() {
        return (DefaultTreeModel)this.rootTree.getModel();
    }

    public TreePath getTreePathFor(Descriptor d10) {
        DefaultMutableTreeNode child;
        if (d10 != null && (child = this._searchNodes(this.fixedRootNode, d10)) != null) {
            return new TreePath(child.getPath());
        }
        return null;
    }

    private DefaultMutableTreeNode _searchNodes(DefaultMutableTreeNode node, Descriptor d10) {
        Enumeration<TreeNode> e10 = node.children();
        while (e10.hasMoreElements()) {
            DefaultMutableTreeNode child;
            DefaultMutableTreeNode sn = (DefaultMutableTreeNode)e10.nextElement();
            if (sn.getUserObject() == d10) {
                return sn;
            }
            if (sn.getChildCount() <= 0 || (child = this._searchNodes(sn, d10)) == null) continue;
            return child;
        }
        return null;
    }

    private DefaultMutableTreeNode getNodeFor(Descriptor d10) {
        TreePath tp = this.getTreePathFor(d10);
        return tp == null ? null : (DefaultMutableTreeNode)tp.getLastPathComponent();
    }

    public boolean replaceNodeDescriptor(Descriptor oldVal, Descriptor newVal) {
        DefaultMutableTreeNode dmtn = this.getNodeFor(oldVal);
        if (dmtn != null) {
            dmtn.setUserObject(newVal);
            return true;
        }
        return false;
    }

    public Descriptor getMainDescriptorFor(TreePath tp) {
        if (tp != null) {
            int cnt = tp.getPathCount();
            int i2 = 1;
            while (i2 < cnt) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getPathComponent(i2);
                Object obj = node.getUserObject();
                if (obj instanceof Application || obj instanceof ServerDescriptor) {
                    return (Descriptor)obj;
                }
                if (obj instanceof ConnectorDescriptor) {
                    return (Descriptor)obj;
                }
                ++i2;
            }
        }
        return null;
    }

    private Set getSubNodesFor(DefaultMutableTreeNode tn, Class type) {
        HashSet<DefaultMutableTreeNode> subNodes = new HashSet<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e10 = tn.children();
        while (e10.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)e10.nextElement();
            if (type != null && !type.isInstance(next.getUserObject())) continue;
            subNodes.add(next);
        }
        return subNodes;
    }

    public void expandDescriptor(Descriptor d10) {
        this.setSelectedDescriptor(d10, true);
    }

    public void clearSelection() {
        this.rootTree.clearSelection();
    }

    public void setSelectedDescriptor(Descriptor d10, boolean expand) {
        TreePath treePath = this.getTreePathFor(d10);
        Descriptor mainDesc = this.getMainDescriptorFor(treePath);
        if (this._setActiveDescriptor(mainDesc)) {
            if (expand) {
                this.rootTree.expandPath(treePath);
            }
            this.rootTree.setSelectionPath(treePath);
        } else {
            this.rootTree.clearSelection();
        }
    }

    private boolean _setActiveDescriptor(Descriptor mainDesc) {
        ApplicationManager am2 = DT.getApplicationManager();
        StandAloneManager sam = DT.getStandAloneManager();
        ServerManager sm = DT.getServerManager();
        boolean somethingSelected = false;
        Application actvApp = null;
        String actvServer = null;
        Descriptor actvStandAlone = null;
        if (mainDesc instanceof Application) {
            actvApp = (Application)mainDesc;
            somethingSelected = true;
        } else if (mainDesc instanceof ServerDescriptor) {
            actvServer = mainDesc.getName();
            somethingSelected = true;
        } else if (sam.isStandAloneDescriptor(mainDesc)) {
            actvStandAlone = mainDesc;
            somethingSelected = true;
        }
        if (actvServer != null) {
            sm.setCurrentServer(actvServer);
            this.rootTree.repaint();
        } else {
            am2.setActiveApplication(actvApp);
            if (actvApp != null) {
                actvApp.changed();
            }
            sam.setActiveStandAlone(actvStandAlone);
            if (actvStandAlone != null) {
                actvStandAlone.changed();
            }
        }
        return somethingSelected;
    }

    public Descriptor getSelectedDescriptor() {
        Descriptor descriptor = null;
        TreePath selection = this.rootTree.getSelectionPath();
        if (selection != null) {
            Object[] elements = selection.getPath();
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)elements[elements.length - 1];
            descriptor = (Descriptor)tn.getUserObject();
        }
        return descriptor;
    }

    public void updateForAdd(Descriptor d10) {
        DefaultTreeModel treeModel = this.getRootTreeModel();
        if (d10 instanceof Application) {
            this.addApplicationNode((Application)d10, null);
        } else if (d10 instanceof ServerDescriptor) {
            this.addServerNode((ServerDescriptor)d10);
        } else if (d10 instanceof ConnectorDescriptor) {
            this.addStandAloneNode((ConnectorDescriptor)d10);
        } else {
            UIUtils.printImplementationError("DescriptorTreeView.updateForAdd", "Unknown descriptor type - " + d10.getClass().getName());
        }
        this.setSelectedDescriptor(d10, true);
        this.rootTree.validate();
    }

    public void updateForRemove(Descriptor a) {
        DefaultMutableTreeNode node = this.getNodeFor(a);
        if (node != null) {
            this.getRootTreeModel().removeNodeFromParent(node);
        }
    }

    public void updateForActive(Descriptor node) {
    }

    public synchronized void notification(NotificationEvent ne) {
        Object src = ne.getSource();
        if (src instanceof ApplicationManager) {
            this.appNotification(ne);
        } else if (src instanceof StandAloneManager) {
            this.standaloneNotification(ne);
        } else if (src instanceof ServerManager) {
            this.serverNotification(ne);
        } else {
            UIUtils.println("DescriptorTreeView.notification: Unused notification from " + src.getClass().getName() + " [type=" + ne.getType() + "]");
        }
    }

    protected void updateConnectorBundleNode(DefaultMutableTreeNode node) {
        ConnectorDescriptor d10 = (ConnectorDescriptor)node.getUserObject();
        Object p2 = null;
        DefaultTreeModel treeModel = this.getRootTreeModel();
        if (node.getChildCount() > 0) {
            return;
        }
    }

    protected void updateEjbBundleNode(DefaultMutableTreeNode childBundleNode) {
        EjbBundleDescriptor ebd = (EjbBundleDescriptor)childBundleNode.getUserObject();
        Vector list = new Vector();
        list.addAll(ebd.getEjbs());
        this.addBundleNode(this.getRootTreeModel(), childBundleNode, list);
    }

    protected void updateWebBundleNode(DefaultMutableTreeNode childBundleNode) {
        this.addBundleNode(this.getRootTreeModel(), childBundleNode, ((WebBundleDescriptor)childBundleNode.getUserObject()).getWebComponentDescriptorsSet());
    }

    protected void addBundleNode(DefaultTreeModel treeModel, DefaultMutableTreeNode bundleNode, Collection bundleDescriptors) {
        if (bundleNode == null) {
            return;
        }
        if (bundleDescriptors == null) {
            return;
        }
        HashSet<DefaultMutableTreeNode> childNodes = new HashSet<DefaultMutableTreeNode>();
        HashSet<Object> childNodeDescriptors = new HashSet<Object>();
        Enumeration<TreeNode> e10 = bundleNode.children();
        while (e10.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e10.nextElement();
            childNodes.add(node);
            childNodeDescriptors.add(node.getUserObject());
        }
        Iterator itr = childNodes.iterator();
        while (itr.hasNext()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)itr.next();
            if (bundleDescriptors.contains(node.getUserObject())) continue;
            if (treeModel != null) {
                treeModel.removeNodeFromParent(node);
            } else {
                bundleNode.remove(node);
            }
            childNodeDescriptors.remove(node.getUserObject());
        }
        Iterator itr2 = bundleDescriptors.iterator();
        while (itr2.hasNext()) {
            Descriptor d10 = (Descriptor)itr2.next();
            if (childNodeDescriptors.contains(d10)) continue;
            DescriptorTreeNode node = new DescriptorTreeNode(d10, false);
            if (treeModel != null) {
                treeModel.insertNodeInto(node, bundleNode, 0);
                continue;
            }
            bundleNode.add(node);
        }
    }

    private void addApplicationNode(Application application, DefaultMutableTreeNode appRootNode) {
        Object e10 = null;
        Object d10 = null;
        DefaultTreeModel treeModel = this.getRootTreeModel();
        if (appRootNode == null) {
            appRootNode = this.fixedApplicationNode;
        }
        if (!this.fixedFilesNode.isNodeChild(appRootNode)) {
            treeModel.insertNodeInto(appRootNode, this.fixedFilesNode, 0);
        }
        DescriptorTreeNode applicationNode = new DescriptorTreeNode(application, true);
        treeModel.insertNodeInto(applicationNode, appRootNode, appRootNode.getChildCount());
        Iterator itr = application.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            DescriptorTreeNode bundleNode = new DescriptorTreeNode((Descriptor)itr.next(), true);
            treeModel.insertNodeInto(bundleNode, applicationNode, 0);
            this.updateEjbBundleNode(bundleNode);
        }
        Iterator itr2 = application.getWebBundleDescriptors().iterator();
        while (itr2.hasNext()) {
            DescriptorTreeNode bundleNode = new DescriptorTreeNode((Descriptor)itr2.next(), true);
            treeModel.insertNodeInto(bundleNode, applicationNode, 0);
            this.updateWebBundleNode(bundleNode);
        }
        Iterator itr3 = application.getApplicationClientDescriptors().iterator();
        while (itr3.hasNext()) {
            ApplicationClientDescriptor acd = (ApplicationClientDescriptor)itr3.next();
            DescriptorTreeNode tn = new DescriptorTreeNode(acd, false);
            treeModel.insertNodeInto(tn, applicationNode, 0);
        }
        Iterator itr4 = application.getRarDescriptors().iterator();
        while (itr4.hasNext()) {
            DescriptorTreeNode bundleNode = new DescriptorTreeNode((Descriptor)itr4.next(), true);
            treeModel.insertNodeInto(bundleNode, applicationNode, 0);
            this.updateConnectorBundleNode(bundleNode);
        }
    }

    public Application getApplicationDescriptor(Descriptor descriptor) {
        if (descriptor instanceof Application) {
            return (Application)descriptor;
        }
        BundleDescriptor bd2 = null;
        if (descriptor instanceof BundleDescriptor) {
            bd2 = (BundleDescriptor)descriptor;
        } else if (descriptor instanceof EjbDescriptor) {
            bd2 = ((EjbDescriptor)descriptor).getEjbBundleDescriptor();
        } else if (descriptor instanceof WebComponentDescriptorImpl) {
            bd2 = ((WebComponentDescriptorImpl)descriptor).getWebBundleDescriptor();
        }
        return bd2 == null ? null : bd2.getApplication();
    }

    public Descriptor getSelectedSaveableDescriptor() {
        Descriptor d10 = this.getSelectedDescriptor();
        if (d10 instanceof Application || d10 instanceof BundleDescriptor) {
            return d10;
        }
        if (d10 instanceof EjbDescriptor) {
            return ((EjbDescriptor)d10).getEjbBundleDescriptor();
        }
        if (d10 instanceof WebComponentDescriptorImpl) {
            return ((WebComponentDescriptorImpl)d10).getWebBundleDescriptor();
        }
        return null;
    }

    private void appNotification(NotificationEvent ne) {
        String name;
        String type = ne.getType();
        Object obj = ne.getValue(ApplicationManager.APPLICATION_PROPERTY);
        String string = name = obj instanceof Descriptor ? ((Descriptor)obj).getName() : null;
        if (type == null) {
            return;
        }
        if (!type.equals(ApplicationManager.LISTENER_ADDED)) {
            if (type.equals(ApplicationManager.APPLICATION_ADDED)) {
                this.updateForAdd((Descriptor)obj);
            } else if (type.equals(ApplicationManager.ACTIVE_CHANGED)) {
                this.updateForActive((Descriptor)obj);
            } else if (type.equals(ApplicationManager.APPLICATION_REMOVED)) {
                this.updateForRemove((Descriptor)obj);
            } else if (!type.equals(ApplicationManager.APPLICATION_LIST_CHANGED)) {
                if (type.equals(Descriptor.DESCRIPTOR_CHANGED)) {
                    this.updateAppChanged((Application)ne.getObjectThatChanged());
                } else {
                    UIUtils.debugPrintln("Uncaught App Notification: " + type);
                }
            }
        }
    }

    private void updateAppChanged(Application changedApp) {
        DefaultMutableTreeNode appNode = this.getNodeFor(changedApp);
        if (appNode == null) {
            return;
        }
        HashSet descriptorsInModel = new HashSet();
        descriptorsInModel.addAll(changedApp.getEjbBundleDescriptors());
        descriptorsInModel.addAll(changedApp.getWebBundleDescriptors());
        descriptorsInModel.addAll(changedApp.getApplicationClientDescriptors());
        descriptorsInModel.addAll(changedApp.getRarDescriptors());
        HashSet descriptorNodesInTree = new HashSet();
        descriptorNodesInTree.addAll(this.getSubNodesFor(appNode, class$com$sun$enterprise$deployment$BundleDescriptor == null ? (class$com$sun$enterprise$deployment$BundleDescriptor = DescriptorTreeView.class$("com.sun.enterprise.deployment.BundleDescriptor")) : class$com$sun$enterprise$deployment$BundleDescriptor));
        descriptorNodesInTree.addAll(this.getSubNodesFor(appNode, class$com$sun$enterprise$deployment$ApplicationClientDescriptor == null ? (class$com$sun$enterprise$deployment$ApplicationClientDescriptor = DescriptorTreeView.class$("com.sun.enterprise.deployment.ApplicationClientDescriptor")) : class$com$sun$enterprise$deployment$ApplicationClientDescriptor));
        descriptorNodesInTree.addAll(this.getSubNodesFor(appNode, class$com$sun$enterprise$deployment$ConnectorDescriptor == null ? (class$com$sun$enterprise$deployment$ConnectorDescriptor = DescriptorTreeView.class$("com.sun.enterprise.deployment.ConnectorDescriptor")) : class$com$sun$enterprise$deployment$ConnectorDescriptor));
        Iterator itr = descriptorNodesInTree.iterator();
        while (itr.hasNext()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)itr.next();
            if (descriptorsInModel.contains(node.getUserObject())) continue;
            this.getRootTreeModel().removeNodeFromParent(node);
        }
        Iterator itr2 = descriptorsInModel.iterator();
        while (itr2.hasNext()) {
            BundleDescriptor bd2 = (BundleDescriptor)itr2.next();
            DefaultMutableTreeNode bundleNode = this.findNodeForUserObject(descriptorNodesInTree, bd2);
            if (bundleNode == null) {
                bundleNode = new DescriptorTreeNode(bd2, true);
                this.getRootTreeModel().insertNodeInto(bundleNode, appNode, 0);
            }
            if (bd2 instanceof EjbBundleDescriptor) {
                this.updateEjbBundleNode(bundleNode);
                continue;
            }
            if (bd2 instanceof WebBundleDescriptor) {
                this.updateWebBundleNode(bundleNode);
                continue;
            }
            if (bd2 instanceof ApplicationClientDescriptor) continue;
            if (bd2 instanceof ConnectorDescriptor) {
                this.updateConnectorBundleNode(bundleNode);
                continue;
            }
            UIUtils.debugPrintln("Unknown descriptor class: " + bd2.getClass().getName());
        }
        this._checkDisplayNames(appNode);
        this.validate();
        this.rootTree.repaint();
    }

    private DefaultMutableTreeNode findNodeForUserObject(Set nodeSet, Object userObject) {
        Iterator itr = nodeSet.iterator();
        while (itr.hasNext()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)itr.next();
            if (!userObject.equals(node.getUserObject())) continue;
            return node;
        }
        return null;
    }

    private void addServerNode(ServerDescriptor server) {
        DefaultTreeModel treeModel = this.getRootTreeModel();
        ServerManager sm = DT.getServerManager();
        if (sm == null) {
            return;
        }
        DefaultMutableTreeNode serverRootNode = this.fixedServerNode;
        if (!this.fixedRootNode.isNodeChild(serverRootNode)) {
            treeModel.insertNodeInto(serverRootNode, this.fixedRootNode, this.fixedRootNode.getChildCount());
        }
        DescriptorTreeNode serverNode = new DescriptorTreeNode(server, true);
        treeModel.insertNodeInto(serverNode, serverRootNode, serverRootNode.getChildCount());
        try {
            Vector sa = sm.getApplicationNamesForServer(server.getName());
            Enumeration e10 = sa.elements();
            while (e10.hasMoreElements()) {
                String n2 = (String)e10.nextElement();
                DeployedAppDescriptor d10 = new DeployedAppDescriptor(n2);
                DescriptorTreeNode node = new DescriptorTreeNode(d10, false);
                treeModel.insertNodeInto(node, serverNode, serverNode.getChildCount());
            }
            Vector sc = sm.getConnectorNamesForServer(server.getName());
            Enumeration e11 = sc.elements();
            while (e11.hasMoreElements()) {
                String n3 = (String)e11.nextElement();
                if (n3.indexOf(":") >= 0) continue;
                DeployedObjectDescriptor d11 = new DeployedObjectDescriptor(n3, class$com$sun$enterprise$deployment$ConnectorDescriptor == null ? DescriptorTreeView.class$("com.sun.enterprise.deployment.ConnectorDescriptor") : class$com$sun$enterprise$deployment$ConnectorDescriptor);
                DescriptorTreeNode node = new DescriptorTreeNode(d11, false);
                treeModel.insertNodeInto(node, serverNode, serverNode.getChildCount());
            }
        }
        catch (ServerException se) {
            UIUtils.println("ServerException: " + se);
        }
    }

    public ServerDescriptor getServerDescriptorForName(String serverName) {
        DefaultMutableTreeNode subRoot = this.fixedServerNode;
        Enumeration<TreeNode> e10 = subRoot.children();
        while (e10.hasMoreElements()) {
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)e10.nextElement();
            ServerDescriptor d10 = (ServerDescriptor)tn.getUserObject();
            if (!d10.getName().equals(serverName)) continue;
            return d10;
        }
        return null;
    }

    private void serverNotification(NotificationEvent ne) {
        String type = ne.getType();
        Object name = ne.getValue(ServerManager.SERVER_PROPERTY);
        if (type == null) {
            return;
        }
        if (type.equals(ServerManager.SERVER_ADDED)) {
            this.updateForAdd(new ServerDescriptor((String)name));
        } else if (type.equals(ServerManager.SERVER_REMOVED)) {
            this.updateForRemove(this.getServerDescriptorForName((String)name));
        } else if (!type.equals(ServerManager.SERVER_SELECTED)) {
            if (type.equals(ServerManager.APP_DEPLOYED) || type.equals(ServerManager.SA_DEPLOYED)) {
                this.buildView(BUILDTREE_SERVER);
            } else if (type.equals(ServerManager.APP_UNDEPLOYED) || type.equals(ServerManager.SA_UNDEPLOYED)) {
                this.buildView(BUILDTREE_SERVER);
            } else if (!(type.equals(ServerManager.SERVER_LISTENER_ADDED) || type.equals(ServerManager.SERVER_LISTENER_REMOVED) || type.equals(ServerManager.NOTIFICATION_TYPE))) {
                UIUtils.debugPrintln("Uncaught Server Notification: " + type);
            }
        }
    }

    private void addStandAloneNode(Descriptor desc) {
        DefaultTreeModel treeModel = this.getRootTreeModel();
        DefaultMutableTreeNode standaloneRootNode = this.fixedStandAloneNode;
        if (!this.fixedFilesNode.isNodeChild(standaloneRootNode)) {
            treeModel.insertNodeInto(standaloneRootNode, this.fixedFilesNode, this.fixedFilesNode.isNodeChild(this.fixedApplicationNode) ? 1 : 0);
        }
        if (desc instanceof ConnectorDescriptor) {
            DescriptorTreeNode standaloneNode = new DescriptorTreeNode(desc, true);
            treeModel.insertNodeInto(standaloneNode, standaloneRootNode, standaloneRootNode.getChildCount());
            this.updateConnectorBundleNode(standaloneNode);
        } else if (desc instanceof Application) {
            this.addApplicationNode((Application)desc, standaloneRootNode);
        }
    }

    private void standaloneNotification(NotificationEvent ne) {
        String name;
        String type = ne.getType();
        Object obj = ne.getValue("StandAloneProperty");
        String string = name = obj instanceof Descriptor ? ((Descriptor)obj).getName() : null;
        if (type == null) {
            return;
        }
        if (type.equals("StandAloneAdded")) {
            this.updateForAdd((Descriptor)obj);
        } else if (type.equals("StandAloneRemoved")) {
            this.updateForRemove((Descriptor)obj);
        } else if (!type.equals("ListenerAdded")) {
            if (type.equals("ActiveChanged")) {
                this.updateForActive((Descriptor)obj);
            } else if (type.equals(Descriptor.DESCRIPTOR_CHANGED)) {
                Descriptor d10 = (Descriptor)ne.getObjectThatChanged();
                this._checkDisplayNames(this.getNodeFor(d10));
                this.validate();
                this.rootTree.repaint();
            } else {
                UIUtils.debugPrintln("Uncaught SA Notification: " + type);
            }
        }
    }

    public Vector getAllConnectorDescriptors() {
        ApplicationManager am2;
        Vector v2 = new Vector();
        StandAloneManager sm = DT.getStandAloneManager();
        if (sm != null) {
            Enumeration e10 = sm.getStandAlones().elements();
            while (e10.hasMoreElements()) {
                Object d10 = e10.nextElement();
                if (!(d10 instanceof ConnectorDescriptor)) continue;
                v2.add(d10);
            }
        }
        if ((am2 = DT.getApplicationManager()) != null) {
            Enumeration e11 = am2.getApplications().elements();
            while (e11.hasMoreElements()) {
                Application app = (Application)e11.nextElement();
                Iterator itr = app.getRarDescriptors().iterator();
                while (itr.hasNext()) {
                    Descriptor d11 = (Descriptor)itr.next();
                    v2.add(d11);
                }
            }
        }
        return v2;
    }

    public TreeCombo getDeployableObjectsCombo(String title, boolean showBorder) {
        DescriptorTreeNode filesRoot = new DescriptorTreeNode(new FilesRootDescriptor(), true);
        TreeCombo treeCombo = new TreeCombo(title, showBorder);
        treeCombo.setModel(new DefaultTreeModel(this.getDeployableObjectsComboNode(filesRoot)));
        return treeCombo;
    }

    public DefaultMutableTreeNode getDeployableObjectsComboNode(DefaultMutableTreeNode doRoot) {
        this.getStandAlonesComboNode(doRoot);
        this.getApplicationsComboNode(doRoot, AppType_Apps);
        return doRoot;
    }

    public TreeCombo getStandAlonesCombo() {
        DescriptorTreeNode saRoot = new DescriptorTreeNode(new StandAloneRootDescriptor(), true);
        return new TreeCombo(new DefaultTreeModel(this.getStandAlonesComboNode(saRoot)));
    }

    public DefaultMutableTreeNode getStandAlonesComboNode(DefaultMutableTreeNode saRoot) {
        StandAloneManager sm = DT.getStandAloneManager();
        if (sm != null) {
            Enumeration e10 = sm.getStandAlones().elements();
            while (e10.hasMoreElements()) {
                Descriptor d10 = (Descriptor)e10.nextElement();
                this.populateStandAloneComboNode(saRoot, d10);
            }
        }
        return saRoot;
    }

    private void populateStandAloneComboNode(DefaultMutableTreeNode saRoot, Descriptor desc) {
        if (desc instanceof ConnectorDescriptor) {
            DescriptorTreeNode saNode = new DescriptorTreeNode(desc, true);
            this.updateConnectorBundleNode(saNode);
            saRoot.add(saNode);
        } else if (desc instanceof Application) {
            DescriptorTreeNode appNode = new DescriptorTreeNode(desc, true);
            this.populateApplicationComboNode(saRoot, (Application)desc, AppType_Apps);
            saRoot.add(appNode);
        } else {
            UIUtils.printImplementationError("Unsupported descriptor type: " + desc.getClass().getName());
        }
    }

    public TreeModel getApplicationsComboModel(int appType) {
        DescriptorTreeNode r2 = new DescriptorTreeNode(new ApplicationsRootDescriptor(), true);
        return new DefaultTreeModel(this.getApplicationsComboNode(r2, appType));
    }

    public TreeCombo getApplicationsCombo(int appType) {
        return new TreeCombo(this.getApplicationsComboModel(appType));
    }

    private DefaultMutableTreeNode getApplicationsComboNode(DefaultMutableTreeNode appRoot, int appType) {
        ApplicationManager am2 = DT.getApplicationManager();
        if (am2 != null) {
            Enumeration e10 = am2.getApplications().elements();
            while (e10.hasMoreElements()) {
                Application app = (Application)e10.nextElement();
                if ((appType & AppType_Apps) == 0) {
                    this.populateApplicationComboNode(appRoot, app, appType);
                    continue;
                }
                DescriptorTreeNode appNode = new DescriptorTreeNode(app, true);
                this.populateApplicationComboNode(appNode, app, appType);
                appRoot.add(appNode);
            }
        }
        return appRoot;
    }

    private DefaultMutableTreeNode populateApplicationComboNode(DefaultMutableTreeNode appNode, Application application, int appType) {
        DescriptorTreeNode tn;
        Descriptor d10;
        Iterator itr;
        Application app;
        if (appType == AppType_AppsOnly) {
            return appNode;
        }
        Application application2 = app = (appType & AppType_Apps) == 0 ? application : null;
        if ((appType & AppType_EJB) != 0) {
            itr = application.getEjbBundleDescriptors().iterator();
            while (itr.hasNext()) {
                d10 = (Descriptor)itr.next();
                tn = new DescriptorTreeNode(app, d10, true);
                appNode.add(tn);
                if ((appType & AppType_EJB_sn) == 0) continue;
                this.updateEjbBundleComboNode(tn);
            }
        }
        if ((appType & AppType_WAR) != 0) {
            itr = application.getWebBundleDescriptors().iterator();
            while (itr.hasNext()) {
                d10 = (Descriptor)itr.next();
                tn = new DescriptorTreeNode(app, d10, true);
                appNode.add(tn);
                if ((appType & AppType_WAR_sn) == 0) continue;
                this.updateWebBundleComboNode(tn);
            }
        }
        if ((appType & AppType_Client) != 0) {
            itr = application.getApplicationClientDescriptors().iterator();
            while (itr.hasNext()) {
                d10 = (Descriptor)itr.next();
                tn = new DescriptorTreeNode(app, d10, true);
                appNode.add(tn);
            }
        }
        if ((appType & AppType_ResAdapt) != 0) {
            itr = application.getRarDescriptors().iterator();
            while (itr.hasNext()) {
                d10 = (Descriptor)itr.next();
                tn = new DescriptorTreeNode(app, d10, true);
                appNode.add(tn);
            }
        }
        return appNode;
    }

    protected void updateEjbBundleComboNode(DefaultMutableTreeNode childBundleNode) {
        EjbBundleDescriptor ebd = (EjbBundleDescriptor)childBundleNode.getUserObject();
        Vector list = new Vector();
        list.addAll(ebd.getEjbs());
        this.addBundleNode(null, childBundleNode, list);
    }

    protected void updateWebBundleComboNode(DefaultMutableTreeNode childBundleNode) {
        this.addBundleNode(null, childBundleNode, ((WebBundleDescriptor)childBundleNode.getUserObject()).getWebComponentDescriptorsSet());
    }

    public static Icon getIconForDescriptor(Object d10) {
        String n2;
        String s2;
        if (UIUtils.debugMode() && d10 instanceof ServerDescriptor && (s2 = DT.getServerManager().getCurrentServer()).equals(n2 = ((ServerDescriptor)d10).getName())) {
            return UIIcons.getIconFor(UIIcons.CURRENT_SERVER_ICON);
        }
        return UIIcons.getIconFor(d10);
    }

    public String toString() {
        return "Descrioptor Tree View";
    }

    public String getSelectionAsString() {
        TreePath selection = this.rootTree.getSelectionPath();
        if (selection == null) {
            return "";
        }
        StringBuffer selectionAsString = new StringBuffer("");
        Object[] elements = selection.getPath();
        if (elements.length > 0) {
            int i2 = 1;
            while (i2 < elements.length) {
                if (i2 > 1) {
                    selectionAsString.append(".");
                }
                selectionAsString.append(elements[i2].toString());
                ++i2;
            }
        }
        return selectionAsString.toString();
    }

    private void _checkDisplayNames(DefaultMutableTreeNode node) {
        DescriptorTreeNode dtn;
        if (node instanceof DescriptorTreeNode && (dtn = (DescriptorTreeNode)node).hasNameChanged()) {
            dtn.resetName();
            this._resizeNodeName(dtn);
        }
        if (node != null && node.getChildCount() > 0) {
            Enumeration<TreeNode> e10 = node.children();
            while (e10.hasMoreElements()) {
                TreeNode next = e10.nextElement();
                this._checkDisplayNames((DefaultMutableTreeNode)next);
            }
        }
    }

    private void _resizeNodeName(DefaultMutableTreeNode node) {
        TreePath tp = new TreePath(node.getPath());
        this.rootTree.setEditable(true);
        this.rootTree.startEditingAtPath(tp);
        this.rootTree.stopEditing();
        this.rootTree.setEditable(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        AppType_ClientOnly = AppType_Client = 2;
        AppType_Client_sn = 1;
        AppType_EJBOnly = AppType_EJB = 8;
        AppType_EJB_sn = 4;
        AppType_WAROnly = AppType_WAR = 32;
        AppType_WAR_sn = 16;
        AppType_ResAdaptOnly = AppType_ResAdapt = 128;
        AppType_ResAdapt_sn = 64;
        AppType_AppsOnly = AppType_Apps = 32768;
        AppType_AppsAndEJBs = AppType_Apps | AppType_EJB;
        AppType_AppsAndWars = AppType_Apps | AppType_WAR;
        AppType_AppsEjbsWars = AppType_Apps | AppType_EJB | AppType_WAR;
        BUILDTREE_APPLICATION = 1;
        BUILDTREE_STANDALONE = 2;
        BUILDTREE_SERVER = 4;
        BUILDTREE_ALL = 255;
        dbgDepCls = new String[]{"javax.swing.JFrame", "pkg.bogusClass"};
        dbgNdx = 0;
    }

    private class RootTreeCellEditor
    implements TreeCellEditor {
        private RootTreeCellEditor() {
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            return DescriptorTreeView.this.rootTree.getCellRenderer().getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, false);
        }

        public Object getCellEditorValue() {
            return DescriptorTreeView.FAKE_EDITOR_OBJECT;
        }

        public boolean isCellEditable(EventObject evt) {
            return true;
        }

        public boolean shouldSelectCell(EventObject event) {
            return false;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void cancelCellEditing() {
        }

        public void addCellEditorListener(CellEditorListener l2) {
        }

        public void removeCellEditorListener(CellEditorListener l2) {
        }
    }

    class RootTreeCellRenderer
    extends DefaultTreeCellRenderer {
        RootTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)value;
                Object obj = tn.getUserObject();
                Icon icon = DescriptorTreeView.getIconForDescriptor(obj);
                label.setIcon(icon);
            } else {
                label.setIcon(null);
            }
            return label;
        }
    }

    public static class RootTree
    extends JTree {
    }

    class DescriptorTreeNode
    extends DefaultMutableTreeNode {
        private Application app = null;
        private String lastName = "";

        public DescriptorTreeNode(Application app, Descriptor desc, boolean children) {
            super(desc, children);
            this.app = app;
            this.resetName();
        }

        public DescriptorTreeNode(Descriptor desc, boolean children) {
            this(null, desc, children);
        }

        public Descriptor getDescriptor() {
            return (Descriptor)super.getUserObject();
        }

        public String getName() {
            return this.getDescriptor().getName();
        }

        public String getLastName() {
            return this.lastName;
        }

        public boolean hasNameChanged() {
            return !this.lastName.equals(this.getName());
        }

        public void resetName() {
            this.lastName = this.getName();
        }

        public void setUserObject(Object obj) {
            if (DescriptorTreeView.FAKE_EDITOR_OBJECT.equals(obj)) {
                return;
            }
            if (!(obj instanceof Descriptor)) {
                String msg = obj != null ? obj.getClass().getName() : "null";
                UIUtils.debugImplementationError("Not a 'Descriptor': " + msg);
                return;
            }
            Object oldValue = super.getUserObject();
            if (oldValue != obj) {
                super.setUserObject(obj);
            }
        }

        public String toString() {
            return DescriptorTreeView.createNodeString(this.getDescriptor(), this.app);
        }
    }

    private class ServersRootDescriptor
    extends RootDescriptor {
        public ServersRootDescriptor() {
            super(SERV_DESCRIPTOR, UIIcons.getIconFor(UIIcons.SERVERS_ICON));
        }
    }

    private class StandAloneRootDescriptor
    extends RootDescriptor {
        public StandAloneRootDescriptor() {
            super(RAR_DESCRIPTOR, UIIcons.getUIManagerIcon("Tree.closedIcon"));
        }
    }

    private class ApplicationsRootDescriptor
    extends RootDescriptor {
        public ApplicationsRootDescriptor() {
            super(APPS_DESCRIPTOR, UIIcons.getUIManagerIcon("Tree.closedIcon"));
        }
    }

    private class FilesRootDescriptor
    extends RootDescriptor {
        public FilesRootDescriptor() {
            super(FILES_DESCRIPTOR, UIIcons.getUIManagerIcon("Tree.closedIcon"));
        }
    }

    private class GrandpaRootDescriptor
    extends RootDescriptor {
        public GrandpaRootDescriptor() {
            super("Root", UIIcons.getUIManagerIcon("Tree.closedIcon"));
        }
    }

    public class RootDescriptor
    extends Descriptor {
        Icon icon = null;

        public RootDescriptor(String n2, Icon icon) {
            super(n2, n2 + " Root Descriptor");
            this.icon = icon;
            if (this.icon == null) {
                icon = UIIcons.getDefaultIcon();
            }
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

