/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextArea;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DescriptionInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$DescriptionInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$DescriptionInspector = DescriptionInspector.class$("com.sun.enterprise.tools.deployment.ui.DescriptionInspector")) : class$com$sun$enterprise$tools$deployment$ui$DescriptionInspector);
    private static final String DESCRIPTION_TITLE = localStrings.getLocalString("ui.descriptioninspector.description_title", "Description");
    private static final String DESCRIPTION_TITLE_FOR = localStrings.getLocalString("ui.descriptioninspector.description_title_for", "Description for");
    private static final String DESCRIPTION_TEXT = localStrings.getLocalString("ui.descriptioninspector.description_button", "Description...");
    private static final String DESCRIPTION_LABEL = "D";
    private static String DESCRIPTION_ICON_YES = UIIcons.DESCRIPTION_ICON;
    private static String DESCRIPTION_ICON_NO = UIIcons.NO_DESCRIPTION_ICON;
    private static final String help_id = "Description";
    public static String DESCRIPTION_COLUMN_INIT = "*DESCRIPTION_INSPECTOR*";
    private static Vector descriptionInspectorList = new Vector();
    private static Rectangle lastFrameBounds = null;
    private DescriptionFrame descInspectorFrame = null;
    private UITitledControlButtonBox descInspectorPane = null;
    private DescriptionTextArea descInspectorText = null;
    private Window dialogOwner = null;
    private String originalDescription = "";
    private JButton descButton_OK = null;
    private JButton descButton_APPLY = null;
    private JButton descButton_CANCEL = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$DescriptionInspector;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$DescriptionInspector$DescriptionInspectorManager;

    private DescriptionInspector(Window owner) {
        this.dialogOwner = owner;
        descriptionInspectorList.add(this);
        this.initInspectorPane();
        this.dialogOwner.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent we) {
                boolean didHide = DescriptionInspector.this.hideOtherInspectors();
                if (didHide) {
                    DescriptionFrame frame = DescriptionInspector.this.initInspectorFrame();
                    ((Component)frame).setBounds(lastFrameBounds);
                    frame.setVisible(true);
                }
            }

            public void windowClosed(WindowEvent we) {
                descriptionInspectorList.remove(DescriptionInspector.this);
            }
        });
    }

    public DescriptionInspector(Frame owner) {
        this((Window)owner);
    }

    public DescriptionInspector(Dialog owner) {
        this((Window)owner);
    }

    private void initInspectorPane() {
        this.descInspectorPane = new UITitledControlButtonBox(null, false);
        this.descInspectorPane.setControlButtonLocation(15);
        this.descInspectorPane.setControlButtonAnchor(13);
        this.descInspectorPane.getGBConstraints().insets = new Insets(5, 5, 5, 5);
        this.descInspectorText = new DescriptionTextArea(false, true);
        this.descInspectorPane.setView(this.descInspectorText);
        ActionListener buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                String cmd = ae2.getActionCommand();
                if (cmd.equals("ok")) {
                    DescriptionInspector.this.originalDescription = DescriptionInspector.this.descInspectorText.getText();
                    DescriptionInspector.this.descInspectorText.updateDescriptionNow();
                    DescriptionInspector.this.cancelInspector(false);
                } else if (cmd.equals("apply")) {
                    DescriptionInspector.this.originalDescription = DescriptionInspector.this.descInspectorText.getText();
                    DescriptionInspector.this.descInspectorText.updateDescriptionNow();
                    DescriptionInspector.this.descButton_APPLY.setEnabled(false);
                } else if (cmd.equals("cancel")) {
                    DescriptionInspector.this.cancelInspector(false);
                }
            }
        };
        this.descButton_OK = UIButton.createOkButton(buttonListener);
        this.descButton_OK.setEnabled(false);
        this.descInspectorPane.addControlButton(this.descButton_OK);
        this.descButton_APPLY = UIButton.createApplyButton(buttonListener);
        this.descButton_APPLY.setEnabled(false);
        this.descInspectorPane.addControlButton(this.descButton_APPLY);
        this.descButton_CANCEL = UIButton.createCancelButton(buttonListener);
        this.descInspectorPane.addControlButton(this.descButton_CANCEL);
        this.descInspectorPane.addControlButton(new UIHelpButton(help_id));
        this.descInspectorText.getTextArea().addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent ke) {
                if (!DescriptionInspector.this.descButton_APPLY.isEnabled()) {
                    DescriptionInspector.this.descButton_APPLY.setEnabled(true);
                }
            }
        });
    }

    private DescriptionFrame initInspectorFrame() {
        if (this.descInspectorFrame == null) {
            Window window = UIUtils.getAncestorWindow(this.dialogOwner);
            if (window == null) {
                UIUtils.printImplementationError("DescriptionInspector.DescriptionFrame", "parent frame not found for component");
                return this.descInspectorFrame;
            }
            if (window instanceof Dialog) {
                this.descInspectorFrame = new DescriptionFrame((Dialog)window, (JPanel)this.descInspectorPane, this.descInspectorText);
                window.addWindowListener(new WindowAdapter(){

                    public void windowClosed(WindowEvent we) {
                        Dialog d10 = (Dialog)we.getSource();
                        if (DescriptionInspector.this.descInspectorFrame != null && d10 == DescriptionInspector.this.descInspectorFrame.getOwner()) {
                            DescriptionInspector.this.cancelInspector(true);
                        }
                    }
                });
            } else if (window instanceof Frame) {
                this.descInspectorFrame = new DescriptionFrame((Frame)window, (JPanel)this.descInspectorPane, this.descInspectorText);
            }
            if (lastFrameBounds == null) {
                Rectangle b10 = window.getBounds();
                Dimension d10 = this.descInspectorFrame.getPreferredSize();
                b10.x += 20;
                b10.y += 20;
                b10.width = d10.width;
                b10.height = d10.height;
                lastFrameBounds = b10;
            }
            ((Component)this.descInspectorFrame).setBounds(lastFrameBounds);
            this.descInspectorFrame.addComponentListener(new ComponentAdapter(){

                public void componentMoved(ComponentEvent ce2) {
                    lastFrameBounds = DescriptionInspector.this.descInspectorFrame.getBounds();
                }

                public void componentResized(ComponentEvent ce2) {
                    lastFrameBounds = DescriptionInspector.this.descInspectorFrame.getBounds();
                }
            });
        }
        this.descInspectorText.setText(this.originalDescription);
        this.descInspectorFrame.updateTitle();
        return this.descInspectorFrame;
    }

    private void cancelInspector(boolean dispose) {
        if (this.descInspectorFrame != null) {
            if (dispose) {
                this.descInspectorFrame.setContentPane(new JPanel());
                this.descInspectorFrame.dispose();
                this.descInspectorFrame = null;
            } else {
                this.descInspectorText.setText(this.originalDescription);
                this.hideInspector();
            }
        }
    }

    public void showDescriptionInspector() {
        this.initInspectorFrame().show();
    }

    public void hideInspector() {
        if (this.descInspectorFrame != null) {
            this.descInspectorFrame.hide();
        }
    }

    public boolean hideOtherInspectors() {
        boolean wasVisible = false;
        Enumeration enumeration = descriptionInspectorList.elements();
        while (enumeration.hasMoreElements()) {
            DescriptionInspector d10 = (DescriptionInspector)enumeration.nextElement();
            if (d10 == this || !d10.isInspectorVisible()) continue;
            wasVisible = true;
            d10.hideInspector();
        }
        return wasVisible;
    }

    public boolean isInspectorVisible() {
        return this.descInspectorFrame != null && this.descInspectorFrame.isShowing();
    }

    public void clearDescription() {
        this.setDescription(null, null, (Vector)null, null);
    }

    public void setDescription(String description, String refName, Vector updaterList, Object refObject) {
        this.originalDescription = updaterList != null && updaterList.size() > 0 ? description : "";
        this.descInspectorText.setDescription(description, refName, updaterList, refObject);
        if (this.descInspectorFrame != null) {
            this.descInspectorFrame.updateTitle();
        }
    }

    public void setDescription(String description, String refName, UpdateListener updater, Object ref) {
        this.originalDescription = description;
        this.descInspectorText.setDescription(description, refName, updater, ref);
        if (this.descInspectorFrame != null) {
            this.descInspectorFrame.updateTitle();
        }
    }

    public static DescriptionInspector findDescriptionInspector(Component comp) {
        DescriptionInspectorManager dim = (DescriptionInspectorManager)((Object)UIUtils.getAncestorOfClass(class$com$sun$enterprise$tools$deployment$ui$DescriptionInspector$DescriptionInspectorManager == null ? (class$com$sun$enterprise$tools$deployment$ui$DescriptionInspector$DescriptionInspectorManager = DescriptionInspector.class$("com.sun.enterprise.tools.deployment.ui.DescriptionInspector$DescriptionInspectorManager")) : class$com$sun$enterprise$tools$deployment$ui$DescriptionInspector$DescriptionInspectorManager, comp));
        if (dim != null) {
            return dim.getDescriptionInspector();
        }
        return null;
    }

    public static void addDescriptionColumnToTable(JTable table) {
        int modelColumnIndex = table.getModel().getColumnCount();
        int tableColumnIndex = table.getColumnCount();
        table.addColumn(new TableColumn(modelColumnIndex));
        DescriptionInspector.setDescriptionColumnForTable(table, modelColumnIndex);
    }

    public static void setDescriptionColumnForTable(JTable table, int column) {
        int columnWidth = 25;
        TableColumn descCol = table.getColumnModel().getColumn(column);
        descCol.setCellRenderer(new DescriptionCellRenderer());
        descCol.setCellEditor(new DescriptionCellEditor(table));
        descCol.setHeaderRenderer(new DescriptionColumnLabel());
        descCol.setMinWidth(columnWidth);
        descCol.setMaxWidth(columnWidth);
        descCol.setPreferredWidth(columnWidth);
        descCol.setResizable(false);
        table.sizeColumnsToFit(column);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String access$1200() {
        return DESCRIPTION_ICON_YES;
    }

    static /* synthetic */ String access$1300() {
        return DESCRIPTION_ICON_NO;
    }

    private static class DescriptionColumnLabel
    extends JLabel
    implements TableCellRenderer {
        private static final Icon columnIcon = DescriptionInspector.access$1200() != null ? UIIcons.getImageIconFor(DescriptionInspector.access$1200()) : null;

        public DescriptionColumnLabel() {
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            if (columnIcon != null) {
                this.setIcon(columnIcon);
            } else {
                this.setText(DescriptionInspector.DESCRIPTION_LABEL);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }

    private static class DescriptionCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private JTable table = null;

        public DescriptionCellEditor(JTable table) {
            super(new JCheckBox());
            this.table = table;
        }

        public boolean isCellEditable(EventObject anEvent) {
            DescriptionInspector din = DescriptionInspector.findDescriptionInspector(this.table);
            if (din != null) {
                din.showDescriptionInspector();
            } else {
                UIUtils.debugPrintln("DescriptionInspector not found!");
            }
            return false;
        }
    }

    private static class DescriptionCellRenderer
    implements TableCellRenderer {
        private DialogDisplayButton iconButton = new DialogDisplayButton(true);

        private DescriptionCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color selColor = isSelected ? table.getSelectionBackground() : table.getBackground();
            this.iconButton.setBackground(selColor);
            if (value == null) {
                this.iconButton.setHasDescription(false);
                return this.iconButton;
            }
            if (value instanceof Boolean) {
                this.iconButton.setHasDescription((Boolean)value);
                return this.iconButton;
            }
            if (value instanceof String) {
                this.iconButton.setHasDescription(!((String)value).equals(""));
                return this.iconButton;
            }
            UIUtils.printImplementationError("DescriptionInspector.DescriptionCellRenderer", "Unsupported value class '" + value.getClass().getName() + "'");
            return new JLabel(value.toString());
        }
    }

    public static class DialogDisplayButton
    extends JButton
    implements ActionListener {
        private static final Icon hasDescription_true = DescriptionInspector.access$1200() != null ? UIIcons.getImageIconFor(DescriptionInspector.access$1200()) : null;
        private static final Icon hasDescription_false = DescriptionInspector.access$1300() != null ? UIIcons.getImageIconFor(DescriptionInspector.access$1300()) : null;
        private InspectorPane inspectorPane = null;
        private boolean isIconButton = false;
        private boolean hasDescription = false;

        public DialogDisplayButton() {
            this(false);
        }

        public DialogDisplayButton(InspectorPane insp) {
            this(false);
            if (insp != null) {
                this.inspectorPane = insp;
                this.inspectorPane.addDescriptionButtonUpdate(this);
            }
        }

        public DialogDisplayButton(boolean isIconButton) {
            this.addActionListener(this);
            this.hasDescription = true;
            this.setHasDescription(false);
            this.isIconButton = isIconButton;
            if (this.isIconButton) {
                this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
                this.setMargin(new Insets(0, 0, 0, 0));
            } else {
                this.setText(DESCRIPTION_TEXT);
            }
        }

        public boolean hasDescription() {
            return this.hasDescription;
        }

        public void setHasDescription(boolean state) {
            if (this.hasDescription != state) {
                this.hasDescription = state;
                this.setIcon(state ? hasDescription_true : hasDescription_false);
            }
        }

        public void setDescriptionInspector(String description, String refName, UpdateListener listener, Object refObject) {
            if (this.inspectorPane != null) {
                this.inspectorPane._setDescriptionInspector(description, refName, listener, refObject);
            } else {
                DescriptionInspector din = DescriptionInspector.findDescriptionInspector(this);
                if (din != null) {
                    din.setDescription(description, refName, listener, refObject);
                }
            }
        }

        public void clearDescriptionInspector() {
            if (this.inspectorPane != null) {
                this.inspectorPane._clearDescriptionInspector();
            } else {
                DescriptionInspector din = DescriptionInspector.findDescriptionInspector(this);
                if (din != null) {
                    din.clearDescription();
                }
            }
        }

        public void actionPerformed(ActionEvent ae2) {
            Component comp = (Component)ae2.getSource();
            DescriptionInspector din = DescriptionInspector.findDescriptionInspector(comp);
            if (din != null) {
                din.showDescriptionInspector();
            } else {
                UIUtils.debugPrintln("DescriptionInspector not found!");
            }
        }
    }

    private class DescriptionFrame
    extends UIDialog {
        private DescriptionTextArea textArea = null;

        public DescriptionFrame(Frame frame, JPanel inspPane, DescriptionTextArea textArea) {
            super(frame, false);
            this.initFrame(inspPane, textArea);
        }

        public DescriptionFrame(Dialog dialog, JPanel inspPane, DescriptionTextArea textArea) {
            super(dialog, false);
            this.initFrame(inspPane, textArea);
        }

        private void initFrame(JPanel inspPane, DescriptionTextArea text) {
            this.textArea = text;
            this.setContentPane(inspPane);
            this.setDefaultCloseOperation(0);
        }

        public Dimension getPreferredSize() {
            return new Dimension(500, 205);
        }

        public void updateTitle() {
            String dn2 = this.textArea.getDescriptorName();
            this.setTitle(dn2 == null ? DESCRIPTION_TITLE : DESCRIPTION_TITLE_FOR + " " + dn2);
            DescriptionInspector.this.descButton_OK.setEnabled(this.textArea.getUpdaterList() != null);
            DescriptionInspector.this.descButton_APPLY.setEnabled(false);
        }
    }

    public static class DescriptionTextArea
    extends UITitledTextArea {
        private Vector updaterList = null;
        private UpdateListener updater = null;
        private String refName = null;
        private Object refObject = null;
        private boolean hasWindowFrame = false;

        public DescriptionTextArea() {
            this(false, false);
        }

        public DescriptionTextArea(boolean showBorder) {
            this(showBorder, false);
        }

        public DescriptionTextArea(boolean showBorder, boolean hasWindowFrame) {
            super(showBorder || !hasWindowFrame ? DESCRIPTION_TITLE : null, showBorder);
            this.hasWindowFrame = hasWindowFrame;
            this.clearDescription();
        }

        public void setDescription(String description, String refName, UpdateListener updater, Object refObject) {
            Vector<UpdateListener> list = new Vector<UpdateListener>();
            list.add(updater);
            this.setDescription(description, refName, list, refObject);
        }

        public void setDescription(String description, String refName, Vector updaterList, Object refObject) {
            this.updaterList = updaterList;
            if (this.updaterList != null) {
                Enumeration enumeration = this.updaterList.elements();
                while (enumeration.hasMoreElements()) {
                    if (enumeration.nextElement() != null) continue;
                    UIUtils.printImplementationError("DescriptionInspector.setDescription", "'updaterList' contains a null entry!");
                    break;
                }
                this.refName = refName;
                this.refObject = refObject;
                this.setEnabled(true);
                this.setText(description != null ? description : "");
            } else {
                this.refName = null;
                this.refObject = null;
                this.removeAllUpdateHandlers();
                this.setEnabled(false);
                this.setText("");
            }
            if (this.hasTitle()) {
                this.setTitle(this.refName == null ? DESCRIPTION_TITLE : DESCRIPTION_TITLE_FOR + " " + this.refName);
            }
        }

        public void clearDescription() {
            this.setDescription(null, null, (Vector)null, null);
        }

        public Vector getUpdaterList() {
            return this.updaterList;
        }

        public String getDescriptorName() {
            return this.refName;
        }

        public Object getReference() {
            return this.refObject;
        }

        public void setText(String text) {
            super.setText(text);
        }

        protected void updateComponent() {
            if (!this.hasWindowFrame) {
                this.updateDescriptionNow();
            }
        }

        protected void updateDescriptionNow() {
            if (this.updaterList != null) {
                Enumeration enumeration = this.updaterList.elements();
                while (enumeration.hasMoreElements()) {
                    Object obj = enumeration.nextElement();
                    if (obj instanceof UpdateListener) {
                        ((UpdateListener)obj).descriptionUpdated(this.getText(), this.getReference());
                        continue;
                    }
                    if (obj == null) {
                        UIUtils.debugPrintln("DescriptionTextArea.updateDescriptionNow", "'null' UpdateListener found!");
                        continue;
                    }
                    UIUtils.printImplementationError("DescriptionTextArea.updateDescriptionNow", "Class does not implement UpdateListener - " + obj.getClass().getName());
                }
            } else {
                UIUtils.printImplementationError("DescriptionTextArea.updateDescriptionNow", "updaterList == null !!!");
            }
        }
    }

    public static interface UpdateListener {
        public void descriptionUpdated(String var1, Object var2);
    }

    public static class DescriptionManagerDialog
    extends UIDialog
    implements DescriptionInspectorManager {
        private DescriptionInspector descriptionInspector = new DescriptionInspector(this);

        public static DescriptionManagerDialog newDialog(Component owner) {
            Window window = UIUtils.getAncestorWindow(owner);
            if (window instanceof Dialog) {
                return new DescriptionManagerDialog((Dialog)window, false);
            }
            if (window instanceof Frame) {
                return new DescriptionManagerDialog((Frame)window, false);
            }
            return null;
        }

        public DescriptionManagerDialog(Dialog d10, boolean m2) {
            super(d10, m2);
        }

        public DescriptionManagerDialog(Frame f2, boolean m2) {
            super(f2, m2);
        }

        public DescriptionInspector getDescriptionInspector() {
            return this.descriptionInspector;
        }
    }

    public static interface DescriptionInspectorManager {
        public DescriptionInspector getDescriptionInspector();
    }
}

